/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.AbstractIndirectPriorityQueue;
import it.unimi.dsi.fastutil.floats.FloatComparator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.util.NoSuchElementException;

public class FloatArrayIndirectPriorityQueue
extends AbstractIndirectPriorityQueue<Float> {
    protected float[] refArray;
    protected int[] array = IntArrays.EMPTY_ARRAY;
    protected int size;
    protected FloatComparator c;

    public FloatArrayIndirectPriorityQueue(float[] refArray, int capacity, FloatComparator c) {
        if (capacity > 0) {
            this.array = new int[capacity];
        }
        this.refArray = refArray;
        this.c = c;
    }

    public FloatArrayIndirectPriorityQueue(float[] refArray, int capacity) {
        this(refArray, capacity, null);
    }

    public FloatArrayIndirectPriorityQueue(float[] refArray, FloatComparator c) {
        this(refArray, refArray.length, c);
    }

    public FloatArrayIndirectPriorityQueue(float[] refArray) {
        this(refArray, refArray.length, null);
    }

    public FloatArrayIndirectPriorityQueue(float[] refArray, int[] a, int size, FloatComparator c) {
        this(refArray, 0, c);
        this.array = a;
        this.size = size;
    }

    public FloatArrayIndirectPriorityQueue(float[] refArray, int[] a, FloatComparator c) {
        this(refArray, a, a.length, c);
    }

    public FloatArrayIndirectPriorityQueue(float[] refArray, int[] a, int size) {
        this(refArray, a, size, null);
    }

    public FloatArrayIndirectPriorityQueue(float[] refArray, int[] a) {
        this(refArray, a, a.length);
    }

    private int findFirst() {
        int i = this.size;
        int firstIndex = --i;
        float first = this.refArray[this.array[firstIndex]];
        if (this.c == null) {
            while (i-- != 0) {
                if (!(this.refArray[this.array[i]] < first)) continue;
                firstIndex = i;
                first = this.refArray[this.array[firstIndex]];
            }
        } else {
            while (i-- != 0) {
                if (this.c.compare(this.refArray[this.array[i]], first) >= 0) continue;
                firstIndex = i;
                first = this.refArray[this.array[firstIndex]];
            }
        }
        return firstIndex;
    }

    private int findLast() {
        int i = this.size;
        int lastIndex = --i;
        float last = this.refArray[this.array[lastIndex]];
        if (this.c == null) {
            while (i-- != 0) {
                if (!(last < this.refArray[this.array[i]])) continue;
                lastIndex = i;
                last = this.refArray[this.array[lastIndex]];
            }
        } else {
            while (i-- != 0) {
                if (this.c.compare(last, this.refArray[this.array[i]]) >= 0) continue;
                lastIndex = i;
                last = this.refArray[this.array[lastIndex]];
            }
        }
        return lastIndex;
    }

    protected final void ensureNonEmpty() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
    }

    protected void ensureElement(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index >= this.refArray.length) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is larger than or equal to reference array size (" + this.refArray.length + ")");
        }
    }

    @Override
    public void enqueue(int x) {
        this.ensureElement(x);
        if (this.size == this.array.length) {
            this.array = IntArrays.grow(this.array, this.size + 1);
        }
        this.array[this.size++] = x;
    }

    @Override
    public int dequeue() {
        this.ensureNonEmpty();
        int first = this.findFirst();
        int result = this.array[first];
        if (--this.size != 0) {
            System.arraycopy(this.array, first + 1, this.array, first, this.size - first);
        }
        return result;
    }

    @Override
    public int first() {
        this.ensureNonEmpty();
        return this.array[this.findFirst()];
    }

    @Override
    public int last() {
        this.ensureNonEmpty();
        return this.array[this.findLast()];
    }

    @Override
    public void changed() {
        this.ensureNonEmpty();
    }

    @Override
    public void changed(int index) {
        this.ensureElement(index);
    }

    @Override
    public void allChanged() {
    }

    @Override
    public void remove(int index) {
        this.ensureElement(index);
        int[] a = this.array;
        int i = this.size;
        while (i-- != 0 && a[i] != index) {
        }
        if (i < 0) {
            throw new IllegalArgumentException("Index " + index + " does not belong to the queue");
        }
        if (--this.size != 0) {
            System.arraycopy(a, i + 1, a, i, this.size - i);
        }
    }

    @Override
    public int front(int[] a) {
        float top = this.refArray[this.array[this.findFirst()]];
        int i = this.size;
        int c = 0;
        while (i-- != 0) {
            if (top != this.refArray[this.array[i]]) continue;
            a[c++] = this.array[i];
        }
        return c;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public void trim() {
        this.array = IntArrays.trim(this.array, this.size);
    }

    public FloatComparator comparator() {
        return this.c;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("[");
        for (int i = 0; i < this.size; ++i) {
            if (i != 0) {
                s.append(", ");
            }
            s.append(this.refArray[this.array[i]]);
        }
        s.append("]");
        return s.toString();
    }
}

