/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.chars.AbstractChar2FloatMap;
import it.unimi.dsi.fastutil.chars.AbstractChar2FloatSortedMap;
import it.unimi.dsi.fastutil.chars.AbstractCharSortedSet;
import it.unimi.dsi.fastutil.chars.Char2FloatMap;
import it.unimi.dsi.fastutil.chars.Char2FloatSortedMap;
import it.unimi.dsi.fastutil.chars.CharBidirectionalIterator;
import it.unimi.dsi.fastutil.chars.CharComparator;
import it.unimi.dsi.fastutil.chars.CharListIterator;
import it.unimi.dsi.fastutil.chars.CharSortedSet;
import it.unimi.dsi.fastutil.floats.AbstractFloatCollection;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatListIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

public class Char2FloatLinkedOpenHashMap
extends AbstractChar2FloatSortedMap
implements Serializable,
Cloneable,
Hash {
    public static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient char[] key;
    protected transient float[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Char2FloatSortedMap.FastSortedEntrySet entries;
    protected volatile transient CharSortedSet keys;
    protected volatile transient FloatCollection values;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient int[] link;

    public Char2FloatLinkedOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new char[this.n];
        this.value = new float[this.n];
        this.used = new boolean[this.n];
        this.link = new int[this.n];
    }

    public Char2FloatLinkedOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Char2FloatLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Char2FloatLinkedOpenHashMap(Map<? extends Character, ? extends Float> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Char2FloatLinkedOpenHashMap(Map<? extends Character, ? extends Float> m) {
        this(m, 0.75f);
    }

    public Char2FloatLinkedOpenHashMap(Char2FloatMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Char2FloatLinkedOpenHashMap(Char2FloatMap m) {
        this(m, 0.75f);
    }

    public Char2FloatLinkedOpenHashMap(char[] k, float[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Char2FloatLinkedOpenHashMap(char[] k, float[] v) {
        this(k, v, 0.75f);
    }

    @Override
    public float put(char k, float v) {
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                float oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public Float put(Character ok, Float ov) {
        float v = ov.floatValue();
        char k = ok.charValue();
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                Float oldValue = Float.valueOf(this.value[pos]);
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return null;
    }

    public float add(char k, float incr) {
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                float oldValue = this.value[pos];
                int n = pos;
                this.value[n] = this.value[n] + incr;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = this.defRetValue + incr;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    protected final void shiftKeys(int pos) {
        while (true) {
            int last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = HashCommon.murmurHash3(this.key[pos]) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
            this.fixPointers(pos, last);
        }
        this.used[last] = false;
    }

    @Override
    public float remove(char k) {
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                --this.size;
                this.fixPointers(pos);
                float v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public Float remove(Object ok) {
        char k = ((Character)ok).charValue();
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                --this.size;
                this.fixPointers(pos);
                float v = this.value[pos];
                this.shiftKeys(pos);
                return Float.valueOf(v);
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    public Float get(Character ok) {
        char k = ok.charValue();
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                return Float.valueOf(this.value[pos]);
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    @Override
    public float get(char k) {
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public boolean containsKey(char k) {
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean containsValue(float v) {
        float[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
        this.last = -1;
        this.first = -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    protected void fixPointers(int i) {
        int next;
        if (this.size == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            int n = this.first = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        if (this.last == i) {
            int n = this.last = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != i) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (this.link[i] ^ i ^ j);
        int n2 = this.link[i] ^ j;
        this.link[n2] = this.link[n2] ^ (i ^ j);
    }

    protected void fixPointers(int s, int d) {
        int next;
        if (this.size == 1) {
            this.first = this.last = d;
            this.link[d] = 0;
            return;
        }
        if (this.first == s) {
            this.first = d;
            int n = ~this.link[s];
            this.link[n] = this.link[n] ^ (s ^ d);
            this.link[d] = this.link[s];
            return;
        }
        if (this.last == s) {
            this.last = d;
            int n = ~this.link[s];
            this.link[n] = this.link[n] ^ (s ^ d);
            this.link[d] = this.link[s];
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != s) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (s ^ d);
        int n2 = this.link[s] ^ j;
        this.link[n2] = this.link[n2] ^ (s ^ d);
        this.link[d] = this.link[s];
    }

    @Override
    public char firstCharKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public char lastCharKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public CharComparator comparator() {
        return null;
    }

    @Override
    public Char2FloatSortedMap tailMap(char from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Char2FloatSortedMap headMap(char to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Char2FloatSortedMap subMap(char from, char to) {
        throw new UnsupportedOperationException();
    }

    public Char2FloatSortedMap.FastSortedEntrySet char2FloatEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public CharSortedSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public FloatCollection values() {
        if (this.values == null) {
            this.values = new AbstractFloatCollection(){

                @Override
                public FloatIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Char2FloatLinkedOpenHashMap.this.size;
                }

                @Override
                public boolean contains(float v) {
                    return Char2FloatLinkedOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Char2FloatLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = this.first;
        int prev = -1;
        int newPrev = -1;
        char[] key = this.key;
        float[] value = this.value;
        int newMask = newN - 1;
        char[] newKey = new char[newN];
        float[] newValue = new float[newN];
        boolean[] newUsed = new boolean[newN];
        int[] link = this.link;
        int[] newLink = new int[newN];
        this.first = -1;
        int j = this.size;
        while (j-- != 0) {
            char k = key[i];
            int pos = HashCommon.murmurHash3(k) & newMask;
            while (newUsed[pos]) {
                pos = pos + 1 & newMask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            if (prev != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ pos;
                newLink[pos] = newPrev;
                newPrev = pos;
            } else {
                newPrev = this.first = pos;
                newLink[pos] = -1;
            }
            int t = i;
            i = link[i] ^ prev;
            prev = t;
        }
        this.n = newN;
        this.mask = newMask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = ~newLink[n];
        }
    }

    public Char2FloatLinkedOpenHashMap clone() {
        Char2FloatLinkedOpenHashMap c;
        try {
            c = (Char2FloatLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (char[])this.key.clone();
        c.value = (float[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        c.link = (int[])this.link.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            t = this.key[i];
            h += (t ^= HashCommon.float2int(this.value[i]));
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        char[] key = this.key;
        float[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeChar(key[e]);
            s.writeFloat(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new char[this.n];
        char[] key = this.key;
        this.value = new float[this.n];
        float[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        this.link = new int[this.n];
        int[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            char k = s.readChar();
            float v = s.readFloat();
            pos = HashCommon.murmurHash3(k) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
            if (this.first != -1) {
                int n = prev;
                link[n] = link[n] ^ pos;
                link[pos] = prev;
                prev = pos;
                continue;
            }
            prev = this.first = pos;
            link[pos] = -1;
        }
        this.last = prev;
        if (prev != -1) {
            int n = prev;
            link[n] = ~link[n];
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements FloatListIterator {
        @Override
        public float previousFloat() {
            return Char2FloatLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        @Override
        public Float previous() {
            return Float.valueOf(Char2FloatLinkedOpenHashMap.this.value[this.previousEntry()]);
        }

        @Override
        public void set(Float ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Float ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(float v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(float v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float nextFloat() {
            return Char2FloatLinkedOpenHashMap.this.value[this.nextEntry()];
        }

        @Override
        public Float next() {
            return Float.valueOf(Char2FloatLinkedOpenHashMap.this.value[this.nextEntry()]);
        }
    }

    private final class KeySet
    extends AbstractCharSortedSet {
        private KeySet() {
        }

        @Override
        public CharBidirectionalIterator iterator(char from) {
            return new KeyIterator(from);
        }

        @Override
        public CharBidirectionalIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Char2FloatLinkedOpenHashMap.this.size;
        }

        @Override
        public boolean contains(char k) {
            return Char2FloatLinkedOpenHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(char k) {
            int oldSize = Char2FloatLinkedOpenHashMap.this.size;
            Char2FloatLinkedOpenHashMap.this.remove(k);
            return Char2FloatLinkedOpenHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Char2FloatLinkedOpenHashMap.this.clear();
        }

        @Override
        public char firstChar() {
            if (Char2FloatLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Char2FloatLinkedOpenHashMap.this.key[Char2FloatLinkedOpenHashMap.this.first];
        }

        @Override
        public char lastChar() {
            if (Char2FloatLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Char2FloatLinkedOpenHashMap.this.key[Char2FloatLinkedOpenHashMap.this.last];
        }

        @Override
        public CharComparator comparator() {
            return null;
        }

        @Override
        public final CharSortedSet tailSet(char from) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final CharSortedSet headSet(char to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final CharSortedSet subSet(char from, char to) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements CharListIterator {
        public KeyIterator(char k) {
            super(k);
        }

        @Override
        public char previousChar() {
            return Char2FloatLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        @Override
        public void set(char k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(char k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Character previous() {
            return Character.valueOf(Char2FloatLinkedOpenHashMap.this.key[this.previousEntry()]);
        }

        @Override
        public void set(Character ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Character ok) {
            throw new UnsupportedOperationException();
        }

        public KeyIterator() {
        }

        @Override
        public char nextChar() {
            return Char2FloatLinkedOpenHashMap.this.key[this.nextEntry()];
        }

        @Override
        public Character next() {
            return Character.valueOf(Char2FloatLinkedOpenHashMap.this.key[this.nextEntry()]);
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSortedSet<Char2FloatMap.Entry>
    implements Char2FloatSortedMap.FastSortedEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectBidirectionalIterator<Char2FloatMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public Comparator<? super Char2FloatMap.Entry> comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Char2FloatMap.Entry> subSet(Char2FloatMap.Entry fromElement, Char2FloatMap.Entry toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Char2FloatMap.Entry> headSet(Char2FloatMap.Entry toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Char2FloatMap.Entry> tailSet(Char2FloatMap.Entry fromElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Char2FloatMap.Entry first() {
            if (Char2FloatLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Char2FloatLinkedOpenHashMap.this.first);
        }

        @Override
        public Char2FloatMap.Entry last() {
            if (Char2FloatLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Char2FloatLinkedOpenHashMap.this.last);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            char k = ((Character)e.getKey()).charValue();
            int pos = HashCommon.murmurHash3(k) & Char2FloatLinkedOpenHashMap.this.mask;
            while (Char2FloatLinkedOpenHashMap.this.used[pos]) {
                if (k == Char2FloatLinkedOpenHashMap.this.key[pos]) {
                    return Char2FloatLinkedOpenHashMap.this.value[pos] == ((Float)e.getValue()).floatValue();
                }
                pos = pos + 1 & Char2FloatLinkedOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            char k = ((Character)e.getKey()).charValue();
            int pos = HashCommon.murmurHash3(k) & Char2FloatLinkedOpenHashMap.this.mask;
            while (Char2FloatLinkedOpenHashMap.this.used[pos]) {
                if (k == Char2FloatLinkedOpenHashMap.this.key[pos]) {
                    Char2FloatLinkedOpenHashMap.this.remove(e.getKey());
                    return true;
                }
                pos = pos + 1 & Char2FloatLinkedOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public int size() {
            return Char2FloatLinkedOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Char2FloatLinkedOpenHashMap.this.clear();
        }

        @Override
        public ObjectBidirectionalIterator<Char2FloatMap.Entry> iterator(Char2FloatMap.Entry from) {
            return new EntryIterator(((Character)from.getKey()).charValue());
        }

        public ObjectBidirectionalIterator<Char2FloatMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public ObjectBidirectionalIterator<Char2FloatMap.Entry> fastIterator(Char2FloatMap.Entry from) {
            return new FastEntryIterator(((Character)from.getKey()).charValue());
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectListIterator<Char2FloatMap.Entry> {
        final AbstractChar2FloatMap.BasicEntry entry;

        public FastEntryIterator() {
            this.entry = new AbstractChar2FloatMap.BasicEntry('\u0000', 0.0f);
        }

        public FastEntryIterator(char from) {
            super(from);
            this.entry = new AbstractChar2FloatMap.BasicEntry('\u0000', 0.0f);
        }

        @Override
        public AbstractChar2FloatMap.BasicEntry next() {
            int e = this.nextEntry();
            this.entry.key = Char2FloatLinkedOpenHashMap.this.key[e];
            this.entry.value = Char2FloatLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public AbstractChar2FloatMap.BasicEntry previous() {
            int e = this.previousEntry();
            this.entry.key = Char2FloatLinkedOpenHashMap.this.key[e];
            this.entry.value = Char2FloatLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public void set(Char2FloatMap.Entry ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Char2FloatMap.Entry ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectListIterator<Char2FloatMap.Entry> {
        public EntryIterator() {
        }

        public EntryIterator(char from) {
            super(from);
        }

        @Override
        public MapEntry next() {
            return new MapEntry(this.nextEntry());
        }

        @Override
        public MapEntry previous() {
            return new MapEntry(this.previousEntry());
        }

        @Override
        public void set(Char2FloatMap.Entry ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Char2FloatMap.Entry ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = 0;

        private MapIterator() {
            this.next = Char2FloatLinkedOpenHashMap.this.first;
        }

        private MapIterator(char from) {
            if (Char2FloatLinkedOpenHashMap.this.key[Char2FloatLinkedOpenHashMap.this.last] == from) {
                this.prev = Char2FloatLinkedOpenHashMap.this.last;
                this.index = Char2FloatLinkedOpenHashMap.this.size;
            } else {
                int e;
                if (!Char2FloatLinkedOpenHashMap.this.containsKey(from)) {
                    throw new IllegalArgumentException("The key " + from + " does not belong to this set.");
                }
                this.next = Char2FloatLinkedOpenHashMap.this.first;
                while (Char2FloatLinkedOpenHashMap.this.key[e = this.nextEntry()] != from) {
                }
                this.curr = -1;
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                return Char2FloatLinkedOpenHashMap.this.size();
            }
            this.curr = this.next;
            this.next = Char2FloatLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            this.prev = this.curr;
            ++this.index;
            return this.curr;
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                return -1;
            }
            this.curr = this.prev;
            this.prev = Char2FloatLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            this.next = this.curr;
            --this.index;
            return this.curr;
        }

        public void remove() {
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
                this.prev = Char2FloatLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            } else {
                this.next = Char2FloatLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            }
            --Char2FloatLinkedOpenHashMap.this.size;
            if (this.prev == -1) {
                Char2FloatLinkedOpenHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                Char2FloatLinkedOpenHashMap.this.link[n] = Char2FloatLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.next);
            }
            if (this.next == -1) {
                Char2FloatLinkedOpenHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                Char2FloatLinkedOpenHashMap.this.link[n] = Char2FloatLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.prev);
            }
            int pos = this.curr;
            while (true) {
                int last = pos;
                pos = last + 1 & Char2FloatLinkedOpenHashMap.this.mask;
                while (Char2FloatLinkedOpenHashMap.this.used[pos]) {
                    int slot = HashCommon.murmurHash3(Char2FloatLinkedOpenHashMap.this.key[pos]) & Char2FloatLinkedOpenHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & Char2FloatLinkedOpenHashMap.this.mask;
                }
                if (!Char2FloatLinkedOpenHashMap.this.used[pos]) break;
                Char2FloatLinkedOpenHashMap.this.key[last] = Char2FloatLinkedOpenHashMap.this.key[pos];
                Char2FloatLinkedOpenHashMap.this.value[last] = Char2FloatLinkedOpenHashMap.this.value[pos];
                if (this.next == pos) {
                    this.next = last;
                }
                if (this.prev == pos) {
                    this.prev = last;
                }
                Char2FloatLinkedOpenHashMap.this.fixPointers(pos, last);
            }
            Char2FloatLinkedOpenHashMap.this.used[last] = false;
            this.curr = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }

        public int back(int n) {
            int i = n;
            while (i-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n - i - 1;
        }
    }

    private final class MapEntry
    implements Char2FloatMap.Entry,
    Map.Entry<Character, Float> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Character getKey() {
            return Character.valueOf(Char2FloatLinkedOpenHashMap.this.key[this.index]);
        }

        @Override
        public char getCharKey() {
            return Char2FloatLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public Float getValue() {
            return Float.valueOf(Char2FloatLinkedOpenHashMap.this.value[this.index]);
        }

        @Override
        public float getFloatValue() {
            return Char2FloatLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public float setValue(float v) {
            float oldValue = Char2FloatLinkedOpenHashMap.this.value[this.index];
            Char2FloatLinkedOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Float setValue(Float v) {
            return Float.valueOf(this.setValue(v.floatValue()));
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Char2FloatLinkedOpenHashMap.this.key[this.index] == ((Character)e.getKey()).charValue() && Char2FloatLinkedOpenHashMap.this.value[this.index] == ((Float)e.getValue()).floatValue();
        }

        @Override
        public int hashCode() {
            return Char2FloatLinkedOpenHashMap.this.key[this.index] ^ HashCommon.float2int(Char2FloatLinkedOpenHashMap.this.value[this.index]);
        }

        public String toString() {
            return Char2FloatLinkedOpenHashMap.this.key[this.index] + "=>" + Char2FloatLinkedOpenHashMap.this.value[this.index];
        }
    }
}

