/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.booleans.BooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.booleans.BooleanListIterator;
import it.unimi.dsi.fastutil.longs.AbstractLong2BooleanMap;
import it.unimi.dsi.fastutil.longs.AbstractLong2BooleanSortedMap;
import it.unimi.dsi.fastutil.longs.AbstractLongSortedSet;
import it.unimi.dsi.fastutil.longs.Long2BooleanMap;
import it.unimi.dsi.fastutil.longs.Long2BooleanSortedMap;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

public class Long2BooleanLinkedOpenHashMap
extends AbstractLong2BooleanSortedMap
implements Serializable,
Cloneable,
Hash {
    public static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient long[] key;
    protected transient boolean[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Long2BooleanSortedMap.FastSortedEntrySet entries;
    protected volatile transient LongSortedSet keys;
    protected volatile transient BooleanCollection values;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient int[] link;

    public Long2BooleanLinkedOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new long[this.n];
        this.value = new boolean[this.n];
        this.used = new boolean[this.n];
        this.link = new int[this.n];
    }

    public Long2BooleanLinkedOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Long2BooleanLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Long2BooleanLinkedOpenHashMap(Map<? extends Long, ? extends Boolean> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Long2BooleanLinkedOpenHashMap(Map<? extends Long, ? extends Boolean> m) {
        this(m, 0.75f);
    }

    public Long2BooleanLinkedOpenHashMap(Long2BooleanMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Long2BooleanLinkedOpenHashMap(Long2BooleanMap m) {
        this(m, 0.75f);
    }

    public Long2BooleanLinkedOpenHashMap(long[] k, boolean[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Long2BooleanLinkedOpenHashMap(long[] k, boolean[] v) {
        this(k, v, 0.75f);
    }

    @Override
    public boolean put(long k, boolean v) {
        long[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (int)HashCommon.murmurHash3(k) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (used[pos]) {
            boolean oldValue = this.value[pos];
            this.value[pos] = v;
            return oldValue;
        }
        used[pos] = true;
        key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public Boolean put(Long ok, Boolean ov) {
        boolean v = ov;
        long k = ok;
        long[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (int)HashCommon.murmurHash3(k) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (used[pos]) {
            Boolean oldValue = this.value[pos];
            this.value[pos] = v;
            return oldValue;
        }
        used[pos] = true;
        key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return null;
    }

    protected final void shiftKeys(int pos) {
        while (true) {
            int last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = (int)HashCommon.murmurHash3(this.key[pos]) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
            this.fixPointers(pos, last);
        }
        this.used[last] = false;
    }

    @Override
    public boolean remove(long k) {
        long[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (int)HashCommon.murmurHash3(k) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (!used[pos]) {
            return this.defRetValue;
        }
        --this.size;
        this.fixPointers(pos);
        boolean v = this.value[pos];
        this.shiftKeys(pos);
        return v;
    }

    @Override
    public Boolean remove(Object ok) {
        long k = (Long)ok;
        long[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (int)HashCommon.murmurHash3(k) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (!used[pos]) {
            return null;
        }
        --this.size;
        this.fixPointers(pos);
        boolean v = this.value[pos];
        this.shiftKeys(pos);
        return v;
    }

    public Boolean get(Long ok) {
        long k = ok;
        long[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (int)HashCommon.murmurHash3(k) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        return used[pos] ? Boolean.valueOf(this.value[pos]) : null;
    }

    @Override
    public boolean get(long k) {
        long[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (int)HashCommon.murmurHash3(k) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        return used[pos] ? this.value[pos] : this.defRetValue;
    }

    @Override
    public boolean containsKey(long k) {
        long[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (int)HashCommon.murmurHash3(k) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        return used[pos];
    }

    @Override
    public boolean containsValue(boolean v) {
        boolean[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
        this.last = -1;
        this.first = -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    protected void fixPointers(int i) {
        int next;
        if (this.size == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            int n = this.first = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        if (this.last == i) {
            int n = this.last = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != i) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (this.link[i] ^ i ^ j);
        int n2 = this.link[i] ^ j;
        this.link[n2] = this.link[n2] ^ (i ^ j);
    }

    protected void fixPointers(int s, int d) {
        int next;
        if (this.size == 1) {
            this.first = this.last = d;
            this.link[d] = 0;
            return;
        }
        if (this.first == s) {
            this.first = d;
            int n = ~this.link[s];
            this.link[n] = this.link[n] ^ (s ^ d);
            this.link[d] = this.link[s];
            return;
        }
        if (this.last == s) {
            this.last = d;
            int n = ~this.link[s];
            this.link[n] = this.link[n] ^ (s ^ d);
            this.link[d] = this.link[s];
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != s) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (s ^ d);
        int n2 = this.link[s] ^ j;
        this.link[n2] = this.link[n2] ^ (s ^ d);
        this.link[d] = this.link[s];
    }

    @Override
    public long firstLongKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public long lastLongKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public LongComparator comparator() {
        return null;
    }

    @Override
    public Long2BooleanSortedMap tailMap(long from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long2BooleanSortedMap headMap(long to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long2BooleanSortedMap subMap(long from, long to) {
        throw new UnsupportedOperationException();
    }

    public Long2BooleanSortedMap.FastSortedEntrySet long2BooleanEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public LongSortedSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public BooleanCollection values() {
        if (this.values == null) {
            this.values = new AbstractBooleanCollection(){

                @Override
                public BooleanIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Long2BooleanLinkedOpenHashMap.this.size;
                }

                @Override
                public boolean contains(boolean v) {
                    return Long2BooleanLinkedOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Long2BooleanLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = this.first;
        int prev = -1;
        int newPrev = -1;
        long[] key = this.key;
        boolean[] value = this.value;
        int newMask = newN - 1;
        long[] newKey = new long[newN];
        boolean[] newValue = new boolean[newN];
        boolean[] newUsed = new boolean[newN];
        int[] link = this.link;
        int[] newLink = new int[newN];
        this.first = -1;
        int j = this.size;
        while (j-- != 0) {
            long k = key[i];
            int pos = (int)HashCommon.murmurHash3(k) & newMask;
            while (newUsed[pos]) {
                pos = pos + 1 & newMask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            if (prev != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ pos;
                newLink[pos] = newPrev;
                newPrev = pos;
            } else {
                newPrev = this.first = pos;
                newLink[pos] = -1;
            }
            int t = i;
            i = link[i] ^ prev;
            prev = t;
        }
        this.n = newN;
        this.mask = newMask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = ~newLink[n];
        }
    }

    public Long2BooleanLinkedOpenHashMap clone() {
        Long2BooleanLinkedOpenHashMap c;
        try {
            c = (Long2BooleanLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (long[])this.key.clone();
        c.value = (boolean[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        c.link = (int[])this.link.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            t = HashCommon.long2int(this.key[i]);
            h += (t ^= this.value[i] ? 1231 : 1237);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        long[] key = this.key;
        boolean[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeLong(key[e]);
            s.writeBoolean(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new long[this.n];
        long[] key = this.key;
        this.value = new boolean[this.n];
        boolean[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        this.link = new int[this.n];
        int[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            long k = s.readLong();
            boolean v = s.readBoolean();
            pos = (int)HashCommon.murmurHash3(k) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
            if (this.first != -1) {
                int n = prev;
                link[n] = link[n] ^ pos;
                link[pos] = prev;
                prev = pos;
                continue;
            }
            prev = this.first = pos;
            link[pos] = -1;
        }
        this.last = prev;
        if (prev != -1) {
            int n = prev;
            link[n] = ~link[n];
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements BooleanListIterator {
        @Override
        public boolean previousBoolean() {
            return Long2BooleanLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        @Override
        public Boolean previous() {
            return Long2BooleanLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        @Override
        public void set(Boolean ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Boolean ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(boolean v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(boolean v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean nextBoolean() {
            return Long2BooleanLinkedOpenHashMap.this.value[this.nextEntry()];
        }

        @Override
        public Boolean next() {
            return Long2BooleanLinkedOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractLongSortedSet {
        private KeySet() {
        }

        @Override
        public LongBidirectionalIterator iterator(long from) {
            return new KeyIterator(from);
        }

        @Override
        public LongBidirectionalIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Long2BooleanLinkedOpenHashMap.this.size;
        }

        @Override
        public boolean contains(long k) {
            return Long2BooleanLinkedOpenHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(long k) {
            int oldSize = Long2BooleanLinkedOpenHashMap.this.size;
            Long2BooleanLinkedOpenHashMap.this.remove(k);
            return Long2BooleanLinkedOpenHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Long2BooleanLinkedOpenHashMap.this.clear();
        }

        @Override
        public long firstLong() {
            if (Long2BooleanLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Long2BooleanLinkedOpenHashMap.this.key[Long2BooleanLinkedOpenHashMap.this.first];
        }

        @Override
        public long lastLong() {
            if (Long2BooleanLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Long2BooleanLinkedOpenHashMap.this.key[Long2BooleanLinkedOpenHashMap.this.last];
        }

        @Override
        public LongComparator comparator() {
            return null;
        }

        @Override
        public final LongSortedSet tailSet(long from) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final LongSortedSet headSet(long to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final LongSortedSet subSet(long from, long to) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements LongListIterator {
        public KeyIterator(long k) {
            super(k);
        }

        @Override
        public long previousLong() {
            return Long2BooleanLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        @Override
        public void set(long k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(long k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long previous() {
            return Long2BooleanLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        @Override
        public void set(Long ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Long ok) {
            throw new UnsupportedOperationException();
        }

        public KeyIterator() {
        }

        @Override
        public long nextLong() {
            return Long2BooleanLinkedOpenHashMap.this.key[this.nextEntry()];
        }

        @Override
        public Long next() {
            return Long2BooleanLinkedOpenHashMap.this.key[this.nextEntry()];
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSortedSet<Long2BooleanMap.Entry>
    implements Long2BooleanSortedMap.FastSortedEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectBidirectionalIterator<Long2BooleanMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public Comparator<? super Long2BooleanMap.Entry> comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Long2BooleanMap.Entry> subSet(Long2BooleanMap.Entry fromElement, Long2BooleanMap.Entry toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Long2BooleanMap.Entry> headSet(Long2BooleanMap.Entry toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Long2BooleanMap.Entry> tailSet(Long2BooleanMap.Entry fromElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long2BooleanMap.Entry first() {
            if (Long2BooleanLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Long2BooleanLinkedOpenHashMap.this.first);
        }

        @Override
        public Long2BooleanMap.Entry last() {
            if (Long2BooleanLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Long2BooleanLinkedOpenHashMap.this.last);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            long k = (Long)e.getKey();
            long[] key = Long2BooleanLinkedOpenHashMap.this.key;
            boolean[] used = Long2BooleanLinkedOpenHashMap.this.used;
            int mask = Long2BooleanLinkedOpenHashMap.this.mask;
            int pos = (int)HashCommon.murmurHash3(k) & mask;
            while (used[pos] && k != key[pos]) {
                pos = pos + 1 & mask;
            }
            return used[pos] && Long2BooleanLinkedOpenHashMap.this.value[pos] == (Boolean)e.getValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            long k = (Long)e.getKey();
            long[] key = Long2BooleanLinkedOpenHashMap.this.key;
            boolean[] used = Long2BooleanLinkedOpenHashMap.this.used;
            int mask = Long2BooleanLinkedOpenHashMap.this.mask;
            int pos = (int)HashCommon.murmurHash3(k) & mask;
            while (used[pos] && k != key[pos]) {
                pos = pos + 1 & mask;
            }
            if (used[pos]) {
                Long2BooleanLinkedOpenHashMap.this.remove(e.getKey());
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return Long2BooleanLinkedOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Long2BooleanLinkedOpenHashMap.this.clear();
        }

        @Override
        public ObjectBidirectionalIterator<Long2BooleanMap.Entry> iterator(Long2BooleanMap.Entry from) {
            return new EntryIterator((Long)from.getKey());
        }

        public ObjectBidirectionalIterator<Long2BooleanMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public ObjectBidirectionalIterator<Long2BooleanMap.Entry> fastIterator(Long2BooleanMap.Entry from) {
            return new FastEntryIterator((Long)from.getKey());
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectListIterator<Long2BooleanMap.Entry> {
        final AbstractLong2BooleanMap.BasicEntry entry;

        public FastEntryIterator() {
            this.entry = new AbstractLong2BooleanMap.BasicEntry(0L, false);
        }

        public FastEntryIterator(long from) {
            super(from);
            this.entry = new AbstractLong2BooleanMap.BasicEntry(0L, false);
        }

        @Override
        public AbstractLong2BooleanMap.BasicEntry next() {
            int e = this.nextEntry();
            this.entry.key = Long2BooleanLinkedOpenHashMap.this.key[e];
            this.entry.value = Long2BooleanLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public AbstractLong2BooleanMap.BasicEntry previous() {
            int e = this.previousEntry();
            this.entry.key = Long2BooleanLinkedOpenHashMap.this.key[e];
            this.entry.value = Long2BooleanLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public void set(Long2BooleanMap.Entry ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Long2BooleanMap.Entry ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectListIterator<Long2BooleanMap.Entry> {
        public EntryIterator() {
        }

        public EntryIterator(long from) {
            super(from);
        }

        @Override
        public MapEntry next() {
            return new MapEntry(this.nextEntry());
        }

        @Override
        public MapEntry previous() {
            return new MapEntry(this.previousEntry());
        }

        @Override
        public void set(Long2BooleanMap.Entry ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Long2BooleanMap.Entry ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = 0;

        private MapIterator() {
            this.next = Long2BooleanLinkedOpenHashMap.this.first;
        }

        private MapIterator(long from) {
            if (Long2BooleanLinkedOpenHashMap.this.key[Long2BooleanLinkedOpenHashMap.this.last] == from) {
                this.prev = Long2BooleanLinkedOpenHashMap.this.last;
                this.index = Long2BooleanLinkedOpenHashMap.this.size;
            } else {
                int e;
                if (!Long2BooleanLinkedOpenHashMap.this.containsKey(from)) {
                    throw new IllegalArgumentException("The key " + from + " does not belong to this set.");
                }
                this.next = Long2BooleanLinkedOpenHashMap.this.first;
                while (Long2BooleanLinkedOpenHashMap.this.key[e = this.nextEntry()] != from) {
                }
                this.curr = -1;
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                return Long2BooleanLinkedOpenHashMap.this.size();
            }
            this.curr = this.next;
            this.next = Long2BooleanLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            this.prev = this.curr;
            ++this.index;
            return this.curr;
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                return -1;
            }
            this.curr = this.prev;
            this.prev = Long2BooleanLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            this.next = this.curr;
            --this.index;
            return this.curr;
        }

        public void remove() {
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
                this.prev = Long2BooleanLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            } else {
                this.next = Long2BooleanLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            }
            --Long2BooleanLinkedOpenHashMap.this.size;
            if (this.prev == -1) {
                Long2BooleanLinkedOpenHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                Long2BooleanLinkedOpenHashMap.this.link[n] = Long2BooleanLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.next);
            }
            if (this.next == -1) {
                Long2BooleanLinkedOpenHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                Long2BooleanLinkedOpenHashMap.this.link[n] = Long2BooleanLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.prev);
            }
            int pos = this.curr;
            while (true) {
                int last = pos;
                pos = last + 1 & Long2BooleanLinkedOpenHashMap.this.mask;
                while (Long2BooleanLinkedOpenHashMap.this.used[pos]) {
                    int slot = (int)HashCommon.murmurHash3(Long2BooleanLinkedOpenHashMap.this.key[pos]) & Long2BooleanLinkedOpenHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & Long2BooleanLinkedOpenHashMap.this.mask;
                }
                if (!Long2BooleanLinkedOpenHashMap.this.used[pos]) break;
                Long2BooleanLinkedOpenHashMap.this.key[last] = Long2BooleanLinkedOpenHashMap.this.key[pos];
                Long2BooleanLinkedOpenHashMap.this.value[last] = Long2BooleanLinkedOpenHashMap.this.value[pos];
                if (this.next == pos) {
                    this.next = last;
                }
                if (this.prev == pos) {
                    this.prev = last;
                }
                Long2BooleanLinkedOpenHashMap.this.fixPointers(pos, last);
            }
            Long2BooleanLinkedOpenHashMap.this.used[last] = false;
            this.curr = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }

        public int back(int n) {
            int i = n;
            while (i-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n - i - 1;
        }
    }

    private final class MapEntry
    implements Long2BooleanMap.Entry,
    Map.Entry<Long, Boolean> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Long getKey() {
            return Long2BooleanLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public long getLongKey() {
            return Long2BooleanLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public Boolean getValue() {
            return Long2BooleanLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public boolean getBooleanValue() {
            return Long2BooleanLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public boolean setValue(boolean v) {
            boolean oldValue = Long2BooleanLinkedOpenHashMap.this.value[this.index];
            Long2BooleanLinkedOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Boolean setValue(Boolean v) {
            return this.setValue((boolean)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Long2BooleanLinkedOpenHashMap.this.key[this.index] == (Long)e.getKey() && Long2BooleanLinkedOpenHashMap.this.value[this.index] == (Boolean)e.getValue();
        }

        @Override
        public int hashCode() {
            return HashCommon.long2int(Long2BooleanLinkedOpenHashMap.this.key[this.index]) ^ (Long2BooleanLinkedOpenHashMap.this.value[this.index] ? 1231 : 1237);
        }

        public String toString() {
            return Long2BooleanLinkedOpenHashMap.this.key[this.index] + "=>" + Long2BooleanLinkedOpenHashMap.this.value[this.index];
        }
    }
}

