/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.ints.AbstractIntBigList;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;

public class MappedIntBigList
extends AbstractIntBigList {
    private static int LOG2_BITS = 63 - Long.numberOfLeadingZeros(4L);
    private static int CHUNK_SHIFT = 30 - LOG2_BITS;
    public static final long CHUNK_SIZE = 1L << CHUNK_SHIFT;
    private static final long CHUNK_MASK = CHUNK_SIZE - 1L;
    private final IntBuffer[] IntBuffer;
    private final boolean[] readyToUse;
    private final int n;
    private final long size;

    protected MappedIntBigList(IntBuffer[] IntBuffer2, long size, boolean[] readyToUse) {
        this.IntBuffer = IntBuffer2;
        this.n = IntBuffer2.length;
        this.size = size;
        this.readyToUse = readyToUse;
        for (int i = 0; i < this.n; ++i) {
            if (i >= this.n - 1 || (long)IntBuffer2[i].capacity() == CHUNK_SIZE) continue;
            throw new IllegalArgumentException();
        }
    }

    public static MappedIntBigList map(FileChannel fileChannel) throws IOException {
        return MappedIntBigList.map(fileChannel, ByteOrder.BIG_ENDIAN);
    }

    public static MappedIntBigList map(FileChannel fileChannel, ByteOrder byteOrder) throws IOException {
        return MappedIntBigList.map(fileChannel, byteOrder, FileChannel.MapMode.READ_ONLY);
    }

    public static MappedIntBigList map(FileChannel fileChannel, ByteOrder byteOrder, FileChannel.MapMode mapMode) throws IOException {
        long size = fileChannel.size() / 4L;
        int chunks = (int)((size + (CHUNK_SIZE - 1L)) / CHUNK_SIZE);
        IntBuffer[] IntBuffer2 = new IntBuffer[chunks];
        for (int i = 0; i < chunks; ++i) {
            IntBuffer2[i] = fileChannel.map(mapMode, (long)i * CHUNK_SIZE * 4L, Math.min(CHUNK_SIZE, size - (long)i * CHUNK_SIZE) * 4L).order(byteOrder).asIntBuffer();
        }
        boolean[] readyToUse = new boolean[chunks];
        Arrays.fill(readyToUse, true);
        return new MappedIntBigList(IntBuffer2, size, readyToUse);
    }

    private IntBuffer IntBuffer(int n) {
        if (this.readyToUse[n]) {
            return this.IntBuffer[n];
        }
        this.readyToUse[n] = true;
        this.IntBuffer[n] = this.IntBuffer[n].duplicate();
        return this.IntBuffer[n];
    }

    public MappedIntBigList copy() {
        return new MappedIntBigList((IntBuffer[])this.IntBuffer.clone(), this.size, new boolean[this.n]);
    }

    @Override
    public int getInt(long index) {
        return this.IntBuffer((int)(index >>> CHUNK_SHIFT)).get((int)(index & CHUNK_MASK));
    }

    @Override
    public void getElements(long from, int[] a, int offset, int length) {
        int chunk = (int)(from >>> CHUNK_SHIFT);
        int displ = (int)(from & CHUNK_MASK);
        while (length > 0) {
            IntBuffer b = this.IntBuffer(chunk);
            int l = Math.min(b.capacity() - displ, length);
            if (l == 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            b.position(displ);
            b.get(a, offset, l);
            if ((long)(displ += l) == CHUNK_SIZE) {
                displ = 0;
                ++chunk;
            }
            offset += l;
            length -= l;
        }
    }

    @Override
    public int set(long index, int value) {
        IntBuffer b = this.IntBuffer((int)(index >>> CHUNK_SHIFT));
        int i = (int)(index & CHUNK_MASK);
        int previousValue = b.get(i);
        b.put(i, value);
        return previousValue;
    }

    @Override
    public long size64() {
        return this.size;
    }
}

