/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util;

import it.unimi.dsi.fastutil.objects.Object2ObjectFunction;
import it.unimi.dsi.fastutil.objects.Object2ObjectFunctions;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.unimi.dsi.util.Interval;
import it.unimi.dsi.util.PrefixMap;
import it.unimi.dsi.util.StringMap;
import java.io.Serializable;

public class StringMaps {
    private StringMaps() {
    }

    public static <T extends CharSequence> StringMap<T> synchronize(StringMap<T> stringMap) {
        return stringMap instanceof PrefixMap ? new SynchronizedPrefixMap((PrefixMap)stringMap) : new SynchronizedStringMap<T>(stringMap);
    }

    public static <T extends CharSequence> PrefixMap<T> synchronize(PrefixMap<T> prefixMap) {
        return new SynchronizedPrefixMap<T>(prefixMap);
    }

    protected static class SynchronizedPrefixMap<S extends CharSequence>
    extends SynchronizedStringMap<S>
    implements PrefixMap<S>,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected final PrefixMap<S> map;
        protected Object2ObjectFunction<Interval, S> prefixMap;
        protected Object2ObjectFunction<CharSequence, Interval> rangeMap;

        public SynchronizedPrefixMap(PrefixMap<S> map) {
            super(map);
            this.map = map;
        }

        @Override
        public synchronized Object2ObjectFunction<Interval, S> prefixMap() {
            if (this.prefixMap == null) {
                this.prefixMap = this.map.prefixMap();
                if (this.prefixMap != null) {
                    this.prefixMap = Object2ObjectFunctions.synchronize(this.prefixMap, (Object)this);
                }
            }
            return this.prefixMap;
        }

        @Override
        public synchronized Object2ObjectFunction<CharSequence, Interval> rangeMap() {
            if (this.rangeMap == null) {
                this.rangeMap = this.map.rangeMap();
                if (this.rangeMap != null) {
                    this.rangeMap = Object2ObjectFunctions.synchronize(this.rangeMap, (Object)this);
                }
            }
            return this.rangeMap;
        }
    }

    protected static class SynchronizedStringMap<S extends CharSequence>
    implements StringMap<S>,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected final StringMap<S> stringMap;
        protected ObjectList<? extends S> list;

        public SynchronizedStringMap(StringMap<S> stringMap) {
            this.stringMap = stringMap;
        }

        public synchronized int size() {
            return this.stringMap.size();
        }

        @Override
        public synchronized ObjectList<? extends S> list() {
            if (this.list == null) {
                this.list = this.stringMap.list();
                if (this.list != null) {
                    this.list = ObjectLists.synchronize(this.list, (Object)this);
                }
            }
            return this.list;
        }

        public synchronized long getLong(Object s) {
            return this.stringMap.getLong(s);
        }

        public synchronized Long get(Object key) {
            return this.stringMap.get(key);
        }

        public synchronized long put(CharSequence key, long value) {
            return this.stringMap.put(key, value);
        }

        public synchronized Long put(CharSequence key, Long value) {
            return this.stringMap.put(key, value);
        }

        public synchronized Long remove(Object key) {
            return this.stringMap.remove(key);
        }

        public synchronized long removeLong(Object key) {
            return this.stringMap.removeLong(key);
        }

        public synchronized void clear() {
            this.stringMap.clear();
        }

        public synchronized boolean containsKey(Object key) {
            return this.stringMap.containsKey(key);
        }

        public synchronized long defaultReturnValue() {
            return this.stringMap.defaultReturnValue();
        }

        public synchronized void defaultReturnValue(long rv) {
            this.stringMap.defaultReturnValue(rv);
        }
    }
}

