/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.io;

import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectBigArrayBigList;
import it.unimi.dsi.fastutil.objects.ObjectIterables;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.io.SafelyCloseable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FileLinesByteArrayIterable
implements Iterable<byte[]>,
Size64 {
    private final String filename;
    private final Constructor<? extends InputStream> decompressor;
    private final EnumSet<FastBufferedInputStream.LineTerminator> terminators;
    private long size = -1L;

    public FileLinesByteArrayIterable(String filename) {
        this(filename, -1L);
    }

    public FileLinesByteArrayIterable(String filename, long size) {
        this(filename, size, FastBufferedInputStream.ALL_TERMINATORS);
    }

    public FileLinesByteArrayIterable(String filename, long size, EnumSet<FastBufferedInputStream.LineTerminator> terminators) {
        this.filename = filename;
        this.size = size;
        this.terminators = terminators;
        this.decompressor = null;
    }

    public FileLinesByteArrayIterable(String filename, Class<? extends InputStream> decompressor) throws NoSuchMethodException, SecurityException {
        this(filename, -1L, decompressor);
    }

    public FileLinesByteArrayIterable(String filename, long size, Class<? extends InputStream> decompressor) throws NoSuchMethodException, SecurityException {
        this(filename, size, FastBufferedInputStream.ALL_TERMINATORS, decompressor);
    }

    public FileLinesByteArrayIterable(String filename, long size, EnumSet<FastBufferedInputStream.LineTerminator> terminators, Class<? extends InputStream> decompressor) throws NoSuchMethodException, SecurityException {
        this.filename = filename;
        this.size = size;
        this.terminators = terminators;
        this.decompressor = decompressor != null ? decompressor.getConstructor(InputStream.class) : null;
    }

    public FileLinesIterator iterator() {
        try {
            FileInputStream inputStream = this.decompressor == null ? new FileInputStream(this.filename) : this.decompressor.newInstance(new FileInputStream(this.filename));
            return new FileLinesIterator(inputStream, this.terminators);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static FileLinesIterator iterator(InputStream inputStream) {
        return FileLinesByteArrayIterable.iterator(inputStream, null);
    }

    public static FileLinesIterator iterator(InputStream inputStream, Class<? extends InputStream> decompressor) {
        return FileLinesByteArrayIterable.iterator(inputStream, decompressor, FastBufferedInputStream.ALL_TERMINATORS);
    }

    public static FileLinesIterator iterator(InputStream inputStream, Class<? extends InputStream> decompressor, EnumSet<FastBufferedInputStream.LineTerminator> terminators) {
        try {
            if (decompressor != null) {
                inputStream = decompressor.getConstructor(InputStream.class).newInstance(inputStream);
            }
            return new FileLinesIterator(inputStream, terminators);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized long size64() {
        if (this.size == -1L) {
            this.size = ObjectIterables.size((Iterable)this);
        }
        return this.size;
    }

    public ObjectList<byte[]> allLines() {
        ObjectArrayList result = new ObjectArrayList();
        for (byte[] a : this) {
            result.add((Object)a);
        }
        return result;
    }

    public ObjectBigArrayBigList<byte[]> allLinesBig() {
        ObjectBigArrayBigList result = new ObjectBigArrayBigList();
        for (byte[] a : this) {
            result.add((Object)a);
        }
        return result;
    }

    public static final class FileLinesIterator
    implements Iterator<byte[]>,
    SafelyCloseable {
        private final EnumSet<FastBufferedInputStream.LineTerminator> terminators;
        private FastBufferedInputStream fbis;
        private byte[] buffer = new byte[1024];
        private boolean ready;
        private int read;

        private FileLinesIterator(InputStream ibs, EnumSet<FastBufferedInputStream.LineTerminator> terminators) {
            this.fbis = new FastBufferedInputStream(ibs);
            this.terminators = terminators;
        }

        @Override
        public boolean hasNext() {
            if (this.ready) {
                return true;
            }
            if (this.fbis == null) {
                return false;
            }
            this.ready = false;
            try {
                int len;
                this.read = 0;
                while ((len = this.fbis.readLine(this.buffer, this.read, this.buffer.length - this.read, this.terminators)) == this.buffer.length - this.read) {
                    this.ready = true;
                    this.read += len;
                    this.buffer = ByteArrays.grow((byte[])this.buffer, (int)(this.buffer.length + 1));
                }
                if (len != -1) {
                    this.ready = true;
                    this.read += len;
                }
                if (len == -1) {
                    this.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.ready;
        }

        @Override
        public byte[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.ready = false;
            return Arrays.copyOf(this.buffer, this.read);
        }

        @Override
        public synchronized void close() {
            if (this.fbis == null) {
                return;
            }
            try {
                this.fbis.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.fbis = null;
            }
        }

        protected synchronized void finalize() throws Throwable {
            try {
                if (this.fbis != null) {
                    this.close();
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

