/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.util.XoRoShiRo128PlusRandomGenerator;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Locale;

public final class Util {
    private static final NumberFormat FORMAT_DOUBLE = NumberFormat.getInstance(Locale.US);
    private static final NumberFormat FORMAT_LONG;
    private static final FieldPosition UNUSED_FIELD_POSITION;
    public static final Runtime RUNTIME;
    private static final XoRoShiRo128PlusRandomGenerator seedUniquifier;

    private Util() {
    }

    public static synchronized String format(double d) {
        return FORMAT_DOUBLE.format(d, new StringBuffer(), UNUSED_FIELD_POSITION).toString();
    }

    public static synchronized String format(long l) {
        return FORMAT_LONG.format(l, new StringBuffer(), UNUSED_FIELD_POSITION).toString();
    }

    public static String format(double d, NumberFormat format) {
        StringBuffer s = new StringBuffer();
        return format.format(d, s, UNUSED_FIELD_POSITION).toString();
    }

    public static String format(long l, NumberFormat format) {
        StringBuffer s = new StringBuffer();
        return format.format(l, s, UNUSED_FIELD_POSITION).toString();
    }

    public static String formatSize(long l) {
        if (l >= 1000000000000L) {
            return Util.format((double)l / 1.0E12) + "T";
        }
        if (l >= 1000000000L) {
            return Util.format((double)l / 1.0E9) + "G";
        }
        if (l >= 1000000L) {
            return Util.format((double)l / 1000000.0) + "M";
        }
        if (l >= 1000L) {
            return Util.format((double)l / 1000.0) + "K";
        }
        return Long.toString(l);
    }

    public static String formatBinarySize(long l) {
        if ((l & -l) != l) {
            throw new IllegalArgumentException("Not a power of 2: " + l);
        }
        if (l >= 0x10000000000L) {
            return Util.format(l >> 40) + "Ti";
        }
        if (l >= 0x40000000L) {
            return Util.format(l >> 30) + "Gi";
        }
        if (l >= 0x100000L) {
            return Util.format(l >> 20) + "Mi";
        }
        if (l >= 1024L) {
            return Util.format(l >> 10) + "Ki";
        }
        return Long.toString(l);
    }

    public static String formatSize2(long l) {
        if (l >= 0x10000000000L) {
            return Util.format((double)l / 1.099511627776E12) + "Ti";
        }
        if (l >= 0x40000000L) {
            return Util.format((double)l / 1.073741824E9) + "Gi";
        }
        if (l >= 0x100000L) {
            return Util.format((double)l / 1048576.0) + "Mi";
        }
        if (l >= 1024L) {
            return Util.format((double)l / 1024.0) + "Ki";
        }
        return Long.toString(l);
    }

    public static String formatSize(long l, NumberFormat format) {
        if (l >= 1000000000000L) {
            return Util.format((double)l / 1.0E12) + "T";
        }
        if (l >= 1000000000L) {
            return Util.format((double)l / 1.0E9) + "G";
        }
        if (l >= 1000000L) {
            return Util.format((double)l / 1000000.0) + "M";
        }
        if (l >= 1000L) {
            return Util.format((double)l / 1000.0) + "K";
        }
        return Long.toString(l);
    }

    public static String formatBinarySize(long l, NumberFormat format) {
        if ((l & -l) != l) {
            throw new IllegalArgumentException("Not a power of 2: " + l);
        }
        if (l >= 0x10000000000L) {
            return Util.format(l >> 40) + "Ti";
        }
        if (l >= 0x40000000L) {
            return Util.format(l >> 30) + "Gi";
        }
        if (l >= 0x100000L) {
            return Util.format(l >> 20) + "Mi";
        }
        if (l >= 1024L) {
            return Util.format(l >> 10) + "Ki";
        }
        return Long.toString(l);
    }

    public static String formatSize2(long l, NumberFormat format) {
        if (l >= 0x10000000000L) {
            return Util.format((double)l / 1.099511627776E12) + "Ti";
        }
        if (l >= 0x40000000L) {
            return Util.format((double)l / 1.073741824E9) + "Gi";
        }
        if (l >= 0x100000L) {
            return Util.format((double)l / 1048576.0) + "Mi";
        }
        if (l >= 1024L) {
            return Util.format((double)l / 1024.0) + "Ki";
        }
        return Long.toString(l);
    }

    public static boolean memoryIsLow() {
        return Util.availableMemory() * 100L < RUNTIME.totalMemory() * 5L;
    }

    public static long availableMemory() {
        return RUNTIME.freeMemory() + (RUNTIME.maxMemory() - RUNTIME.totalMemory());
    }

    public static int percAvailableMemory() {
        return (int)(Util.availableMemory() * 100L / Runtime.getRuntime().maxMemory());
    }

    public static void compactMemory() {
        try {
            byte[][] unused = new byte[128][];
            int i = unused.length;
            while (i-- != 0) {
                unused[i] = new byte[2000000000];
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long randomSeed() {
        long x;
        XoRoShiRo128PlusRandomGenerator xoRoShiRo128PlusRandomGenerator = seedUniquifier;
        synchronized (xoRoShiRo128PlusRandomGenerator) {
            x = seedUniquifier.nextLong();
        }
        return x ^ System.nanoTime();
    }

    public static byte[] randomSeedBytes() {
        long seed = Util.randomSeed();
        byte[] s = new byte[8];
        int i = 8;
        while (i-- != 0) {
            s[i] = (byte)(seed >>> i);
        }
        return s;
    }

    public static int[] invertPermutationInPlace(int[] perm) {
        int n = perm.length;
        block0: while (n-- != 0) {
            int i = perm[n];
            if (i < 0) {
                perm[n] = -i - 1;
                continue;
            }
            if (i == n) continue;
            int k = n;
            while (true) {
                int j = perm[i];
                perm[i] = -k - 1;
                if (j == n) {
                    perm[n] = i;
                    continue block0;
                }
                k = i;
                i = j;
            }
        }
        return perm;
    }

    public static int[] invertPermutation(int[] perm, int[] inv) {
        int i = perm.length;
        while (i-- != 0) {
            inv[perm[i]] = i;
        }
        return inv;
    }

    public static int[] invertPermutation(int[] perm) {
        return Util.invertPermutation(perm, new int[perm.length]);
    }

    public static int[] identity(int[] perm) {
        int i = perm.length;
        while (i-- != 0) {
            perm[i] = i;
        }
        return perm;
    }

    public static int[] identity(int n) {
        return Util.identity(new int[n]);
    }

    public static int[] composePermutations(int[] p, int[] q, int[] r) {
        int length = p.length;
        for (int i = 0; i < length; ++i) {
            r[i] = q[p[i]];
        }
        return r;
    }

    public static int[] composePermutations(int[] p, int[] q) {
        int[] r = (int[])p.clone();
        Util.composePermutations(p, q, r);
        return r;
    }

    public static int[] composePermutationsInPlace(int[] p, int[] q) {
        int i;
        int length = p.length;
        for (i = 0; i < length; ++i) {
            if (q[i] < 0) continue;
            int firstIndex = i;
            int firstElement = q[i];
            assert (firstElement >= 0);
            int j = i;
            while (p[j] != firstIndex) {
                assert (q[p[j]] >= 0);
                q[j] = -q[p[j]] - 1;
                j = p[j];
            }
            q[j] = -firstElement - 1;
        }
        for (i = 0; i < length; ++i) {
            q[i] = -q[i] - 1;
        }
        return q;
    }

    public static long[][] invertPermutationInPlace(long[][] perm) {
        long n = BigArrays.length((long[][])perm);
        block0: while (n-- != 0L) {
            long i = BigArrays.get((long[][])perm, (long)n);
            if (i < 0L) {
                BigArrays.set((long[][])perm, (long)n, (long)(-i - 1L));
                continue;
            }
            if (i == n) continue;
            long k = n;
            while (true) {
                long j = BigArrays.get((long[][])perm, (long)i);
                BigArrays.set((long[][])perm, (long)i, (long)(-k - 1L));
                if (j == n) {
                    BigArrays.set((long[][])perm, (long)n, (long)i);
                    continue block0;
                }
                k = i;
                i = j;
            }
        }
        return perm;
    }

    public static long[][] invertPermutation(long[][] perm, long[][] inv) {
        int i = perm.length;
        while (i-- != 0) {
            long[] t = perm[i];
            int d = t.length;
            while (d-- != 0) {
                BigArrays.set((long[][])inv, (long)t[d], (long)BigArrays.index((int)i, (int)d));
            }
        }
        return inv;
    }

    public static long[][] invertPermutation(long[][] perm) {
        return Util.invertPermutation(perm, LongBigArrays.newBigArray((long)BigArrays.length((long[][])perm)));
    }

    public static long[][] identity(long[][] perm) {
        int i = perm.length;
        while (i-- != 0) {
            long[] t = perm[i];
            int d = t.length;
            while (d-- != 0) {
                t[d] = BigArrays.index((int)i, (int)d);
            }
        }
        return perm;
    }

    public static long[][] identity(long n) {
        return Util.identity(LongBigArrays.newBigArray((long)n));
    }

    public static long[][] composePermutations(long[][] p, long[][] q, long[][] r) {
        long length = BigArrays.length((long[][])p);
        for (long i = 0L; i < length; ++i) {
            BigArrays.set((long[][])r, (long)i, (long)BigArrays.get((long[][])q, (long)BigArrays.get((long[][])p, (long)i)));
        }
        return r;
    }

    public static long[][] composePermutations(long[][] p, long[][] q) {
        long[][] r = LongBigArrays.newBigArray((long)BigArrays.length((long[][])p));
        Util.composePermutations(p, q, r);
        return r;
    }

    public static long[][] composePermutationsInPlace(long[][] p, long[][] q) {
        long length = BigArrays.length((long[][])p);
        for (long i = 0L; i < length; ++i) {
            if (BigArrays.get((long[][])q, (long)i) < 0L) continue;
            long firstIndex = i;
            long firstElement = BigArrays.get((long[][])q, (long)i);
            assert (firstElement >= 0L);
            long j = i;
            while (BigArrays.get((long[][])p, (long)j) != firstIndex) {
                assert (BigArrays.get((long[][])q, (long)BigArrays.get((long[][])p, (long)j)) >= 0L);
                BigArrays.set((long[][])q, (long)j, (long)(-BigArrays.get((long[][])q, (long)BigArrays.get((long[][])p, (long)j)) - 1L));
                j = BigArrays.get((long[][])p, (long)j);
            }
            BigArrays.set((long[][])q, (long)j, (long)(-firstElement - 1L));
        }
        long[][] lArray = q;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            long[] element;
            long[] t = element = lArray[i];
            int l = t.length;
            for (int d = 0; d < l; ++d) {
                t[d] = -t[d] - 1L;
            }
        }
        return q;
    }

    static {
        if (FORMAT_DOUBLE instanceof DecimalFormat) {
            ((DecimalFormat)FORMAT_DOUBLE).applyPattern("#,##0.00");
        }
        FORMAT_LONG = NumberFormat.getInstance(Locale.US);
        if (FORMAT_DOUBLE instanceof DecimalFormat) {
            ((DecimalFormat)FORMAT_LONG).applyPattern("#,###");
        }
        UNUSED_FIELD_POSITION = new FieldPosition(0);
        RUNTIME = Runtime.getRuntime();
        seedUniquifier = new XoRoShiRo128PlusRandomGenerator(System.nanoTime());
    }
}

