/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.bits;

import it.unimi.dsi.bits.AbstractBitVector;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.BitVectors;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongBigList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class LongArrayBitVector
extends AbstractBitVector
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int LOG2_BITS_PER_WORD = 6;
    @Deprecated
    public static final int BITS_PER_WORD = 64;
    public static final int WORD_MASK = 63;
    public static final int LAST_BIT = 63;
    public static final long ALL_ONES = -1L;
    public static final long LAST_BIT_MASK = Long.MIN_VALUE;
    public static final boolean CHECKS = false;
    protected long length;
    protected transient long[] bits;

    public static final int numWords(long size) {
        assert (size >= 0L);
        assert (size + 64L - 1L >>> 6 <= Integer.MAX_VALUE);
        return (int)(size + 64L - 1L >>> 6);
    }

    public static final int word(long index) {
        assert (index >= -1L);
        assert (index >>> 6 <= Integer.MAX_VALUE);
        return (int)(index >>> 6);
    }

    public static final boolean sameWord(long index0, long index1) {
        assert (index0 >= -1L);
        assert (index1 >= -1L);
        return index0 >>> 6 == index1 >>> 6;
    }

    public static final long bits(int word) {
        assert (word >= 0);
        return (long)word << 6;
    }

    public static final boolean round(long index) {
        return (index & 0x3FL) == 0L;
    }

    public static final int bit(long index) {
        return (int)(index & 0x3FL);
    }

    public static final long mask(long index) {
        return 1L << (int)index;
    }

    protected LongArrayBitVector(long capacity) {
        if (capacity > LongArrayBitVector.bits(0x7FFFFFF7)) {
            throw new IndexOutOfBoundsException("In this implementations bit vectors can be at most " + LongArrayBitVector.bits(0x7FFFFFF7) + " bits long");
        }
        this.bits = capacity > 0L ? new long[LongArrayBitVector.numWords(capacity)] : LongArrays.EMPTY_ARRAY;
    }

    public static LongArrayBitVector getInstance(long capacity) {
        return new LongArrayBitVector(capacity);
    }

    public static LongArrayBitVector getInstance() {
        return new LongArrayBitVector(0L);
    }

    public static LongArrayBitVector ofLength(long length) {
        LongArrayBitVector bv = new LongArrayBitVector(length);
        bv.length = length;
        return bv;
    }

    public static LongArrayBitVector of(int ... bit) {
        LongArrayBitVector bitVector = new LongArrayBitVector(bit.length);
        for (int b : bit) {
            if (b != 0 && b != 1) {
                throw new IllegalArgumentException("Illegal bit value: " + b);
            }
            bitVector.add(b);
        }
        return bitVector;
    }

    @Override
    public long[] bits() {
        return this.bits;
    }

    @Override
    public long length() {
        return this.length;
    }

    public LongArrayBitVector ensureCapacity(long numBits) {
        if (numBits > LongArrayBitVector.bits(0x7FFFFFF7)) {
            throw new IndexOutOfBoundsException("In this implementations bit vectors can be at most " + LongArrayBitVector.bits(0x7FFFFFF7) + " bits long");
        }
        this.bits = LongArrays.grow((long[])this.bits, (int)LongArrayBitVector.numWords(numBits), (int)LongArrayBitVector.numWords(this.length));
        return this;
    }

    @Override
    public LongArrayBitVector length(long newLength) {
        this.bits = LongArrays.ensureCapacity((long[])this.bits, (int)LongArrayBitVector.numWords(newLength), (int)LongArrayBitVector.numWords(this.length));
        long oldLength = this.length;
        if (newLength < oldLength) {
            this.fill(newLength, oldLength, false);
        }
        this.length = newLength;
        return this;
    }

    @Override
    public void fill(boolean value) {
        int fullWords = LongArrayBitVector.word(this.length);
        Arrays.fill(this.bits, 0, fullWords, value ? -1L : 0L);
        if (!LongArrayBitVector.round(this.length)) {
            this.bits[fullWords] = value ? (1L << (int)this.length) - 1L : 0L;
        }
    }

    @Override
    public void fill(long from, long to, boolean value) {
        if (LongArrayBitVector.sameWord(from, to)) {
            if (value) {
                int n = LongArrayBitVector.word(from);
                this.bits[n] = this.bits[n] | (1L << (int)(to - from)) - 1L << (int)from;
            } else {
                int n = LongArrayBitVector.word(from);
                this.bits[n] = this.bits[n] & ((1L << (int)(to - from)) - 1L << (int)from ^ 0xFFFFFFFFFFFFFFFFL);
            }
            return;
        }
        Arrays.fill(this.bits, LongArrayBitVector.numWords(from), LongArrayBitVector.word(to), value ? -1L : 0L);
        if (!LongArrayBitVector.round(from)) {
            if (value) {
                int n = LongArrayBitVector.word(from);
                this.bits[n] = this.bits[n] | -1L << (int)from;
            } else {
                int n = LongArrayBitVector.word(from);
                this.bits[n] = this.bits[n] & (1L << (int)from) - 1L;
            }
        }
        if (!LongArrayBitVector.round(to)) {
            if (value) {
                int n = LongArrayBitVector.word(to);
                this.bits[n] = this.bits[n] | (1L << (int)to) - 1L;
            } else {
                int n = LongArrayBitVector.word(to);
                this.bits[n] = this.bits[n] & -1L << (int)to;
            }
        }
    }

    @Override
    public void flip() {
        int fullWords;
        int i = fullWords = LongArrayBitVector.word(this.length);
        while (i-- != 0) {
            int n = i;
            this.bits[n] = this.bits[n] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (!LongArrayBitVector.round(this.length)) {
            int n = fullWords;
            this.bits[n] = this.bits[n] ^ (1L << (int)this.length) - 1L;
        }
    }

    @Override
    public void flip(long from, long to) {
        if (LongArrayBitVector.sameWord(from, to)) {
            int n = LongArrayBitVector.word(from);
            this.bits[n] = this.bits[n] ^ (1L << (int)(to - from)) - 1L << (int)from;
            return;
        }
        int start = LongArrayBitVector.numWords(from);
        int i = LongArrayBitVector.word(to);
        while (i-- != start) {
            int n = i;
            this.bits[n] = this.bits[n] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (!LongArrayBitVector.round(from)) {
            int n = LongArrayBitVector.word(from);
            this.bits[n] = this.bits[n] ^ -1L << (int)from;
        }
        if (!LongArrayBitVector.round(to)) {
            int n = LongArrayBitVector.word(to);
            this.bits[n] = this.bits[n] ^ (1L << (int)to) - 1L;
        }
    }

    public boolean trim() {
        if (this.bits.length == LongArrayBitVector.numWords(this.length)) {
            return false;
        }
        this.bits = LongArrays.setLength((long[])this.bits, (int)LongArrayBitVector.numWords(this.length));
        return true;
    }

    @Override
    public void clear() {
        if (this.length != 0L) {
            Arrays.fill(this.bits, 0, LongArrayBitVector.numWords(this.length), 0L);
        }
        this.length = 0L;
    }

    @Override
    public LongArrayBitVector copy(long from, long to) {
        BitVectors.ensureFromTo(this.length, from, to);
        LongArrayBitVector copy = new LongArrayBitVector(to - from);
        copy.length = to - from;
        if (copy.length == 0L) {
            return copy;
        }
        int numWords = LongArrayBitVector.numWords(to - from);
        int startWord = LongArrayBitVector.word(from);
        int startBit = LongArrayBitVector.bit(from);
        if (startBit == 0) {
            System.arraycopy(this.bits, startWord, copy.bits, 0, numWords);
            int endBit = LongArrayBitVector.bit(to);
            if (endBit > 0) {
                int n = numWords - 1;
                copy.bits[n] = copy.bits[n] & (1L << endBit) - 1L;
            }
        } else if (startWord == LongArrayBitVector.word(to - 1L)) {
            copy.bits[0] = this.bits[startWord] >>> startBit & (1L << (int)(to - from)) - 1L;
        } else {
            int bitsPerWordMinusStartBit = 64 - startBit;
            long[] bits = this.bits;
            long[] copyBits = copy.bits;
            copyBits[0] = bits[startWord] >>> startBit;
            for (int word = 1; word < numWords; ++word) {
                int n = word - 1;
                copyBits[n] = copyBits[n] | bits[word + startWord] << bitsPerWordMinusStartBit;
                copyBits[word] = bits[word + startWord] >>> startBit;
            }
            int endBit = LongArrayBitVector.bit(to - from);
            if (endBit == 0) {
                int n = numWords - 1;
                copyBits[n] = copyBits[n] | bits[numWords + startWord] << bitsPerWordMinusStartBit;
            } else {
                if (endBit > bitsPerWordMinusStartBit) {
                    int n = numWords - 1;
                    copyBits[n] = copyBits[n] | bits[numWords + startWord] << bitsPerWordMinusStartBit;
                }
                int n = numWords - 1;
                copyBits[n] = copyBits[n] & (1L << endBit) - 1L;
            }
        }
        return copy;
    }

    @Override
    public LongArrayBitVector copy() {
        LongArrayBitVector copy = new LongArrayBitVector(this.length);
        copy.length = this.length;
        System.arraycopy(this.bits, 0, copy.bits, 0, LongArrayBitVector.numWords(this.length));
        return copy;
    }

    @Override
    public LongArrayBitVector fast() {
        return this;
    }

    public static LongArrayBitVector copy(BitVector bv) {
        long length = bv.length();
        LongArrayBitVector copy = new LongArrayBitVector(length);
        long fullBits = length & 0xFFFFFFFFFFFFFFC0L;
        for (long i = 0L; i < fullBits; i += 64L) {
            copy.bits[LongArrayBitVector.word((long)i)] = bv.getLong(i, i + 64L);
        }
        if (!LongArrayBitVector.round(length)) {
            copy.bits[LongArrayBitVector.word((long)fullBits)] = bv.getLong(fullBits, length);
        }
        copy.length = length;
        return copy;
    }

    public boolean getBoolean(long index) {
        assert (index >= 0L);
        assert (index < this.length);
        return (this.bits[LongArrayBitVector.word(index)] & LongArrayBitVector.mask(index)) != 0L;
    }

    @Override
    public boolean set(long index, boolean value) {
        long mask;
        boolean oldValue;
        assert (index >= 0L);
        assert (index < this.length);
        int word = LongArrayBitVector.word(index);
        boolean bl = oldValue = (this.bits[word] & (mask = LongArrayBitVector.mask(index))) != 0L;
        if (value != oldValue) {
            int n = word;
            this.bits[n] = this.bits[n] ^ mask;
        }
        return oldValue;
    }

    @Override
    public void set(long index) {
        assert (index >= 0L);
        assert (index < this.length);
        int n = LongArrayBitVector.word(index);
        this.bits[n] = this.bits[n] | LongArrayBitVector.mask(index);
    }

    @Override
    public void clear(long index) {
        assert (index >= 0L);
        assert (index < this.length);
        int n = LongArrayBitVector.word(index);
        this.bits[n] = this.bits[n] & (LongArrayBitVector.mask(index) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public void add(long index, boolean value) {
        assert (index >= 0L);
        assert (index <= this.length);
        if (this.length == LongArrayBitVector.bits(this.bits.length)) {
            this.bits = LongArrays.grow((long[])this.bits, (int)LongArrayBitVector.numWords(this.length + 1L));
        }
        ++this.length;
        if (index == this.length - 1L) {
            this.set(index, value);
        } else {
            int word = LongArrayBitVector.word(index);
            int bit = LongArrayBitVector.bit(index);
            boolean carry = (this.bits[word] & Long.MIN_VALUE) != 0L;
            long t = this.bits[word];
            t = bit == 63 ? (t &= Long.MAX_VALUE) : (t & -(1L << bit)) << 1 | t & (1L << bit) - 1L;
            if (value) {
                t |= 1L << bit;
            }
            this.bits[word] = t;
            int numWords = LongArrayBitVector.numWords(this.length);
            for (int i = word + 1; i < numWords; ++i) {
                boolean nextCarry = (this.bits[i] & Long.MIN_VALUE) != 0L;
                int n = i;
                this.bits[n] = this.bits[n] << 1;
                if (carry) {
                    int n2 = i;
                    this.bits[n2] = this.bits[n2] | 1L;
                }
                carry = nextCarry;
            }
        }
    }

    @Override
    public boolean removeBoolean(long index) {
        assert (index >= 0L);
        assert (index < this.length);
        boolean oldValue = this.getBoolean(index);
        long[] bits = this.bits;
        int word = LongArrayBitVector.word(index);
        int bit = LongArrayBitVector.bit(index);
        bits[word] = (bits[word] & -(1L << bit) << 1) >>> 1 | bits[word] & (1L << bit) - 1L;
        int numWords = LongArrayBitVector.numWords(this.length--);
        int i = word + 1;
        while (i < numWords) {
            if ((bits[i] & 1L) != 0L) {
                int n = i - 1;
                bits[n] = bits[n] | Long.MIN_VALUE;
            }
            int n = i++;
            bits[n] = bits[n] >>> 1;
        }
        return oldValue;
    }

    @Override
    public LongArrayBitVector append(long value, int width) {
        if (width == 0) {
            return this;
        }
        assert (width == 64 || (value & -1L << width) == 0L);
        long length = this.length;
        int startWord = LongArrayBitVector.word(length);
        int startBit = LongArrayBitVector.bit(length);
        this.ensureCapacity(length + (long)width);
        if (startBit + width <= 64) {
            int n = startWord;
            this.bits[n] = this.bits[n] | value << startBit;
        } else {
            int n = startWord;
            this.bits[n] = this.bits[n] | value << startBit;
            this.bits[startWord + 1] = value >>> -startBit;
        }
        this.length += (long)width;
        return this;
    }

    @Override
    public long getLong(long from, long to) {
        assert (0L <= from);
        assert (from <= to);
        assert (to <= this.length);
        long l = 64L - (to - from);
        int startWord = LongArrayBitVector.word(from);
        int startBit = LongArrayBitVector.bit(from);
        if (l == 64L) {
            return 0L;
        }
        if ((long)startBit <= l) {
            return this.bits[startWord] << (int)(l - (long)startBit) >>> (int)l;
        }
        return this.bits[startWord] >>> startBit | this.bits[startWord + 1] << (int)(l - (long)startBit) >>> (int)l;
    }

    @Override
    public long count() {
        long c = 0L;
        int i = LongArrayBitVector.numWords(this.length);
        while (i-- != 0) {
            c += (long)Long.bitCount(this.bits[i]);
        }
        return c;
    }

    @Override
    public long nextOne(long index) {
        if (index >= this.length) {
            return -1L;
        }
        long[] bits = this.bits;
        int from = LongArrayBitVector.word(index);
        long maskedFirstWord = bits[from] & -(1L << (int)index);
        if (maskedFirstWord != 0L) {
            return LongArrayBitVector.bits(from) + (long)Long.numberOfTrailingZeros(maskedFirstWord);
        }
        long words = LongArrayBitVector.numWords(this.length);
        int i = from + 1;
        while ((long)i < words) {
            if (bits[i] != 0L) {
                return LongArrayBitVector.bits(i) + (long)Long.numberOfTrailingZeros(bits[i]);
            }
            ++i;
        }
        return -1L;
    }

    @Override
    public long previousOne(long index) {
        long mask;
        if (index == 0L) {
            return -1L;
        }
        long[] bits = this.bits;
        int from = LongArrayBitVector.word(index - 1L);
        long maskedFirstWord = bits[from] & ((mask = 1L << (int)(index - 1L)) | mask - 1L);
        if (maskedFirstWord != 0L) {
            return LongArrayBitVector.bits(from) + (long)Fast.mostSignificantBit(maskedFirstWord);
        }
        int i = from;
        while (i-- != 0) {
            if (bits[i] == 0L) continue;
            return LongArrayBitVector.bits(i) + (long)Fast.mostSignificantBit(bits[i]);
        }
        return -1L;
    }

    @Override
    public long nextZero(long index) {
        if (index >= this.length) {
            return -1L;
        }
        long[] bits = this.bits;
        long words = LongArrayBitVector.numWords(this.length);
        int from = LongArrayBitVector.word(index);
        long maskedFirstWord = bits[from] | (1L << (int)index) - 1L;
        if (maskedFirstWord != -1L) {
            long result = LongArrayBitVector.bits(from) + (long)Long.numberOfTrailingZeros(maskedFirstWord ^ 0xFFFFFFFFFFFFFFFFL);
            return result >= this.length ? -1L : result;
        }
        int i = from + 1;
        while ((long)i < words) {
            if (bits[i] != -1L) {
                long result = LongArrayBitVector.bits(i) + (long)Long.numberOfTrailingZeros(bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
                return result >= this.length ? -1L : result;
            }
            ++i;
        }
        return -1L;
    }

    @Override
    public long previousZero(long index) {
        if (index == 0L) {
            return -1L;
        }
        long[] bits = this.bits;
        int from = LongArrayBitVector.word(index - 1L);
        long maskedFirstWord = bits[from] | -1L << (int)index;
        if (from == LongArrayBitVector.word(this.length - 1L)) {
            maskedFirstWord |= -1L << (int)this.length;
        }
        if (maskedFirstWord != -1L) {
            return LongArrayBitVector.bits(from) + (long)Fast.mostSignificantBit(maskedFirstWord ^ 0xFFFFFFFFFFFFFFFFL);
        }
        int i = from;
        while (i-- != 0) {
            if (bits[i] == -1L) continue;
            return LongArrayBitVector.bits(i) + (long)Fast.mostSignificantBit(bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return -1L;
    }

    @Override
    public long longestCommonPrefixLength(BitVector v) {
        if (v instanceof LongArrayBitVector) {
            return this.longestCommonPrefixLength((LongArrayBitVector)v);
        }
        return super.longestCommonPrefixLength(v);
    }

    public long longestCommonPrefixLength(LongArrayBitVector v) {
        long minLength = Math.min(v.length(), this.length());
        long words = LongArrayBitVector.numWords(minLength);
        long[] bits = this.bits;
        long[] vBits = v.bits;
        int i = 0;
        while ((long)i < words) {
            if (bits[i] != vBits[i]) {
                return Math.min(minLength, LongArrayBitVector.bits(i) + (long)Long.numberOfTrailingZeros(bits[i] ^ vBits[i]));
            }
            ++i;
        }
        return minLength;
    }

    @Override
    public BitVector and(BitVector v) {
        if (v instanceof LongArrayBitVector) {
            LongArrayBitVector l = (LongArrayBitVector)v;
            int words = Math.min(LongArrayBitVector.numWords(this.length()), LongArrayBitVector.numWords(l.length()));
            while (words-- != 0) {
                int n = words;
                this.bits[n] = this.bits[n] & l.bits[words];
            }
        } else {
            super.and(v);
        }
        return this;
    }

    @Override
    public BitVector or(BitVector v) {
        if (v instanceof LongArrayBitVector) {
            LongArrayBitVector l = (LongArrayBitVector)v;
            int words = Math.min(LongArrayBitVector.numWords(this.length()), LongArrayBitVector.numWords(l.length()));
            while (words-- != 0) {
                int n = words;
                this.bits[n] = this.bits[n] | l.bits[words];
            }
        } else {
            super.or(v);
        }
        return this;
    }

    @Override
    public BitVector xor(BitVector v) {
        if (v instanceof LongArrayBitVector) {
            LongArrayBitVector l = (LongArrayBitVector)v;
            int words = Math.min(LongArrayBitVector.numWords(this.length()), LongArrayBitVector.numWords(l.length()));
            while (words-- != 0) {
                int n = words;
                this.bits[n] = this.bits[n] ^ l.bits[words];
            }
        } else {
            super.xor(v);
        }
        return this;
    }

    public static LongArrayBitVector wrap(long[] array, long size) {
        if (size > LongArrayBitVector.bits(array.length)) {
            throw new IllegalArgumentException("The provided array is too short (" + array.length + " elements) for the given size (" + size + ")");
        }
        LongArrayBitVector result = new LongArrayBitVector(0L);
        result.length = size;
        result.bits = array;
        int arrayLength = array.length;
        int lastWord = LongArrayBitVector.word(size);
        if (lastWord < arrayLength && (array[lastWord] & ((1L << (int)size) - 1L ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            throw new IllegalArgumentException("Garbage beyond size in bit array");
        }
        for (int i = lastWord + 1; i < arrayLength; ++i) {
            if (array[i] == 0L) continue;
            throw new IllegalArgumentException("Garbage beyond size in bit array");
        }
        return result;
    }

    public static LongArrayBitVector wrap(long[] array) {
        return LongArrayBitVector.wrap(array, (long)array.length * 64L);
    }

    public LongArrayBitVector clone() throws CloneNotSupportedException {
        LongArrayBitVector copy = (LongArrayBitVector)super.clone();
        copy.bits = (long[])this.bits.clone();
        return copy;
    }

    public LongArrayBitVector replace(LongArrayBitVector bv) {
        int bvFirstFreeWord;
        this.ensureCapacity(bv.length);
        long[] bits = this.bits;
        long[] bvBits = bv.bits;
        int i = bvFirstFreeWord = LongArrayBitVector.word(bv.length - 1L) + 1;
        while (i-- != 0) {
            bits[i] = bvBits[i];
        }
        int thisFirstFreeWord = LongArrayBitVector.numWords(this.length);
        if (bvFirstFreeWord < thisFirstFreeWord) {
            Arrays.fill(this.bits, bvFirstFreeWord, thisFirstFreeWord, 0L);
        }
        this.length = bv.length;
        return this;
    }

    @Override
    public LongArrayBitVector replace(BitVector bv) {
        long bvLength = bv.length();
        this.ensureCapacity(bvLength);
        long[] bits = this.bits;
        long fullBits = bvLength & 0xFFFFFFFFFFFFFFC0L;
        for (long i = 0L; i < fullBits; i += 64L) {
            bits[LongArrayBitVector.word((long)i)] = bv.getLong(i, i + 64L);
        }
        int bvFirstFreeWord = LongArrayBitVector.word(bvLength - 1L) + 1;
        int thisFirstFreeWord = LongArrayBitVector.numWords(this.length);
        if (!LongArrayBitVector.round(bvLength)) {
            bits[LongArrayBitVector.word((long)fullBits)] = bv.getLong(fullBits, bvLength);
        }
        if (bvFirstFreeWord < thisFirstFreeWord) {
            Arrays.fill(this.bits, bvFirstFreeWord, thisFirstFreeWord, 0L);
        }
        this.length = bvLength;
        return this;
    }

    @Override
    public int hashCode() {
        long h = 0x9E3779B97F4A7C13L ^ this.length;
        int numWords = LongArrayBitVector.numWords(this.length);
        for (int i = 0; i < numWords; ++i) {
            h ^= (h << 5) + this.bits[i] + (h >>> 2);
        }
        assert ((int)(h >>> 32 ^ h) == super.hashCode());
        return (int)(h >>> 32 ^ h);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof LongArrayBitVector) {
            return this.equals((LongArrayBitVector)o);
        }
        return super.equals(o);
    }

    public boolean equals(LongArrayBitVector v) {
        if (this.length != v.length()) {
            return false;
        }
        int i = LongArrayBitVector.numWords(this.length);
        while (i-- != 0) {
            if (this.bits[i] == v.bits[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(LongArrayBitVector v, long start, long end) {
        int startWord = LongArrayBitVector.word(start);
        int endWord = LongArrayBitVector.word(end);
        int startBit = LongArrayBitVector.bit(start);
        int endBit = LongArrayBitVector.bit(end);
        long[] aBits = this.bits();
        long[] bBits = v.bits();
        if (startWord == endWord) {
            return ((aBits[startWord] ^ bBits[startWord]) & (1L << endBit - startBit) - 1L << startBit) == 0L;
        }
        if (((aBits[startWord] ^ bBits[startWord++]) & -1L << startBit) != 0L) {
            return false;
        }
        while (startWord < endWord) {
            if (aBits[startWord] == bBits[startWord++]) continue;
            return false;
        }
        return ((aBits[endWord] ^ bBits[endWord]) & (1L << endBit) - 1L) == 0L;
    }

    @Override
    public LongBigList asLongBigList(int width) {
        return new LongBigListView(this, width);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        int numWords = LongArrayBitVector.numWords(this.length);
        for (int i = 0; i < numWords; ++i) {
            s.writeLong(this.bits[i]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numWords = LongArrayBitVector.numWords(this.length);
        this.bits = new long[numWords];
        for (int i = 0; i < numWords; ++i) {
            this.bits[i] = s.readLong();
        }
    }

    protected static class LongBigListView
    extends AbstractBitVector.LongBigListView {
        private static final long serialVersionUID = 1L;
        private final LongArrayBitVector bitVector;

        public LongBigListView(LongArrayBitVector bitVector, int width) {
            super(bitVector, width);
            this.bitVector = bitVector;
        }

        public boolean add(long value) {
            this.bitVector.append(value, this.width);
            return true;
        }

        @Override
        public long getLong(long index) {
            long start = index * (long)this.width;
            return this.bitVector.getLong(start, start + (long)this.width);
        }

        public void clear() {
            this.bitVector.clear();
        }

        @Override
        public long set(long index, long value) {
            long oldValue;
            if (this.width == 0) {
                return 0L;
            }
            if (this.width != 64 && value > this.fullMask) {
                throw new IllegalArgumentException("Value too large: " + value);
            }
            this.ensureRestrictedIndex(index);
            long[] bits = this.bitVector.bits;
            long start = index * (long)this.width;
            int startWord = LongArrayBitVector.word(start);
            int endWord = LongArrayBitVector.word(start + (long)this.width - 1L);
            int startBit = LongArrayBitVector.bit(start);
            if (startWord == endWord) {
                oldValue = bits[startWord] >>> startBit & this.fullMask;
                int n = startWord;
                bits[n] = bits[n] & (this.fullMask << startBit ^ 0xFFFFFFFFFFFFFFFFL);
                int n2 = startWord;
                bits[n2] = bits[n2] | value << startBit;
                assert (value == (bits[startWord] >>> startBit & this.fullMask));
            } else {
                oldValue = bits[startWord] >>> startBit | bits[endWord] << -startBit & this.fullMask;
                int n = startWord;
                bits[n] = bits[n] & (1L << startBit) - 1L;
                int n3 = startWord;
                bits[n3] = bits[n3] | value << startBit;
                int n4 = endWord;
                bits[n4] = bits[n4] & -(1L << this.width + startBit);
                int n5 = endWord;
                bits[n5] = bits[n5] | value >>> -startBit;
                assert (value == (bits[startWord] >>> startBit | bits[endWord] << -startBit & this.fullMask));
            }
            return oldValue;
        }
    }
}

