/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.test;

import java.math.BigInteger;

public class XorShiftPoly116 {
    public static final int BITS = 116;
    public static BigInteger twoToBitsMinus1;
    public static final BigInteger[] factor;
    public static final BigInteger[] cofactor;
    public static int numCofactors;

    private XorShiftPoly116() {
    }

    public static void mPow(BigInteger e) {
        System.out.println("p := 1;");
        int i = 0;
        while (!e.equals(BigInteger.ZERO)) {
            if (e.testBit(0)) {
                System.out.println("p := *p * q[" + i + "];");
            }
            e = e.shiftRight(1);
            ++i;
        }
    }

    public static void main(String[] arg) {
        BigInteger prod = BigInteger.ONE;
        for (BigInteger f : factor) {
            prod = prod.multiply(f);
        }
        if (!prod.equals(BigInteger.TWO.pow(116).subtract(BigInteger.ONE))) {
            System.err.println("Factors do not match");
            return;
        }
        BigInteger result = BigInteger.ONE;
        twoToBitsMinus1 = BigInteger.valueOf(2L).pow(116).subtract(BigInteger.ONE);
        for (int n = 0; n < factor.length; ++n) {
            XorShiftPoly116.cofactor[n] = twoToBitsMinus1.divide(factor[n]);
            result = result.multiply(factor[n]);
        }
        if (!twoToBitsMinus1.equals(result)) {
            throw new AssertionError();
        }
        System.out.println("Array q[117];");
        System.out.println("q[0] := x;");
        for (int i1 = 1; i1 <= 116; ++i1) {
            System.out.println("q[" + i1 + "] := q[" + (i1 - 1) + "] * q[" + (i1 - 1) + "];");
        }
        System.out.println("!!('Check: ', if q[116] = x then 1 else 0; &q fi);");
        for (int i = 0; i < cofactor.length; ++i) {
            XorShiftPoly116.mPow(cofactor[i]);
            System.out.println("!!('Result: ', if p = 1 then 0; &q else 1 fi);");
        }
    }

    static {
        factor = new BigInteger[]{new BigInteger("3"), new BigInteger("5"), new BigInteger("59"), new BigInteger("233"), new BigInteger("1103"), new BigInteger("2089"), new BigInteger("3033169"), new BigInteger("107367629"), new BigInteger("536903681")};
        cofactor = new BigInteger[factor.length];
    }
}

