/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util;

import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.util.SplitMix64RandomGenerator;
import java.util.Random;

public class XoRoShiRo128PlusPlusRandom
extends Random {
    private static final long serialVersionUID = 1L;
    private long s0;
    private long s1;
    private static final long[] JUMP = new long[]{3159176899437800924L, 689838746718161413L};
    private static final long[] LONG_JUMP = new long[]{3895567441539718553L, -7174682294107748637L};

    protected XoRoShiRo128PlusPlusRandom(long s0, long s1) {
        this.s0 = s0;
        this.s1 = s1;
    }

    public XoRoShiRo128PlusPlusRandom() {
        this(Util.randomSeed());
    }

    public XoRoShiRo128PlusPlusRandom(long seed) {
        this.setSeed(seed);
    }

    public XoRoShiRo128PlusPlusRandom copy() {
        return new XoRoShiRo128PlusPlusRandom(this.s0, this.s1);
    }

    @Override
    public long nextLong() {
        long s0 = this.s0;
        long s1 = this.s1;
        long result = Long.rotateLeft(s0 + s1, 17) + s0;
        this.s0 = Long.rotateLeft(s0, 49) ^ (s1 ^= s0) ^ s1 << 21;
        this.s1 = Long.rotateLeft(s1, 28);
        return result;
    }

    @Override
    public int nextInt() {
        return (int)this.nextLong();
    }

    @Override
    public int nextInt(int n) {
        return (int)this.nextLong(n);
    }

    @Override
    public long nextLong(long n) {
        if (n <= 0L) {
            throw new IllegalArgumentException("illegal bound " + n + " (must be positive)");
        }
        long t = this.nextLong();
        long nMinus1 = n - 1L;
        long u = t >>> 1;
        while (u + nMinus1 - (t = u % n) < 0L) {
            u = this.nextLong() >>> 1;
        }
        return t;
    }

    @Override
    public double nextDouble() {
        return (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
    }

    public double nextDoubleFast() {
        return Double.longBitsToDouble(0x3FF0000000000000L | this.nextLong() >>> 12) - 1.0;
    }

    @Override
    public float nextFloat() {
        return (float)(this.nextLong() >>> 40) * 5.9604645E-8f;
    }

    @Override
    public boolean nextBoolean() {
        return this.nextLong() < 0L;
    }

    @Override
    public void nextBytes(byte[] bytes) {
        int i = bytes.length;
        int n = 0;
        while (i != 0) {
            n = Math.min(i, 8);
            long bits = this.nextLong();
            while (n-- != 0) {
                bytes[--i] = (byte)bits;
                bits >>= 8;
            }
        }
    }

    private XoRoShiRo128PlusPlusRandom jump(long[] jump) {
        long s0 = 0L;
        long s1 = 0L;
        for (int i = 0; i < jump.length; ++i) {
            for (int b = 0; b < 64; ++b) {
                if ((jump[i] & 1L << b) != 0L) {
                    s0 ^= this.s0;
                    s1 ^= this.s1;
                }
                this.nextLong();
            }
        }
        this.s0 = s0;
        this.s1 = s1;
        return this;
    }

    public XoRoShiRo128PlusPlusRandom jump() {
        return this.jump(JUMP);
    }

    public XoRoShiRo128PlusPlusRandom longJump() {
        return this.jump(LONG_JUMP);
    }

    public XoRoShiRo128PlusPlusRandom split() {
        XoRoShiRo128PlusPlusRandom split = new XoRoShiRo128PlusPlusRandom();
        split.s0 = HashCommon.murmurHash3((long)this.s0);
        split.s1 = HashCommon.murmurHash3((long)this.s1);
        return split;
    }

    @Override
    public void setSeed(long seed) {
        SplitMix64RandomGenerator r = new SplitMix64RandomGenerator(seed);
        this.s0 = r.nextLong();
        this.s1 = r.nextLong();
    }

    public void setState(long[] state) {
        if (state.length != 2) {
            throw new IllegalArgumentException("The argument array contains " + state.length + " longs instead of " + 2);
        }
        this.s0 = state[0];
        this.s1 = state[1];
    }

    public static void main(String[] arg) {
        long n = Long.parseLong(arg[0]);
        long x = 0L;
        ProgressLogger pl = new ProgressLogger();
        XoRoShiRo128PlusPlusRandom r = new XoRoShiRo128PlusPlusRandom(0L);
        int k = 10;
        while (k-- != 0) {
            pl.start("Measuring...");
            long i = n;
            while (i-- != 0L) {
                x ^= r.nextLong();
            }
            pl.done(n);
            if (x != 0L) continue;
            System.out.println(x);
        }
    }
}

