/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.util;

import it.unimi.dsi.big.util.PrefixMap;
import it.unimi.dsi.big.util.StringMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectFunction;
import it.unimi.dsi.fastutil.objects.Object2ObjectFunctions;
import it.unimi.dsi.fastutil.objects.ObjectBigList;
import it.unimi.dsi.fastutil.objects.ObjectBigLists;
import it.unimi.dsi.util.LongInterval;
import java.io.Serializable;

public class StringMaps {
    private StringMaps() {
    }

    public static <T extends CharSequence> StringMap<T> synchronize(StringMap<T> stringMap) {
        return stringMap instanceof PrefixMap ? new SynchronizedPrefixMap((PrefixMap)stringMap) : new SynchronizedStringMap<T>(stringMap);
    }

    public static <T extends CharSequence> PrefixMap<T> synchronize(PrefixMap<T> prefixMap) {
        return new SynchronizedPrefixMap<T>(prefixMap);
    }

    protected static class SynchronizedPrefixMap<S extends CharSequence>
    extends SynchronizedStringMap<S>
    implements PrefixMap<S>,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected final PrefixMap<S> map;
        protected Object2ObjectFunction<LongInterval, S> prefixMap;
        protected Object2ObjectFunction<CharSequence, LongInterval> rangeMap;

        public SynchronizedPrefixMap(PrefixMap<S> map) {
            super(map);
            this.map = map;
        }

        @Override
        public synchronized Object2ObjectFunction<LongInterval, S> prefixMap() {
            if (this.prefixMap == null) {
                this.prefixMap = this.map.prefixMap();
                if (this.prefixMap != null) {
                    this.prefixMap = Object2ObjectFunctions.synchronize(this.prefixMap, (Object)this);
                }
            }
            return this.prefixMap;
        }

        @Override
        public synchronized Object2ObjectFunction<CharSequence, LongInterval> rangeMap() {
            if (this.rangeMap == null) {
                this.rangeMap = this.map.rangeMap();
                if (this.rangeMap != null) {
                    this.rangeMap = Object2ObjectFunctions.synchronize(this.rangeMap, (Object)this);
                }
            }
            return this.rangeMap;
        }
    }

    protected static class SynchronizedStringMap<S extends CharSequence>
    implements StringMap<S>,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected final StringMap<S> stringMap;
        protected ObjectBigList<? extends S> list;

        public SynchronizedStringMap(StringMap<S> stringMap) {
            this.stringMap = stringMap;
        }

        @Deprecated
        public synchronized int size() {
            return this.stringMap.size();
        }

        public synchronized long size64() {
            return this.stringMap.size64();
        }

        @Override
        public synchronized ObjectBigList<? extends S> list() {
            if (this.list == null) {
                this.list = this.stringMap.list();
                if (this.list != null) {
                    this.list = ObjectBigLists.synchronize(this.list, (Object)this);
                }
            }
            return this.list;
        }

        public synchronized long getLong(Object s) {
            return this.stringMap.getLong(s);
        }

        public synchronized Long get(Object key) {
            return (Long)this.stringMap.get(key);
        }

        public synchronized long put(CharSequence key, long value) {
            return this.stringMap.put(key, value);
        }

        public synchronized Long put(CharSequence key, Long value) {
            return (Long)this.stringMap.put(key, value);
        }

        public synchronized Long remove(Object key) {
            return (Long)this.stringMap.remove(key);
        }

        public synchronized long removeLong(Object key) {
            return this.stringMap.removeLong(key);
        }

        public synchronized void clear() {
            this.stringMap.clear();
        }

        public synchronized boolean containsKey(Object key) {
            return this.stringMap.containsKey(key);
        }

        public synchronized long defaultReturnValue() {
            return this.stringMap.defaultReturnValue();
        }

        public synchronized void defaultReturnValue(long rv) {
            this.stringMap.defaultReturnValue(rv);
        }
    }
}

