/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.core.parsing;

import it.unibo.tuprolog.core.Real;
import it.unibo.tuprolog.core.Scope;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.parsing.ParseException;
import it.unibo.tuprolog.core.parsing.ParseExceptionExtKt;
import it.unibo.tuprolog.core.parsing.TermParserExtensions;
import it.unibo.tuprolog.parser.PrologParser;
import it.unibo.tuprolog.parser.PrologParserBaseVisitor;
import it.unibo.tuprolog.parser.dynamic.Associativity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.gciatto.kt.math.BigInteger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002J\u001e\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00022\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J$\u0010\r\u001a\u00020\u00022\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007H\u0002J$\u0010\u0011\u001a\u00020\u00022\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007H\u0002J$\u0010\u0012\u001a\u00020\u00022\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007H\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0019H\u0002J\u001e\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u00022\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007H\u0002J\u001e\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u00022\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007H\u0002J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\"\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010#\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010$\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010%\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010&\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0019H\u0016J\u0010\u0010'\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010*\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010+\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u000206H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lit/unibo/tuprolog/core/parsing/PrologExpressionVisitor;", "Lit/unibo/tuprolog/parser/PrologParserBaseVisitor;", "Lit/unibo/tuprolog/core/Term;", "scope", "Lit/unibo/tuprolog/core/Scope;", "(Lit/unibo/tuprolog/core/Scope;)V", "flatten", "", "Lit/unibo/tuprolog/parser/PrologParser$OuterContext;", "outers", "Lkotlin/sequences/Sequence;", "handleOuters", "expression", "infixLeft", "terms", "ops", "", "infixNonAssociative", "infixRight", "listOfOperands", "ctx", "Lit/unibo/tuprolog/parser/PrologParser$ExpressionContext;", "listOfOperators", "parseInteger", "Lorg/gciatto/kt/math/BigInteger;", "Lit/unibo/tuprolog/parser/PrologParser$IntegerContext;", "postfix", "term", "prefix", "visitBlock", "Lit/unibo/tuprolog/parser/PrologParser$BlockContext;", "visitClause", "Lit/unibo/tuprolog/parser/PrologParser$ClauseContext;", "visitExpression", "visitInfixExpression", "visitInfixLeftAssociativeExpression", "visitInfixNonAssociativeExpression", "visitInfixRightAssociativeExpression", "visitInteger", "visitList", "Lit/unibo/tuprolog/parser/PrologParser$ListContext;", "visitPostfixExpression", "visitPrefixExpression", "visitReal", "Lit/unibo/tuprolog/parser/PrologParser$RealContext;", "visitSingletonExpression", "Lit/unibo/tuprolog/parser/PrologParser$SingletonExpressionContext;", "visitSingletonTerm", "Lit/unibo/tuprolog/parser/PrologParser$SingletonTermContext;", "visitStructure", "Lit/unibo/tuprolog/parser/PrologParser$StructureContext;", "visitTerm", "Lit/unibo/tuprolog/parser/PrologParser$TermContext;", "visitVariable", "Lit/unibo/tuprolog/parser/PrologParser$VariableContext;", "parser-core"})
public final class PrologExpressionVisitor
extends PrologParserBaseVisitor<Term> {
    @NotNull
    private final Scope scope;

    public PrologExpressionVisitor(@NotNull Scope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.scope = scope;
    }

    public /* synthetic */ PrologExpressionVisitor(Scope scope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            scope = Scope.Companion.empty();
        }
        this(scope);
    }

    @NotNull
    public Term visitSingletonTerm(@NotNull PrologParser.SingletonTermContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        PrologParser.TermContext termContext = ctx.term();
        Intrinsics.checkNotNullExpressionValue((Object)termContext, (String)"ctx.term()");
        return this.visitTerm(termContext);
    }

    @NotNull
    public Term visitSingletonExpression(@NotNull PrologParser.SingletonExpressionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        PrologParser.ExpressionContext expressionContext = ctx.expression();
        Intrinsics.checkNotNullExpressionValue((Object)expressionContext, (String)"ctx.expression()");
        return this.visitExpression(expressionContext);
    }

    @NotNull
    public Term visitClause(@NotNull PrologParser.ClauseContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Object object = ctx.expression().accept((ParseTreeVisitor)this);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ctx.expression().accept(this)");
        return (Term)TermParserExtensions.toClause((Term)object, ctx.getText(), ctx.start.getLine(), ctx.start.getCharPositionInLine());
    }

    @NotNull
    public Term visitExpression(@NotNull PrologParser.ExpressionContext ctx) {
        Term term;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (ctx.isTerm) {
            PrologParser.TermContext termContext = ctx.left;
            Intrinsics.checkNotNullExpressionValue((Object)termContext, (String)"ctx.left");
            term = this.visitTerm(termContext);
        } else if (Associativity.INFIX.contains(ctx.associativity)) {
            term = this.visitInfixExpression(ctx);
        } else if (Associativity.POSTFIX.contains(ctx.associativity)) {
            term = this.visitPostfixExpression(ctx);
        } else if (Associativity.PREFIX.contains(ctx.associativity)) {
            term = this.visitPrefixExpression(ctx);
        } else {
            if (ctx.exception != null) {
                RecognitionException recognitionException = ctx.exception;
                Intrinsics.checkNotNullExpressionValue((Object)recognitionException, (String)"ctx.exception");
                throw (Throwable)recognitionException;
            }
            throw new IllegalArgumentException();
        }
        List list = ctx.outers;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ctx.outers");
        return this.handleOuters(term, this.flatten(list));
    }

    @NotNull
    public Term visitTerm(@NotNull PrologParser.TermContext ctx) {
        Term term;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (ctx.isExpr) {
            PrologParser.ExpressionContext expressionContext = ctx.expression();
            Intrinsics.checkNotNullExpressionValue((Object)expressionContext, (String)"ctx.expression()");
            term = this.visitExpression(expressionContext);
        } else {
            Object object = ((ParseTree)ctx.children.get(0)).accept((ParseTreeVisitor)this);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ctx.children[0].accept(this)");
            term = (Term)object;
        }
        return term;
    }

    @NotNull
    public Term visitInteger(@NotNull PrologParser.IntegerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        BigInteger value = this.parseInteger(ctx);
        return (Term)this.scope.numOf(value);
    }

    @NotNull
    public Term visitReal(@NotNull PrologParser.RealContext ctx) {
        Term term;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        String raw = ctx.value.getText();
        if (ctx.sign != null) {
            raw = ctx.sign.getText() + raw;
        }
        try {
            String string = raw;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"raw");
            term = (Term)Real.Companion.of(string);
        }
        catch (NumberFormatException notAFloating) {
            Token token = ctx.value;
            Intrinsics.checkNotNullExpressionValue((Object)token, (String)"ctx.value");
            throw ParseExceptionExtKt.parseException(token, notAFloating);
        }
        return term;
    }

    @NotNull
    public Term visitVariable(@NotNull PrologParser.VariableContext ctx) {
        Term term;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (ctx.isAnonymous) {
            term = (Term)this.scope.anonymous();
        } else {
            String string = ctx.value.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ctx.value.text");
            term = (Term)this.scope.varOf(string);
        }
        return term;
    }

    @NotNull
    public Term visitStructure(@NotNull PrologParser.StructureContext ctx) {
        Term term;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (ctx.isList) {
            return (Term)this.scope.listOf(new Term[0]);
        }
        if (ctx.isBlock) {
            return (Term)this.scope.blockOf(new Term[0]);
        }
        if (ctx.arity == 0) {
            String string = ctx.functor.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ctx.functor.text");
            term = (Term)this.scope.atomOf(string);
        } else {
            String string = ctx.functor.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ctx.functor.text");
            List list = ctx.args;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ctx.args");
            term = (Term)this.scope.structOf(string, SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<PrologParser.ExpressionContext, Term>((Object)this){

                @NotNull
                public final Term invoke(@NotNull PrologParser.ExpressionContext p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((PrologExpressionVisitor)((Object)this.receiver)).visitExpression(p0);
                }
            })));
        }
        return term;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Term visitList(@NotNull PrologParser.ListContext ctx) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        List list = ctx.items;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ctx.items");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            PrologParser.ExpressionContext expressionContext = (PrologParser.ExpressionContext)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.visitExpression((PrologParser.ExpressionContext)p0));
        }
        List terms = (List)destination$iv$iv;
        return ctx.hasTail ? (Term)this.scope.listFrom((Iterable)terms, (Term)ctx.tail.accept((ParseTreeVisitor)this)) : (Term)this.scope.listOf((Iterable)terms);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Term visitBlock(@NotNull PrologParser.BlockContext ctx) {
        Term term;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (ctx.length == 1) {
            Term[] termArray = new Term[1];
            Object object = ((PrologParser.ExpressionContext)ctx.items.get(0)).accept((ParseTreeVisitor)this);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ctx.items[0].accept(this)");
            termArray[0] = (Term)object;
            term = (Term)this.scope.blockOf(termArray);
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List list = ctx.items;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ctx.items");
            Iterable iterable = list;
            Scope scope = this.scope;
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                PrologParser.ExpressionContext expressionContext = (PrologParser.ExpressionContext)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.visitExpression((PrologParser.ExpressionContext)p0));
            }
            term = (Term)scope.blockOf((Iterable)((List)destination$iv$iv));
        }
        return term;
    }

    private final BigInteger parseInteger(PrologParser.IntegerContext ctx) {
        String str = ctx.value.getText();
        int base = 0;
        String clean = null;
        if (ctx.isBin) {
            base = 2;
            Intrinsics.checkNotNullExpressionValue((Object)str, (String)"str");
            String string = str.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            clean = string;
        } else if (ctx.isOct) {
            base = 8;
            Intrinsics.checkNotNullExpressionValue((Object)str, (String)"str");
            String string = str.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            clean = string;
        } else if (ctx.isHex) {
            base = 16;
            Intrinsics.checkNotNullExpressionValue((Object)str, (String)"str");
            String string = str.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            clean = string;
        } else {
            if (ctx.isChar) {
                boolean bl;
                String string;
                Intrinsics.checkNotNullExpressionValue((Object)str, (String)"str");
                String string2 = str.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                clean = string2;
                if (clean.length() != 1) {
                    String string3 = ctx.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ctx.text");
                    throw new ParseException(null, string3, ctx.value.getLine(), ctx.value.getCharPositionInLine(), "Invalid character literal: " + ctx.getText(), null);
                }
                BigInteger $this$parseInteger_u24lambda_u2d1 = BigInteger.Companion.of((int)clean.charAt(0));
                boolean bl2 = false;
                Object object = ctx.sign;
                if (object != null && (object = (string = object.getText())) != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"text");
                    bl = StringsKt.contains$default((CharSequence)string, (CharSequence)"-", (boolean)false, (int)2, null);
                } else {
                    bl = false;
                }
                return bl ? $this$parseInteger_u24lambda_u2d1.unaryMinus() : $this$parseInteger_u24lambda_u2d1;
            }
            base = 10;
            Intrinsics.checkNotNullExpressionValue((Object)str, (String)"str");
            clean = str;
        }
        if (ctx.sign != null) {
            clean = ctx.sign.getText() + clean;
        }
        return BigInteger.Companion.of(clean, base);
    }

    /*
     * WARNING - void declaration
     */
    private final Term visitPostfixExpression(PrologParser.ExpressionContext ctx) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = ctx.left.accept((ParseTreeVisitor)this);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ctx.left.accept(this)");
        Term term = (Term)object;
        List list = ctx.operators;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ctx.operators");
        Iterable iterable = list;
        Term term2 = term;
        PrologExpressionVisitor prologExpressionVisitor = this;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PrologParser.OpContext opContext = (PrologParser.OpContext)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.symbol.getText());
        }
        collection = (List)destination$iv$iv;
        return prologExpressionVisitor.postfix(term2, (List<String>)collection);
    }

    private final Term postfix(Term term, List<String> ops) {
        Iterator<String> operator = ops.iterator();
        Term[] termArray = new Term[]{term};
        Term result = (Term)this.scope.structOf(operator.next(), termArray);
        while (operator.hasNext()) {
            termArray = new Term[]{result};
            result = (Term)this.scope.structOf(operator.next(), termArray);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final Term visitPrefixExpression(PrologParser.ExpressionContext ctx) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = ((PrologParser.ExpressionContext)ctx.right.get(0)).accept((ParseTreeVisitor)this);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ctx.right[0].accept(this)");
        Term term = (Term)object;
        List list = ctx.operators;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ctx.operators");
        Iterable iterable = list;
        Term term2 = term;
        PrologExpressionVisitor prologExpressionVisitor = this;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PrologParser.OpContext opContext = (PrologParser.OpContext)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.symbol.getText());
        }
        collection = (List)destination$iv$iv;
        return prologExpressionVisitor.prefix(term2, (List<String>)collection);
    }

    private final Term prefix(Term term, List<String> ops) {
        int i = ops.size() - 1;
        int n = i--;
        Term[] termArray = new Term[]{term};
        Term result = (Term)this.scope.structOf(ops.get(n), termArray);
        while (i >= 0) {
            termArray = new Term[]{result};
            result = (Term)this.scope.structOf(ops.get(i), termArray);
            --i;
        }
        return result;
    }

    private final Term visitInfixExpression(PrologParser.ExpressionContext ctx) {
        Term term;
        Associativity associativity = ctx.associativity;
        switch (associativity == null ? -1 : WhenMappings.$EnumSwitchMapping$0[associativity.ordinal()]) {
            case 1: {
                term = this.visitInfixRightAssociativeExpression(ctx);
                break;
            }
            case 2: {
                term = this.visitInfixLeftAssociativeExpression(ctx);
                break;
            }
            case 3: {
                term = this.visitInfixNonAssociativeExpression(ctx);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return term;
    }

    /*
     * WARNING - void declaration
     */
    private final Term visitInfixNonAssociativeExpression(PrologParser.ExpressionContext ctx) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Collection collection2 = CollectionsKt.listOf((Object)ctx.left);
        List list = ctx.right;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ctx.right");
        Iterable $this$map$iv = CollectionsKt.plus((Collection)collection2, (Iterable)list);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ParserRuleContext parserRuleContext = (ParserRuleContext)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Term)it.accept((ParseTreeVisitor)this));
        }
        List operands = (List)destination$iv$iv;
        List list2 = ctx.operators;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ctx.operators");
        Iterable $this$map$iv2 = list2;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PrologParser.OpContext bl = (PrologParser.OpContext)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.symbol.getText());
        }
        List operators = (List)destination$iv$iv2;
        return this.infixNonAssociative(operands, operators);
    }

    private final Term infixNonAssociative(List<? extends Term> terms, List<String> ops) {
        Term[] termArray = new Term[]{terms.get(0), terms.get(1)};
        return (Term)this.scope.structOf(ops.get(0), termArray);
    }

    /*
     * WARNING - void declaration
     */
    private final Term handleOuters(Term expression, List<? extends PrologParser.OuterContext> outers) {
        Term result = expression;
        for (PrologParser.OuterContext outerContext : outers) {
            Term term;
            void $this$mapTo$iv$iv;
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            Collection collection = CollectionsKt.listOf((Object)result);
            List list = outerContext.right;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"o.right");
            Iterable iterable = list;
            Collection collection2 = collection;
            boolean $i$f$map = false;
            void var9_11 = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                PrologParser.ExpressionContext expressionContext = (PrologParser.ExpressionContext)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                boolean bl = false;
                collection3.add((Term)it.accept((ParseTreeVisitor)this));
            }
            List operands = CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv));
            List list2 = outerContext.operators;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"o.operators");
            Iterable $this$map$iv2 = list2;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PrologParser.OpContext bl = (PrologParser.OpContext)item$iv$iv;
                collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(it.symbol.getText());
            }
            List operators = (List)destination$iv$iv2;
            Associativity associativity = outerContext.associativity;
            Intrinsics.checkNotNull((Object)associativity);
            switch (WhenMappings.$EnumSwitchMapping$0[associativity.ordinal()]) {
                case 1: {
                    term = this.infixRight(operands, operators);
                    break;
                }
                case 4: 
                case 5: {
                    term = this.postfix(result, operators);
                    break;
                }
                case 3: {
                    term = this.infixNonAssociative(operands, operators);
                    break;
                }
                case 2: {
                    term = this.infixLeft(operands, operators);
                    break;
                }
                case 6: 
                case 7: {
                    term = this.prefix(result, operators);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            result = term;
        }
        return result;
    }

    private final Term infixRight(List<? extends Term> terms, List<String> ops) {
        int i = terms.size() - 1;
        int j = ops.size() - 1;
        int n = j--;
        Term[] termArray = new Term[]{terms.get(i - 1), terms.get(i)};
        Term result = (Term)this.scope.structOf(ops.get(n), termArray);
        i -= 2;
        while (i >= 0) {
            int n2 = j--;
            termArray = new Term[]{terms.get(i), result};
            result = (Term)this.scope.structOf(ops.get(n2), termArray);
            --i;
        }
        return result;
    }

    private final Term infixLeft(List<? extends Term> terms, List<String> ops) {
        int i = 0;
        int j = 0;
        int n = j++;
        Term[] termArray = new Term[]{terms.get(i++), terms.get(i++)};
        Term result = (Term)this.scope.structOf(ops.get(n), termArray);
        while (i < terms.size()) {
            int n2 = j++;
            termArray = new Term[]{result, terms.get(i)};
            result = (Term)this.scope.structOf(ops.get(n2), termArray);
            ++i;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Term> listOfOperands(PrologParser.ExpressionContext ctx) {
        void $this$mapTo$iv$iv;
        Collection collection = CollectionsKt.listOf((Object)ctx.left);
        List list = ctx.right;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ctx.right");
        Iterable $this$map$iv = CollectionsKt.plus((Collection)collection, (Iterable)list);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ParserRuleContext parserRuleContext = (ParserRuleContext)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add((Term)it.accept((ParseTreeVisitor)this));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> listOfOperators(PrologParser.ExpressionContext ctx) {
        void $this$mapTo$iv$iv;
        List list = ctx.operators;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ctx.operators");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PrologParser.OpContext opContext = (PrologParser.OpContext)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.symbol.getText());
        }
        return (List)destination$iv$iv;
    }

    private final Term visitInfixRightAssociativeExpression(PrologParser.ExpressionContext ctx) {
        return this.infixRight(this.listOfOperands(ctx), this.listOfOperators(ctx));
    }

    private final Term visitInfixLeftAssociativeExpression(PrologParser.ExpressionContext ctx) {
        return this.infixLeft(this.listOfOperands(ctx), this.listOfOperators(ctx));
    }

    private final Sequence<PrologParser.OuterContext> flatten(Sequence<? extends PrologParser.OuterContext> outers) {
        return SequencesKt.flatMap(outers, (Function1)((Function1)new Function1<PrologParser.OuterContext, Sequence<? extends PrologParser.OuterContext>>(this){
            final /* synthetic */ PrologExpressionVisitor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Sequence<PrologParser.OuterContext> invoke(@NotNull PrologParser.OuterContext it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object[] objectArray = new PrologParser.OuterContext[]{it};
                Sequence sequence = SequencesKt.sequenceOf((Object[])objectArray);
                List list = it.outers;
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"it.outers");
                return SequencesKt.plus((Sequence)sequence, (Sequence)PrologExpressionVisitor.access$flatten(this.this$0, CollectionsKt.asSequence((Iterable)list)));
            }
        }));
    }

    private final List<PrologParser.OuterContext> flatten(List<? extends PrologParser.OuterContext> outers) {
        return SequencesKt.toList(this.flatten((Sequence<? extends PrologParser.OuterContext>)CollectionsKt.asSequence((Iterable)outers)));
    }

    public PrologExpressionVisitor() {
        this(null, 1, null);
    }

    public static final /* synthetic */ Sequence access$flatten(PrologExpressionVisitor $this, Sequence outers) {
        return $this.flatten((Sequence<? extends PrologParser.OuterContext>)outers);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Associativity.values().length];
            nArray[Associativity.XFY.ordinal()] = 1;
            nArray[Associativity.YFX.ordinal()] = 2;
            nArray[Associativity.XFX.ordinal()] = 3;
            nArray[Associativity.XF.ordinal()] = 4;
            nArray[Associativity.YF.ordinal()] = 5;
            nArray[Associativity.FX.ordinal()] = 6;
            nArray[Associativity.FY.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

