/*
 * Decompiled with CFR 0.152.
 */
package it.svario.xpathapi.jaxp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class NodeNamespaceContext
implements NamespaceContext {
    private Map<String, String> namespaces = new HashMap<String, String>();
    private String defaultNSURI = null;

    protected NodeNamespaceContext(Node node) {
        this.addCommonNamespaces();
        this.extractNamespacesFromNode(node);
    }

    protected NodeNamespaceContext(Node node, Map<String, String> namespaces) {
        this(node);
        this.namespaces.putAll(namespaces);
    }

    private void addCommonNamespaces() {
        this.namespaces.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.namespaces.put("xmlns", "http://www.w3.org/2000/xmlns/");
    }

    private void extractNamespacesFromNode(Node node) {
        NamedNodeMap attrs = node.getAttributes();
        if (attrs == null) {
            return;
        }
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (this.isDefaultNS(name) && this.defaultNSURI == null) {
                this.defaultNSURI = attr.getNodeValue();
                continue;
            }
            if (!this.isPrefix(name)) continue;
            String prefix = this.prefixStringIn(name);
            String uri = attr.getNodeValue();
            if (this.namespaces.containsKey(prefix)) continue;
            this.namespaces.put(prefix, uri);
        }
        Node parent = node.getParentNode();
        if (parent.getNodeType() == 1) {
            this.extractNamespacesFromNode(parent);
        } else if (parent.getNodeType() == 9 && this.defaultNSURI == null) {
            this.defaultNSURI = "";
        }
    }

    private boolean isDefaultNS(String name) {
        return name.equals("xmlns");
    }

    private boolean isPrefix(String name) {
        return name.startsWith("xmlns:");
    }

    private String prefixStringIn(String name) {
        int startIdx = name.indexOf(":");
        return name.substring(startIdx + 1);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (prefix.equals("")) {
            return this.defaultNSURI;
        }
        if (this.namespaces.containsKey(prefix)) {
            return this.namespaces.get(prefix);
        }
        return "";
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException();
        }
        if (namespaceURI.equals(this.defaultNSURI)) {
            return "";
        }
        for (Map.Entry<String, String> ns : this.namespaces.entrySet()) {
            if (!ns.getValue().equals(namespaceURI)) continue;
            return ns.getKey();
        }
        return null;
    }

    public Iterator getPrefixes(String namespaceURI) {
        HashSet<String> prefixes = new HashSet<String>();
        String prefix = this.getPrefix(namespaceURI);
        if (prefix != null) {
            prefixes.add(prefix);
        }
        return prefixes.iterator();
    }
}

