/*
 * Decompiled with CFR 0.152.
 */
package it.skrape.core.fetcher;

import com.gargoylesoftware.css.parser.CSSErrorHandler;
import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.NicelyResynchronizingAjaxController;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ProxyConfig;
import com.gargoylesoftware.htmlunit.SilentCssErrorHandler;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebClientOptions;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import it.skrape.core.fetcher.Authentication;
import it.skrape.core.fetcher.BrowserFetcherKt;
import it.skrape.core.fetcher.Cookie;
import it.skrape.core.fetcher.CookieKt;
import it.skrape.core.fetcher.Fetcher;
import it.skrape.core.fetcher.Method;
import it.skrape.core.fetcher.ProxyBuilder;
import it.skrape.core.fetcher.Request;
import it.skrape.core.fetcher.Result;
import it.skrape.exceptions.UnsupportedRequestOptionException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0002H\u0002R\u0014\u0010\u0004\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lit/skrape/core/fetcher/BrowserFetcher;", "Lit/skrape/core/fetcher/Fetcher;", "Lit/skrape/core/fetcher/Request;", "()V", "requestBuilder", "getRequestBuilder", "()Lit/skrape/core/fetcher/Request;", "createCookie", "Lcom/gargoylesoftware/htmlunit/util/Cookie;", "url", "", "name", "value", "fetch", "Lit/skrape/core/fetcher/Result;", "request", "createCookies", "", "Lcom/gargoylesoftware/htmlunit/WebClient;", "toStatus", "Lit/skrape/core/fetcher/Result$Status;", "Lcom/gargoylesoftware/htmlunit/WebResponse;", "withOptions", "withProxySettings", "Lcom/gargoylesoftware/htmlunit/WebClientOptions;", "core"})
public final class BrowserFetcher
implements Fetcher<Request> {
    public static final BrowserFetcher INSTANCE;

    @Override
    @NotNull
    public Request getRequestBuilder() {
        return new Request(null, null, null, null, null, null, 0, false, null, false, 1023, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Result fetch(@NotNull Request request) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        NameValuePair it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        String string;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (request.getMethod() != Method.GET) {
            throw (Throwable)new UnsupportedRequestOptionException("Browser mode only supports the http verb GET");
        }
        WebClient client2 = this.withOptions(new WebClient(BrowserVersion.BEST_SUPPORTED), request);
        Page page = client2.getPage(request.getUrl());
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"client.getPage(request.url)");
        Page page2 = page;
        WebResponse httpResponse = page2.getWebResponse();
        if (page2.isHtmlPage()) {
            Page page3 = page2;
            if (page3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.gargoylesoftware.htmlunit.html.HtmlPage");
            }
            string = ((HtmlPage)page3).asXml();
        } else {
            WebResponse webResponse = httpResponse;
            Intrinsics.checkNotNullExpressionValue((Object)webResponse, (String)"httpResponse");
            string = webResponse.getContentAsString();
        }
        String document2 = string;
        WebResponse webResponse = httpResponse;
        Intrinsics.checkNotNullExpressionValue((Object)webResponse, (String)"httpResponse");
        List list = webResponse.getResponseHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"httpResponse.responseHeaders");
        Map<String, String> headers = BrowserFetcherKt.toMap(list);
        String string2 = document2;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"document");
        Result.Status status = this.toStatus(httpResponse);
        String string3 = httpResponse.getContentType();
        String string4 = request.getUrl();
        List list2 = httpResponse.getResponseHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"httpResponse.responseHeaders");
        Iterable iterable = list2;
        String string5 = string4;
        Map<String, String> map = headers;
        String string6 = string3;
        Result.Status status2 = status;
        String string7 = string2;
        boolean $i$f$filter = false;
        void var10_14 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (NameValuePair)element$iv$iv;
            boolean bl = false;
            NameValuePair nameValuePair = it;
            Intrinsics.checkNotNullExpressionValue((Object)nameValuePair, (String)"it");
            if (!Intrinsics.areEqual((Object)nameValuePair.getName(), (Object)"Set-Cookie")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<Cookie> collection = (List)destination$iv$iv;
        $this$filter$iv = collection;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (NameValuePair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            NameValuePair nameValuePair = it;
            Intrinsics.checkNotNullExpressionValue((Object)nameValuePair, (String)"it");
            String string8 = nameValuePair.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"it.value");
            Cookie cookie = CookieKt.toCookie(string8, CookieKt.urlOrigin(request.getUrl()));
            collection.add(cookie);
        }
        Collection<Cookie> collection2 = collection = (List)destination$iv$iv;
        String string9 = string5;
        Map<String, String> map2 = map;
        String string10 = string6;
        Result.Status status3 = status2;
        String string11 = string7;
        Result result = new Result(string11, status3, string10, map2, string9, (List<Cookie>)collection2);
        client2.getJavaScriptEngine().shutdown();
        client2.close();
        client2.getCache().clear();
        page2.cleanUp();
        return result;
    }

    private final WebClient withOptions(WebClient $this$withOptions, Request request) {
        WebClient webClient = $this$withOptions;
        boolean bl = false;
        boolean bl2 = false;
        WebClient $this$apply = webClient;
        boolean bl3 = false;
        $this$apply.setCssErrorHandler((CSSErrorHandler)new SilentCssErrorHandler());
        $this$apply.setAjaxController((AjaxController)new NicelyResynchronizingAjaxController());
        INSTANCE.createCookies($this$apply, request);
        $this$apply.addRequestHeader("User-Agent", request.getUserAgent());
        if (request.getAuthentication() != null) {
            Authentication authentication = request.getAuthentication();
            Intrinsics.checkNotNull((Object)authentication);
            $this$apply.addRequestHeader("Authorization", authentication.toHeaderValue());
        }
        Map<String, String> $this$forEach$iv = request.getHeaders();
        boolean $i$f$forEach = false;
        Map<String, String> map = $this$forEach$iv;
        boolean bl4 = false;
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> it = element$iv = iterator.next();
            boolean bl5 = false;
            $this$apply.addRequestHeader(it.getKey(), it.getValue());
        }
        $this$apply.waitForBackgroundJavaScript(10000L);
        WebClientOptions webClientOptions = $this$apply.getOptions();
        boolean bl6 = false;
        boolean bl7 = false;
        WebClientOptions $this$apply2 = webClientOptions;
        boolean bl8 = false;
        $this$apply2.setTimeout(request.getTimeout());
        $this$apply2.setRedirectEnabled(request.getFollowRedirects());
        $this$apply2.setMaxInMemory(0);
        $this$apply2.setUseInsecureSSL(request.getSslRelaxed());
        $this$apply2.setCssEnabled(false);
        $this$apply2.setPopupBlockerEnabled(true);
        $this$apply2.setDownloadImages(false);
        $this$apply2.setThrowExceptionOnScriptError(false);
        $this$apply2.setThrowExceptionOnFailingStatusCode(false);
        $this$apply2.setPrintContentOnFailingStatusCode(false);
        $this$apply2.setHistorySizeLimit(0);
        $this$apply2.setHistoryPageCacheLimit(0);
        INSTANCE.withProxySettings($this$apply2, request);
        return webClient;
    }

    private final WebClientOptions withProxySettings(WebClientOptions $this$withProxySettings, Request request) {
        if (request.getProxy() != null) {
            ProxyBuilder proxyBuilder = request.getProxy();
            Intrinsics.checkNotNull((Object)proxyBuilder);
            String string = proxyBuilder.getHost();
            ProxyBuilder proxyBuilder2 = request.getProxy();
            Intrinsics.checkNotNull((Object)proxyBuilder2);
            int n = proxyBuilder2.getPort();
            ProxyBuilder proxyBuilder3 = request.getProxy();
            Intrinsics.checkNotNull((Object)proxyBuilder3);
            $this$withProxySettings.setProxyConfig(new ProxyConfig(string, n, proxyBuilder3.getType() == Proxy.Type.SOCKS));
        }
        return $this$withProxySettings;
    }

    private final void createCookies(WebClient $this$createCookies, Request request) {
        Map<String, String> $this$forEach$iv = request.getCookies();
        boolean $i$f$forEach = false;
        Map<String, String> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> it = element$iv = iterator.next();
            boolean bl2 = false;
            $this$createCookies.getCookieManager().addCookie(INSTANCE.createCookie(request.getUrl(), it.getKey(), it.getValue()));
        }
    }

    private final com.gargoylesoftware.htmlunit.util.Cookie createCookie(String url, String name, String value) {
        String domain = new URL(url).getHost();
        return new com.gargoylesoftware.htmlunit.util.Cookie(domain, name, value);
    }

    private final Result.Status toStatus(WebResponse $this$toStatus) {
        int n = $this$toStatus.getStatusCode();
        String string = $this$toStatus.getStatusMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"statusMessage");
        return new Result.Status(n, string);
    }

    private BrowserFetcher() {
    }

    static {
        BrowserFetcher browserFetcher;
        INSTANCE = browserFetcher = new BrowserFetcher();
    }
}

