/*
 * Decompiled with CFR 0.152.
 */
package it.micegroup.voila2runtime.mail.entity;

import it.micegroup.voila2runtime.mail.entity.MailBaseBean;
import it.micegroup.voila2runtime.mail.entity.MailConfig;
import it.micegroup.voila2runtime.mail.entity.MailSelector;
import it.micegroup.voila2runtime.mail.entity.MailStyle;
import it.micegroup.voila2runtime.mail.entity.SelectorPerTemplate;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public final class MailTemplate
extends MailBaseBean {
    private static final long serialVersionUID = 1280718653L;
    private static Log logger = LogFactory.getLog(MailTemplate.class);
    private String mailTemplateId;
    private String mailTemplateDescription;
    private String mailSubject;
    private String mailBodyHtml;
    private String mailBodyText;
    private String mailFrom;
    private String mailTo;
    private String mailCc;
    private String mailBcc;
    private String mailReplyTo;
    private boolean skipTitle = false;
    private boolean enabled = true;
    private String attachments;
    private MailConfig theMailConfig;
    private MailStyle theMailStyle;
    private Collection<SelectorPerTemplate> theSelectorPerTemplate = new ArrayList<SelectorPerTemplate>();

    public String getMailTemplateId() {
        return this.mailTemplateId;
    }

    public void setMailTemplateId(String mailTemplateId) {
        this.mailTemplateId = mailTemplateId;
    }

    public String getMailTemplateDescription() {
        return this.mailTemplateDescription;
    }

    public void setMailTemplateDescription(String mailTemplateDescription) {
        this.mailTemplateDescription = mailTemplateDescription;
    }

    public String getMailSubject() {
        return this.mailSubject;
    }

    public void setMailSubject(String mailSubject) {
        this.mailSubject = mailSubject;
    }

    public String getMailBodyHtml() {
        return this.mailBodyHtml;
    }

    public void setMailBodyHtml(String mailBodyHtml) {
        this.mailBodyHtml = mailBodyHtml;
    }

    public String getMailBodyText() {
        return this.mailBodyText;
    }

    public void setMailBodyText(String mailBodyText) {
        this.mailBodyText = mailBodyText;
    }

    public String getMailFrom() {
        return this.mailFrom;
    }

    public void setMailFrom(String mailFrom) {
        this.mailFrom = mailFrom;
    }

    public String getMailTo() {
        return this.mailTo;
    }

    public void setMailTo(String mailTo) {
        this.mailTo = mailTo;
    }

    public String getMailCc() {
        return this.mailCc;
    }

    public void setMailCc(String mailCc) {
        this.mailCc = mailCc;
    }

    public String getMailBcc() {
        return this.mailBcc;
    }

    public void setMailBcc(String mailBcc) {
        this.mailBcc = mailBcc;
    }

    public String getMailReplyTo() {
        return this.mailReplyTo;
    }

    public void setMailReplyTo(String mailReplyTo) {
        this.mailReplyTo = mailReplyTo;
    }

    public boolean isSkipTitle() {
        return this.skipTitle;
    }

    public void setSkipTitle(boolean skipTitle) {
        this.skipTitle = skipTitle;
    }

    public String getAttachments() {
        return this.attachments;
    }

    public void setAttachments(String attachments) {
        this.attachments = attachments;
    }

    public MailConfig getTheMailConfig() {
        return this.theMailConfig;
    }

    public void setTheMailConfig(MailConfig theMailConfig) {
        this.theMailConfig = theMailConfig;
    }

    public MailStyle getTheMailStyle() {
        return this.theMailStyle;
    }

    public void setTheMailStyle(MailStyle theMailStyle) {
        this.theMailStyle = theMailStyle;
    }

    public Collection<SelectorPerTemplate> getTheSelectorPerTemplate() {
        return this.theSelectorPerTemplate;
    }

    public void setTheSelectorPerTemplate(Collection<SelectorPerTemplate> theSelectorPerTemplate) {
        this.theSelectorPerTemplate = theSelectorPerTemplate;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void afterPropertiesSet() throws Exception {
        this.setMailTemplateId(this.getBeanName());
        if (this.getTheMailConfig() == null) {
            try {
                this.setTheMailConfig((MailConfig)this.getBeanFactory().getBean(MailConfig.class));
            }
            catch (NoSuchBeanDefinitionException e) {
                logger.fatal((Object)"No mail config defined or more than only one mail config found. If more mail config are defined please ensure that each mailTemplate have corresponding mail config defined thru the property theMailConfig.");
                throw e;
            }
        }
        if (this.getTheMailStyle() == null) {
            try {
                this.setTheMailStyle((MailStyle)this.getBeanFactory().getBean(MailStyle.class));
            }
            catch (NoSuchBeanDefinitionException e) {
                logger.fatal((Object)"No mail style defined or more than only one mail style found. If more mail style are defined please ensure that each mailTemplate have corresponding mail style defined thru the property theMailStyle.");
                throw e;
            }
        }
        this.setMailBodyHtml(StringUtils.trimToEmpty((String)this.getMailBodyHtml()));
        this.setMailBodyText(StringUtils.trimToEmpty((String)this.getMailBodyText()));
        this.setAttachments(StringUtils.trimToEmpty((String)this.getAttachments()));
        if (this.getMailFrom() == null) {
            this.setMailFrom(this.getTheMailConfig().getMailFromAddress());
        }
        if (this.getMailCc() == null) {
            this.setMailCc(this.getTheMailConfig().getMailCcAddress());
        }
        if (this.getMailBcc() == null) {
            this.setMailBcc(this.getTheMailConfig().getMailBccAddress());
        }
        if (this.getMailSubject() == null) {
            this.setMailSubject(this.getTheMailConfig().getMailDefaultSubject());
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Defined mail template: " + this));
        }
    }

    public Collection<MailSelector> getMailToSelectors() {
        return this.getMailSelectorFor("TO");
    }

    public Collection<MailSelector> getMailCcSelectors() {
        return this.getMailSelectorFor("CC");
    }

    public Collection<MailSelector> getMailBccSelectors() {
        return this.getMailSelectorFor("BCC");
    }

    public Collection<MailSelector> getMailSelectorFor(String type) {
        ArrayList<MailSelector> result = new ArrayList<MailSelector>();
        for (SelectorPerTemplate selector : this.getTheSelectorPerTemplate()) {
            if (!type.equalsIgnoreCase(selector.getTipoSelector())) continue;
            result.add(selector.getTheMailSelector());
        }
        return result;
    }

    public Collection<SelectorPerTemplate> getSelectorPerTemplateFor(String type) {
        ArrayList<SelectorPerTemplate> result = new ArrayList<SelectorPerTemplate>();
        for (SelectorPerTemplate selector : this.getTheSelectorPerTemplate()) {
            if (!type.equalsIgnoreCase(selector.getTipoSelector())) continue;
            result.add(selector);
        }
        return result;
    }

    public String toString() {
        return "MailTemplate [mailTemplateId=" + this.mailTemplateId + ", mailTemplateDescription=" + this.mailTemplateDescription + ", mailSubject=" + this.mailSubject + "]";
    }

    public void addTheSelectorPerTemplate(SelectorPerTemplate selectorPerTemplate) {
        selectorPerTemplate.setTheMailTemplate(this);
        this.getTheSelectorPerTemplate().add(selectorPerTemplate);
    }
}

