/*
 * Decompiled with CFR 0.152.
 */
package it.micegroup.voila2runtime.mail.entity;

import it.micegroup.voila2runtime.mail.entity.MailBaseBean;
import it.micegroup.voila2runtime.mail.entity.SelectorPerTemplate;
import it.micegroup.voila2runtime.utils.VelocityContextUtils;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.springframework.security.core.userdetails.UserDetails;

public final class MailSelector
extends MailBaseBean {
    private static final long serialVersionUID = 835688545L;
    private static Log logger = LogFactory.getLog(MailSelector.class);
    private String mailSelectorId;
    private String mailSelectorDescription;
    private String mailSelectorScript;
    private Collection<SelectorPerTemplate> theSelectorPerTemplate = new ArrayList<SelectorPerTemplate>();

    public String getMailSelectorId() {
        return this.mailSelectorId;
    }

    public void setMailSelectorId(String mailSelectorId) {
        this.mailSelectorId = mailSelectorId;
    }

    public String getMailSelectorDescription() {
        return this.mailSelectorDescription;
    }

    public void setMailSelectorDescription(String mailSelectorDescription) {
        this.mailSelectorDescription = mailSelectorDescription;
    }

    public String getMailSelectorScript() {
        return this.mailSelectorScript;
    }

    public void setMailSelectorScript(String mailSelectorScript) {
        this.mailSelectorScript = mailSelectorScript;
    }

    public Collection<SelectorPerTemplate> getTheSelectorPerTemplate() {
        return this.theSelectorPerTemplate;
    }

    public void setTheSelectorPerTemplate(Collection<SelectorPerTemplate> theSelectorPerTemplate) {
        this.theSelectorPerTemplate = theSelectorPerTemplate;
    }

    public void afterPropertiesSet() throws Exception {
        this.setMailSelectorId(this.getBeanName());
        this.setMailSelectorScript(StringUtils.trimToEmpty((String)this.getMailSelectorScript()));
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Defined mail selector: " + this));
        }
    }

    public String toString() {
        return "MailSelector [mailSelectorId=" + this.mailSelectorId + ", mailSelectorDescription=" + this.mailSelectorDescription + ", mailSelectorScript=" + this.mailSelectorScript + "]";
    }

    public Set<String> getSelectedEmails(Object dataObject, VelocityEngine velocityEngine) {
        VelocityContext context = new VelocityContext(VelocityContextUtils.getVelocityContextToolsMap());
        context.put("dataObject", dataObject);
        context.put("theSelectorPerTemplate", this.theSelectorPerTemplate);
        if (dataObject instanceof Map) {
            for (Map.Entry entry : ((Map)dataObject).entrySet()) {
                context.put((String)entry.getKey(), entry.getValue());
            }
        }
        String logString = "";
        StringWriter output = new StringWriter();
        try {
            velocityEngine.evaluate((Context)context, (Writer)output, logString, this.getMailSelectorScript());
        }
        catch (Exception e) {
            throw new RuntimeException("Errore durante la valutazione dello script del selector " + this + ". L'errore \ufffd il seguente: " + e.getLocalizedMessage());
        }
        String out = StringUtils.trimToEmpty((String)output.toString());
        String[] resultString = StringUtils.split((String)out, (String)"\n;,");
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < resultString.length; ++i) {
            resultString[i] = StringUtils.trimToNull((String)resultString[i]);
            if (resultString[i] == null) continue;
            result.add(resultString[i]);
        }
        return result;
    }

    public Set<String> getSelectedEmails(Object dataObject, UserDetails userCurrent, VelocityEngine velocityEngine) {
        VelocityContext context = new VelocityContext(VelocityContextUtils.getVelocityContextToolsMap());
        try {
            context.put("currentUser", (Object)userCurrent);
        }
        catch (Exception exception) {
            // empty catch block
        }
        context.put("dataObject", dataObject);
        context.put("theSelectorPerTemplate", this.theSelectorPerTemplate);
        if (dataObject instanceof Map) {
            for (Map.Entry entry : ((Map)dataObject).entrySet()) {
                context.put((String)entry.getKey(), entry.getValue());
            }
        }
        String logString = "";
        StringWriter output = new StringWriter();
        try {
            velocityEngine.evaluate((Context)context, (Writer)output, logString, this.getMailSelectorScript());
        }
        catch (Exception e) {
            throw new RuntimeException("Errore durante la valutazione dello script del selector " + this + ". L'errore \ufffd il seguente: " + e.getLocalizedMessage());
        }
        String out = StringUtils.trimToEmpty((String)output.toString());
        String[] resultString = StringUtils.split((String)out, (String)"\n;,");
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < resultString.length; ++i) {
            resultString[i] = StringUtils.trimToNull((String)resultString[i]);
            if (resultString[i] == null) continue;
            result.add(resultString[i]);
        }
        return result;
    }
}

