/*
 * Decompiled with CFR 0.152.
 */
package it.micegroup.voila2runtime.utils;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.tools.generic.DateTool;
import org.apache.velocity.tools.generic.MathTool;
import org.apache.velocity.tools.generic.NumberTool;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class VelocityContextUtils {
    private static Log logger = LogFactory.getLog(VelocityContextUtils.class);
    private static Map<String, Object> velocityContextToolsMap = new HashMap<String, Object>();
    private static VelocityContextUtils instance;
    private DateTimeFormatter dateFormatter = DateTimeFormat.forPattern((String)"yyyy/MM/dd");
    private DateTimeFormatter timeFormatter = DateTimeFormat.forPattern((String)"HH:mm:ss");
    private DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyy/MM/dd HH:mm:ss");

    public static VelocityContextUtils getInstance() {
        if (instance == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Creating new instance velocity context utility object");
            }
            instance = new VelocityContextUtils();
        }
        return instance;
    }

    public String getCurrentDate() {
        return this.dateFormatter.print(System.currentTimeMillis());
    }

    public String getCurrentTime() {
        return this.timeFormatter.print(System.currentTimeMillis());
    }

    public String getCurrentDateTime() {
        return this.dateTimeFormatter.print(System.currentTimeMillis());
    }

    public int getCurrentDayOfWeek() {
        return new DateTime().getDayOfWeek();
    }

    public int getCurrentDayOfMonth() {
        return new DateTime().getDayOfMonth();
    }

    public int getCurrentDayOfYear() {
        return new DateTime().getDayOfYear();
    }

    public int getCurrentMonthOfYear() {
        return new DateTime().getMonthOfYear();
    }

    public boolean isCurrentDateTimeBetween(String dateTimeFrom, String dateTimeTo) {
        return this.isDateBetween(this.getCurrentDateTime(), dateTimeFrom, dateTimeTo);
    }

    public boolean isCurrentDateBetween(String dateFrom, String dateTo) {
        return this.isDateBetween(this.getCurrentDate(), dateFrom, dateTo);
    }

    public boolean isCurrentDateBetween(Timestamp dateFrom, Timestamp dateTo) {
        return this.isDateBetween(this.getCurrentDate(), this.dateFormatter.print(dateFrom.getTime()), this.dateFormatter.print(dateTo.getTime()));
    }

    public boolean isCurrentTimeBetween(String timeFrom, String timeTo) {
        return this.isTimeBetween(this.getCurrentTime(), timeFrom, timeTo);
    }

    public boolean isCurrentDateTimeBefore(String dateTimeReference) {
        return this.isDateBefore(this.getCurrentDateTime(), dateTimeReference);
    }

    public boolean isCurrentDateBefore(String dateReference) {
        return this.isDateBefore(this.getCurrentDate(), dateReference);
    }

    public boolean isCurrentDateBefore(Timestamp dateReference) {
        return this.isDateBefore(this.getCurrentDate(), this.dateFormatter.print(dateReference.getTime()));
    }

    public boolean isCurrentTimeBefore(String timeReference) {
        return this.isTimeBefore(this.getCurrentTime(), timeReference);
    }

    public boolean isCurrentDateTimeAfter(String dateTimeReference) {
        return this.isDateAfter(this.getCurrentDateTime(), dateTimeReference);
    }

    public boolean isCurrentDateAfter(String dateReference) {
        return this.isDateAfter(this.getCurrentDate(), dateReference);
    }

    public boolean isCurrentDateAfter(Timestamp dateReference) {
        return this.isDateAfter(this.getCurrentDate(), this.dateFormatter.print(dateReference.getTime()));
    }

    public boolean isCurrentTimeAfter(String timeReference) {
        return this.isTimeAfter(this.getCurrentTime(), timeReference);
    }

    public boolean isCurrentDayOfWeek(int dayOfWeek) {
        return this.isDayOfWeek(this.getCurrentDate(), dayOfWeek);
    }

    public boolean isCurrentDayOfMonth(int dayOfMonth) {
        return this.isDayOfMonth(this.getCurrentDate(), dayOfMonth);
    }

    public boolean isCurrentDayOfYear(int dayOfYear) {
        return this.isDayOfYear(this.getCurrentDate(), dayOfYear);
    }

    public boolean isCurrentMonthOfYear(int monthOfYear) {
        return this.isMonthOfYear(this.getCurrentDate(), monthOfYear);
    }

    public boolean isDateTimeBetween(String dateTime, String dateTimeFrom, String dateTimeTo) {
        DateTime aDateTime = this.dateTimeFormatter.parseDateTime(dateTime);
        DateTime aDateTimeFrom = this.dateTimeFormatter.parseDateTime(dateTimeFrom);
        DateTime aDateTimeTo = this.dateTimeFormatter.parseDateTime(dateTimeTo);
        return this.isDateTimeBetween(aDateTime, aDateTimeFrom, aDateTimeTo);
    }

    public boolean isDateBetween(String date, String dateFrom, String dateTo) {
        DateTime aDateTime = this.dateFormatter.parseDateTime(date);
        DateTime aDateTimeFrom = this.dateFormatter.parseDateTime(dateFrom);
        DateTime aDateTimeTo = this.dateFormatter.parseDateTime(dateTo);
        return this.isDateTimeBetween(aDateTime, aDateTimeFrom, aDateTimeTo);
    }

    public boolean isTimeBetween(String time, String timeFrom, String timeTo) {
        DateTime aTime = this.timeFormatter.parseDateTime(time);
        DateTime aTimeFrom = this.timeFormatter.parseDateTime(timeFrom);
        DateTime aTimeTo = this.timeFormatter.parseDateTime(timeTo);
        return this.isDateTimeBetween(aTime, aTimeFrom, aTimeTo);
    }

    public boolean isDateTimeBefore(String dateTime, String dateTimeReference) {
        DateTime aDateTime = this.dateTimeFormatter.parseDateTime(dateTime);
        DateTime aDateTimeReference = this.dateTimeFormatter.parseDateTime(dateTimeReference);
        return this.isDateTimeBefore(aDateTime, aDateTimeReference);
    }

    public boolean isDateBefore(String date, String dateReference) {
        DateTime aDateTime = this.dateFormatter.parseDateTime(date);
        DateTime aDateTimeReference = this.dateFormatter.parseDateTime(dateReference);
        return this.isDateTimeBefore(aDateTime, aDateTimeReference);
    }

    public boolean isTimeBefore(String time, String timeReference) {
        DateTime aTime = this.timeFormatter.parseDateTime(time);
        DateTime aTimeReference = this.timeFormatter.parseDateTime(timeReference);
        return this.isDateTimeBefore(aTime, aTimeReference);
    }

    public boolean isDateTimeAfter(String dateTime, String dateTimeReference) {
        DateTime aDateTime = this.dateTimeFormatter.parseDateTime(dateTime);
        DateTime aDateTimeReference = this.dateTimeFormatter.parseDateTime(dateTimeReference);
        return this.isDateTimeAfter(aDateTime, aDateTimeReference);
    }

    public boolean isDateAfter(String date, String dateReference) {
        DateTime aDateTime = this.dateFormatter.parseDateTime(date);
        DateTime aDateTimeReference = this.dateFormatter.parseDateTime(dateReference);
        return this.isDateTimeAfter(aDateTime, aDateTimeReference);
    }

    public boolean isTimeAfter(String time, String timeReference) {
        DateTime aTime = this.timeFormatter.parseDateTime(time);
        DateTime aTimeReference = this.timeFormatter.parseDateTime(timeReference);
        return this.isDateTimeAfter(aTime, aTimeReference);
    }

    public boolean isDayOfWeek(String date, int dayOfWeek) {
        DateTime aDateTime = this.dateFormatter.parseDateTime(date);
        return this.isDayOfWeek(aDateTime, dayOfWeek);
    }

    public boolean isDayOfMonth(String date, int dayOfMonth) {
        DateTime aDateTime = this.dateFormatter.parseDateTime(date);
        return this.isDayOfMonth(aDateTime, dayOfMonth);
    }

    public boolean isDayOfYear(String date, int dayOfYear) {
        DateTime aDateTime = this.dateFormatter.parseDateTime(date);
        return this.isDayOfYear(aDateTime, dayOfYear);
    }

    public boolean isMonthOfYear(String date, int monthOfYear) {
        DateTime aDateTime = this.dateFormatter.parseDateTime(date);
        return this.isMonthOfYear(aDateTime, monthOfYear);
    }

    public boolean isIncludedInList(Object refValue, Object[] listValue, boolean defaultForEmptyList, boolean defaultForRefValueNull) {
        return true;
    }

    public boolean isIncludedInList(Comparable<Object> refValue, Collection<Comparable<Object>> listValue, boolean defaultForEmptyList, boolean defaultForRefValueNull) {
        boolean result = false;
        if (listValue == null || listValue.size() == 0) {
            result = defaultForEmptyList;
        } else if (refValue == null) {
            result = defaultForRefValueNull;
        } else {
            for (Comparable<Object> element : listValue) {
                if (element.compareTo(refValue) != 0) continue;
                result = true;
            }
        }
        return result;
    }

    private boolean isDateTimeBetween(DateTime date, DateTime dateFrom, DateTime dateTo) {
        return !date.isBefore((ReadableInstant)dateFrom) && !date.isAfter((ReadableInstant)dateTo);
    }

    private boolean isDateTimeBefore(DateTime date, DateTime dateReference) {
        return date.isBefore((ReadableInstant)dateReference);
    }

    private boolean isDateTimeAfter(DateTime date, DateTime dateReference) {
        return date.isAfter((ReadableInstant)dateReference);
    }

    private boolean isDayOfWeek(DateTime dateTimeRef, int dayOfWeek) {
        return dateTimeRef.getDayOfWeek() == dayOfWeek;
    }

    private boolean isDayOfMonth(DateTime dateTimeRef, int dayOfMonth) {
        return dateTimeRef.getDayOfMonth() == dayOfMonth;
    }

    private boolean isDayOfYear(DateTime dateTimeRef, int dayOfYear) {
        return dateTimeRef.getDayOfYear() == dayOfYear;
    }

    private boolean isMonthOfYear(DateTime dateTimeRef, int monthOfYear) {
        return dateTimeRef.getMonthOfYear() == monthOfYear;
    }

    public static Map<String, Object> getVelocityContextToolsMap() {
        return velocityContextToolsMap;
    }

    static {
        velocityContextToolsMap.put("math", new MathTool());
        velocityContextToolsMap.put("number", new NumberTool());
        velocityContextToolsMap.put("date", new DateTool());
        instance = null;
    }
}

