/*
 * Decompiled with CFR 0.152.
 */
package it.micegroup.voila2runtime.utils;

import com.turkraft.springfilter.boot.FilterSpecification;
import com.turkraft.springfilter.parser.Filter;
import com.turkraft.springfilter.parser.FilterParser;
import it.micegroup.voila2runtime.entity.GenericEntity;
import it.micegroup.voila2runtime.utils.ClearAclException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class AclUtils
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(AclUtils.class);
    private static final String CLEAR = "clear";
    private static final String ANY = "ANY";
    private static final String CURRENT_USER = "currentUser";
    private static final String VOILA_ACL_PROFILE = "voila.acl.profile.";
    private static final String VOILA_ACL_APPLICATION = "voila.acl.application.";
    private static ApplicationContext applicationContext;
    private static Environment env;
    private static VelocityEngine velocityEngine;

    public static <T extends GenericEntity> Specification<T> applyAcl(Specification<T> specification, String key) {
        Specification result = specification;
        Object currentUser = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        VelocityContext context = new VelocityContext();
        context.put(CURRENT_USER, currentUser);
        String velocityLog = "";
        Collection profiles = SecurityContextHolder.getContext().getAuthentication().getAuthorities();
        StringBuilder filter = new StringBuilder();
        String prefix = "";
        try {
            prefix = AclUtils.applySingleAcl(filter, prefix, VOILA_ACL_APPLICATION, key);
            prefix = AclUtils.applySingleAcl(filter, prefix, "voila.acl.profile.ANY.", key);
            for (GrantedAuthority grantedAuthority : profiles) {
                prefix = AclUtils.applySingleAcl(filter, prefix, VOILA_ACL_PROFILE + grantedAuthority.getAuthority() + ".", key);
                prefix = AclUtils.applySingleAcl(filter, prefix, VOILA_ACL_PROFILE + grantedAuthority.getAuthority() + ".", ANY);
            }
        }
        catch (ClearAclException e1) {
            log.info("Clearing ACL!");
            return result;
        }
        if (filter.length() > 0) {
            String filterString = filter.toString();
            StringWriter out = new StringWriter();
            filterString = filterString.replaceAll("\\@\\{", "\\$\\{");
            try {
                velocityEngine.evaluate((Context)context, (Writer)out, velocityLog, filterString);
            }
            catch (Exception e) {
                throw new RuntimeException("Error parsing acl with velocity: " + velocityLog, e);
            }
            filterString = out.toString();
            FilterSpecification aclFilter = new FilterSpecification((Filter)FilterParser.FilterContext.parse((String)filterString));
            result = FilterSpecification.merge((Specification[])new Specification[]{aclFilter, specification});
        }
        return result;
    }

    private static <T extends GenericEntity> String applySingleAcl(StringBuilder filter, String prefix, String baseKey, String key) throws ClearAclException {
        String[] keyParts = key.split("\\.");
        String compKey = "";
        for (String part : keyParts) {
            compKey = compKey + part;
            String acl = env.getProperty(baseKey + compKey);
            if (StringUtils.isNotEmpty((CharSequence)acl)) {
                if (CLEAR.equals(acl)) {
                    throw new ClearAclException();
                }
                filter.append(prefix).append(acl);
                prefix = " AND ";
            }
            compKey = compKey + ".";
        }
        return prefix;
    }

    public void setApplicationContext(ApplicationContext c) throws BeansException {
        applicationContext = c;
        env = c.getEnvironment();
        velocityEngine = (VelocityEngine)c.getBean(VelocityEngine.class);
    }
}

