/*
 * Decompiled with CFR 0.152.
 */
package it.mice.voila.runtime.web.menu;

import it.mice.voila.runtime.web.bean.MenuDefinition;
import it.mice.voila.runtime.web.bean.MenuItemDefinition;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class MenuDefinitionFactory
implements InitializingBean {
    public static final String SELECTED_MENU_ID = "jf.menuId";
    private Map<String, MenuDefinition> menus;
    private boolean autoGenerateEmptyLink = true;
    private String menuPageLink = "/menuPage";
    private boolean resetSession = true;

    public Map<String, MenuDefinition> getMenus() {
        return this.menus;
    }

    public void setMenus(Map<String, MenuDefinition> menus) {
        this.menus = menus;
    }

    public boolean isAutoGenerateEmptyLink() {
        return this.autoGenerateEmptyLink;
    }

    public void setAutoGenerateEmptyLink(boolean autoGenerateEmptyLink) {
        this.autoGenerateEmptyLink = autoGenerateEmptyLink;
    }

    public String getMenuPageLink() {
        return this.menuPageLink;
    }

    public void setMenuPageLink(String menuPageLink) {
        this.menuPageLink = menuPageLink;
    }

    public boolean isResetSession() {
        return this.resetSession;
    }

    public void setResetSession(boolean resetSession) {
        this.resetSession = resetSession;
    }

    public MenuDefinition getMenu(String menuName) {
        return this.menus.get(menuName);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notEmpty(this.menus, (String)"At least one menu definition must be provided");
        if (this.isAutoGenerateEmptyLink()) {
            for (MenuDefinition menuDefinition : this.menus.values()) {
                int[] menuLevel = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                this.generateAutolinkForMenu(menuDefinition, menuLevel, 0);
            }
        }
    }

    private void generateAutolinkForMenu(MenuDefinition menuDefinition, int[] menuLevel, int currentDepth) {
        for (int i = 0; i < menuDefinition.getMenuItems().length; ++i) {
            MenuItemDefinition menuItemDefinition = menuDefinition.getMenuItems()[i];
            this.updateMenuLevel(menuLevel, currentDepth);
            this.prepareLink(menuItemDefinition, menuLevel, currentDepth);
            if (menuItemDefinition.getMenuToShow() == null) continue;
            this.generateAutolinkForMenu(menuItemDefinition.getMenuToShow(), menuLevel, currentDepth + 1);
        }
    }

    private void updateMenuLevel(int[] menuLevel, int currentDepth) {
        int n = currentDepth;
        menuLevel[n] = menuLevel[n] + 1;
        for (int i = currentDepth + 1; i < 10; ++i) {
            menuLevel[i] = 0;
        }
    }

    private void prepareLink(MenuItemDefinition menuItemDefinition, int[] menuLevel, int currentDepth) {
        String baseLink = menuItemDefinition.getLink();
        String stringMenuLevel = "";
        String levelDelimiter = "";
        for (int i = 0; i <= currentDepth; ++i) {
            stringMenuLevel = stringMenuLevel + levelDelimiter + menuLevel[i];
            levelDelimiter = ".";
        }
        String resultLink = "";
        String paramSep = "?";
        if (baseLink == null || baseLink.trim().length() == 0) {
            resultLink = this.getMenuPageLink();
        } else {
            resultLink = baseLink;
            if (baseLink.indexOf("?") > -1) {
                paramSep = "&amp;";
            }
        }
        if (menuItemDefinition.isTrackMenuId()) {
            resultLink = resultLink + paramSep + SELECTED_MENU_ID + "=" + stringMenuLevel;
        }
        if (this.isResetSession() && menuItemDefinition.isResetSession()) {
            resultLink = resultLink + "&amp;resetSession=true";
        }
        menuItemDefinition.setLink(resultLink);
        menuItemDefinition.setItemId(stringMenuLevel);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }
}

