/*
 * Decompiled with CFR 0.152.
 */
package it.mice.voila.runtime.web.filter;

import it.mice.voila.runtime.web.filter.RequestUtils;
import it.mice.voila.runtime.web.filter.RuntimeMultipartHttpServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsFileUploadSupport;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class RuntimeMultipartResolver
extends CommonsMultipartResolver {
    public void setResolveLazily(boolean resolveLazily) {
        if (resolveLazily) {
            throw new IllegalArgumentException("Cannot use resolveLazily for this type of Multipart Request");
        }
    }

    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest request) throws MultipartException {
        HttpServletRequest appoRequest = request;
        while (appoRequest instanceof HttpServletRequestWrapper) {
            if (appoRequest instanceof MultipartHttpServletRequest) {
                return (MultipartHttpServletRequest)appoRequest;
            }
            appoRequest = ((HttpServletRequestWrapper)appoRequest).getRequest();
        }
        return super.resolveMultipart(request);
    }

    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest request, String submitButtonPrefix) throws MultipartException {
        Assert.notNull((Object)request, (String)"Request must not be null");
        CommonsFileUploadSupport.MultipartParsingResult parsingResult = this.parseRequest(request);
        for (String parmName : parsingResult.getMultipartParameters().keySet()) {
            String methodName;
            if (!parmName.startsWith(submitButtonPrefix)) continue;
            int endIndex = parmName.indexOf("?");
            String queryString = null;
            if (endIndex == -1) {
                methodName = parmName.substring(submitButtonPrefix.length());
            } else {
                methodName = parmName.substring(submitButtonPrefix.length(), endIndex);
                queryString = parmName.substring(endIndex + 1);
                parsingResult.getMultipartParameters().putAll(RequestUtils.convertToParameterMap(queryString));
            }
            return new RuntimeMultipartHttpServletRequest(request, (MultiValueMap<String, MultipartFile>)parsingResult.getMultipartFiles(), parsingResult.getMultipartParameters(), methodName, queryString);
        }
        return new RuntimeMultipartHttpServletRequest(request, (MultiValueMap<String, MultipartFile>)parsingResult.getMultipartFiles(), parsingResult.getMultipartParameters(), null, null);
    }
}

