/*
 * Decompiled with CFR 0.152.
 */
package it.mice.voila.runtime.web.filter;

import it.mice.voila.runtime.web.filter.MockRequestDispatcher;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.DefaultMultipartHttpServletRequest;

public class RuntimeMultipartHttpServletRequest
extends DefaultMultipartHttpServletRequest {
    private static Log logger = LogFactory.getLog(RuntimeMultipartHttpServletRequest.class);
    private HashMap extraParameters = new HashMap();
    private String extraQueryString;
    private String requestURI;
    private StringBuffer requestURL;
    private String servletPath;
    private String pathInfo;

    public RuntimeMultipartHttpServletRequest(HttpServletRequest wrappedRequest, MultiValueMap<String, MultipartFile> mpFiles, Map<String, String[]> mpParams, String actionName, String queryString) {
        super(wrappedRequest, mpFiles, mpParams, null);
        this.extraQueryString = queryString;
        this.requestURI = this.addActionNameToURI(actionName);
        this.requestURL = new StringBuffer(this.addActionNameToURL(actionName));
        if (StringUtils.isEmpty((String)wrappedRequest.getServletPath())) {
            this.pathInfo = this.addActionNameToPathInfo(actionName);
            this.servletPath = wrappedRequest.getServletPath();
        } else {
            this.pathInfo = wrappedRequest.getPathInfo();
            this.servletPath = this.addActionNameToServletPath(actionName);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("this.extraQueryString=" + this.extraQueryString));
            logger.debug((Object)("this.requestURI is " + this.requestURI + ", was " + wrappedRequest.getRequestURI()));
            logger.debug((Object)("this.requestURL is " + this.requestURL + ", was " + wrappedRequest.getRequestURL()));
            logger.debug((Object)("this.servletPath is " + this.servletPath + ", was " + wrappedRequest.getServletPath()));
            logger.debug((Object)("this.pathInfo is " + this.pathInfo + ", was " + wrappedRequest.getPathInfo()));
        }
    }

    public String getQueryString() {
        if (this.extraQueryString == null) {
            return this.getHttpRequest().getQueryString();
        }
        String originalQueryString = this.getHttpRequest().getQueryString();
        if (originalQueryString != null) {
            if (originalQueryString.indexOf("?") != -1) {
                return originalQueryString + "&" + this.extraQueryString;
            }
            return originalQueryString + "?" + this.extraQueryString;
        }
        return this.extraQueryString;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        return this.requestURL;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return new MockRequestDispatcher((HttpServletRequestWrapper)this, path);
    }

    private String addActionNameToURI(String actionName) {
        return this.addActionNameTo(this.getHttpRequest().getRequestURI(), actionName);
    }

    private String addActionNameToPathInfo(String actionName) {
        return this.addActionNameTo(this.getHttpRequest().getPathInfo(), actionName);
    }

    private String addActionNameToServletPath(String actionName) {
        return this.addActionNameTo(this.getHttpRequest().getServletPath(), actionName);
    }

    private String addActionNameToURL(String actionName) {
        return this.addActionNameTo(this.getHttpRequest().getRequestURL(), actionName);
    }

    private String addActionNameTo(CharSequence uri, String actionName) {
        if (actionName == null) {
            return uri.toString();
        }
        int pos = uri.toString().lastIndexOf("/") + 1;
        return uri.subSequence(0, pos) + actionName;
    }

    public HttpServletRequest getHttpRequest() {
        return this.getRequest();
    }
}

