package it.mice.voila.runtime.web.filter;

import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequestWrapper;

public class MockRequestDispatcher implements RequestDispatcher {

	private RequestDispatcher wrappedRequestDispatcher;
	private HttpServletRequestWrapper mockRequest;

	public MockRequestDispatcher(HttpServletRequestWrapper mockRequest, String path) {
		super();
		this.wrappedRequestDispatcher = mockRequest.getRequest().getRequestDispatcher(path);
		this.mockRequest = mockRequest;
	}

	public void forward(ServletRequest request, ServletResponse response)
			throws ServletException, IOException {
		wrappedRequestDispatcher.forward(mockRequest.getRequest(), response);
	}

	public void include(ServletRequest request, ServletResponse response)
			throws ServletException, IOException {
		wrappedRequestDispatcher.include(mockRequest.getRequest(), response);
	}

}
