package it.mice.voila.runtime.web.bean;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;

/**
 * Created by IntelliJ IDEA.
 * User: zzy9v4
 * Date: 5-giu-2006
 * Time: 12.01.17
 * To change this template use File | Settings | File Templates.
 */
public class MenuItemDefinition implements BeanNameAware, InitializingBean, Serializable {
    /**
	 * 
	 */
	private static final long serialVersionUID = -1262989829413197817L;

	private String beanName;

    private String appId;
    private String itemId;
    private String link;
    private String target;
    private int itemSize;
    private String alignment;
    private String content;
    private String contentKey;
    private String baseUrl;
    private String baseUrlKey;
    private String title;
    private String titleKey;
    private String description;
    private String descriptionKey;
    private String onClick;
    private MenuDefinition menuToShow;
    private boolean flagDisabled;
    private boolean flagRestricted;
    //Specific build menu item method. Possible values are:
    //1) disable - to disable the link;
    //2) hide - remove the menu item;
    //3) restrict - keep enabled the menu item and add a restricted zone icon;
    //4) disableAndRestrict - disable the element and draw the restricted icon.
    //5) null (default) - use default build menu method (see MenuFilterManager).
    private String buildMenuMethod = null;
    // boolean to change the default behaviour of resetSession, init to true for retro compatibility
    private boolean resetSession = true;
    private boolean trackMenuId = true;
    
    public String getBuildMenuMethod() {
		return buildMenuMethod;
	}

	public void setBuildMenuMethod(String buildMenuMethod) {
		this.buildMenuMethod = buildMenuMethod;
	}

	public String getItemId() {
		return itemId;
	}

	public void setItemId(String itemId) {
		this.itemId = itemId;
	}

	public String getLink() {
        return link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getTarget() {
        return target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public int getItemSize() {
        return itemSize;
    }

    public void setItemSize(int itemSize) {
        this.itemSize = itemSize;
    }

    public String getAlignment() {
        return alignment;
    }

    public void setAlignment(String alignment) {
        this.alignment = alignment;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContentKey() {
        return contentKey;
    }

    public void setContentKey(String contentKey) {
        this.contentKey = contentKey;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitleKey() {
        return titleKey;
    }

    public void setTitleKey(String titleKey) {
        this.titleKey = titleKey;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescriptionKey() {
        return descriptionKey;
    }

    public void setDescriptionKey(String descriptionKey) {
        this.descriptionKey = descriptionKey;
    }

    public MenuDefinition getMenuToShow() {
        return menuToShow;
    }

    public void setMenuToShow(MenuDefinition menuToShow) {
        this.menuToShow = menuToShow;
    }

    public boolean isFlagDisabled() {
        return flagDisabled;
    }

    public void setFlagDisabled(boolean flagDisabled) {
        this.flagDisabled = flagDisabled;
    }
    
    public boolean isFlagRestricted() {
		return flagRestricted;
	}

	public void setFlagRestricted(boolean flagRestricted) {
		this.flagRestricted = flagRestricted;
	}

	/**
	 * @return the resetSession
	 */
	public boolean isResetSession() {
		return resetSession;
	}

	/**
	 * @param resetSession the resetSession to set
	 */
	public void setResetSession(boolean resetSession) {
		this.resetSession = resetSession;
	}

	public boolean isTrackMenuId() {
		return trackMenuId;
	}

	public void setTrackMenuId(boolean trackMenuId) {
		this.trackMenuId = trackMenuId;
	}

	/**
     * Set the name of the bean in the bean factory that created this bean.
     * <p>Invoked after population of normal bean properties but before an init
     * callback like InitializingBean's afterPropertiesSet or a custom init-method.
     *
     * @param name the name of the bean in the factory
     */
    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getOnClick() {
		return onClick;
	}

	public void setOnClick(String onClick) {
		this.onClick = onClick;
	}

	public String getAppId() {
		return appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}

	public String getBaseUrl() {
		return baseUrl;
	}

	public void setBaseUrl(String baseUrl) {
		this.baseUrl = baseUrl;
	}

	public String getBaseUrlKey() {
		return baseUrlKey;
	}

	public void setBaseUrlKey(String baseUrlKey) {
		this.baseUrlKey = baseUrlKey;
	}

	/**
     * Returns a string representation of the object. In general, the
     * <code>toString</code> method returns a string that
     * "textually represents" this object. The result should
     * be a concise but informative representation that is easy for a
     * person to read.
     * It is recommended that all subclasses override this method.
     *
     * The <code>toString</code> method for class <code>Object</code>
     * returns a string consisting of the name of the class of which the
     * object is an instance, the at-sign character `<code>@</code>', and
     * the unsigned hexadecimal representation of the hash code of the
     * object. In other words, this method returns a string equal to the
     * value of:
     * <blockquote>
     * <pre>
     * getClass().getName() + '@' + Integer.toHexString(hashCode())
     * </pre></blockquote>
     *
     * @return a string representation of the object.
     */
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.DEFAULT_STYLE);
    }

	public void afterPropertiesSet() throws Exception {
		if (getTarget() != null && getTarget().length() > 0 && getLink() != null && getLink().indexOf('#') == -1) {
			link += "#";
		}
	}
}
