/*
 * Decompiled with CFR 0.152.
 */
package it.mice.voila.runtime.web.filter;

import it.mice.voila.runtime.web.filter.MockRequestDispatcher;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MockRequest
extends HttpServletRequestWrapper {
    private static Log logger = LogFactory.getLog(MockRequest.class);
    private HashMap extraParameters = new HashMap();
    private String extraQueryString;
    private String requestURI;
    private StringBuffer requestURL;
    private String servletPath;
    private String pathInfo;

    public MockRequest(HttpServletRequest wrappedRequest, String queryString, String actionName) {
        super(wrappedRequest);
        this.extraQueryString = queryString;
        this.requestURI = this.addActionNameToURI(actionName);
        this.requestURL = new StringBuffer(this.addActionNameToURL(actionName));
        if (StringUtils.isEmpty((String)this.getHttpRequest().getServletPath())) {
            this.pathInfo = this.addActionNameToPathInfo(actionName);
            this.servletPath = this.getHttpRequest().getServletPath();
        } else {
            this.pathInfo = this.getHttpRequest().getPathInfo();
            this.servletPath = this.addActionNameToServletPath(actionName);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("this.extraQueryString=" + this.extraQueryString));
            logger.debug((Object)("this.requestURI is " + this.requestURI + ", was " + this.getHttpRequest().getRequestURI()));
            logger.debug((Object)("this.requestURL is " + this.requestURL + ", was " + this.getHttpRequest().getRequestURL()));
            logger.debug((Object)("this.servletPath is " + this.servletPath + ", was " + this.getHttpRequest().getServletPath()));
            logger.debug((Object)("this.pathInfo is " + this.pathInfo + ", was " + this.getHttpRequest().getPathInfo()));
        }
        Map parameters = this.getRequest().getParameterMap();
        for (String paramName : parameters.keySet()) {
            String[] paramValues = (String[])parameters.get(paramName);
            this.addParameter(paramName, paramValues);
        }
    }

    private String addActionNameToURI(String actionName) {
        return this.addActionNameTo(this.getHttpRequest().getRequestURI(), actionName);
    }

    private String addActionNameToPathInfo(String actionName) {
        return this.addActionNameTo(this.getHttpRequest().getPathInfo(), actionName);
    }

    private String addActionNameToServletPath(String actionName) {
        return this.addActionNameTo(this.getHttpRequest().getServletPath(), actionName);
    }

    private String addActionNameToURL(String actionName) {
        return this.addActionNameTo(this.getHttpRequest().getRequestURL(), actionName);
    }

    private String addActionNameTo(CharSequence uri, String actionName) {
        if (actionName == null) {
            return uri.toString();
        }
        int pos = uri.toString().lastIndexOf("/") + 1;
        return uri.subSequence(0, pos) + actionName;
    }

    private void addParameter(String name, String[] values) {
        this.extraParameters.put(name, values);
    }

    public void setExtraQueryString(String extraQueryString) {
        this.extraQueryString = extraQueryString;
    }

    public String getQueryString() {
        if (this.extraQueryString == null) {
            return this.getHttpRequest().getQueryString();
        }
        String originalQueryString = this.getHttpRequest().getQueryString();
        if (originalQueryString != null) {
            if (originalQueryString.indexOf("?") != -1) {
                return originalQueryString + "&" + this.extraQueryString;
            }
            return originalQueryString + "?" + this.extraQueryString;
        }
        return this.extraQueryString;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        return this.requestURL;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getParameter(String string) {
        String parameter;
        Object parameters = this.extraParameters.get(string);
        if (parameters != null && (parameter = ((String[])parameters)[0]) != null) {
            return parameter;
        }
        return null;
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.extraParameters.keySet());
    }

    public String[] getParameterValues(String string) {
        Object ret = this.extraParameters.get(string);
        return (String[])ret;
    }

    public Map getParameterMap() {
        return this.extraParameters;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return new MockRequestDispatcher(this, path);
    }

    public HttpServletRequest getHttpRequest() {
        return (HttpServletRequest)this.getRequest();
    }
}

