package it.mice.voila.runtime.web.menu;

import it.mice.voila.runtime.security.SecurityBean;
import it.mice.voila.runtime.web.bean.MenuDefinition;

public class MenuNoFilterManager implements MenuFilterManager {
    private MenuDefinitionFactory menuDefinitionFactory;
    //Default build menu method. Possible values are:
    //1) disable - to disable the link;
    //2) hide - remove the menu item;
    //3) restrict - keep enabled the menu item and add a restricted zone icon;
    //4) disableAndRestrict - disable the element and draw the restricted icon.
    private String buildMenuMethod = "hide";

	public String getBuildMenuMethod() {
		return buildMenuMethod;
	}

	public void setBuildMenuMethod(String buildMenuMethod) {
		this.buildMenuMethod = buildMenuMethod;
	}

	public MenuDefinitionFactory getMenuDefinitionFactory() {
		return menuDefinitionFactory;
	}

	public void setMenuDefinitionFactory(MenuDefinitionFactory menuDefinitionFactory) {
		this.menuDefinitionFactory = menuDefinitionFactory;
	}

	public MenuDefinition getMenu(String menuName) {
        return getMenuDefinitionFactory().getMenu(menuName);
	}

	public MenuDefinition getFilteredMenu(String menuName) {
        return getMenu(menuName);
	}

	public boolean disableMenuItem(String link) {
		return false;
	}

	public boolean disableMenuItem(SecurityBean bean) {
		return false;
	}
}
