/*
 * Decompiled with CFR 0.152.
 */
package it.mice.voila.runtime.web.menu;

import it.mice.voila.runtime.security.AbstractFilterSecurityInterceptorPostProcessor;
import it.mice.voila.runtime.security.ApplicationHolder;
import it.mice.voila.runtime.security.RenderSecurityBean;
import it.mice.voila.runtime.security.SecurityBean;
import it.mice.voila.runtime.web.bean.MenuDefinition;
import it.mice.voila.runtime.web.bean.MenuItemDefinition;
import it.mice.voila.runtime.web.menu.MenuDefinitionFactory;
import it.mice.voila.runtime.web.menu.MenuFilterManager;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class StandardMenuFilterManager
implements MenuFilterManager {
    private static final Log logger = LogFactory.getLog(StandardMenuFilterManager.class);
    private MenuDefinitionFactory menuDefinitionFactory;
    private AbstractFilterSecurityInterceptorPostProcessor abstractFilterSecurityInterceptorPostProcessor;
    @Autowired
    ApplicationHolder applicationHolder;
    private String buildMenuMethod = "hide";

    public String getBuildMenuMethod() {
        return this.buildMenuMethod;
    }

    public void setBuildMenuMethod(String buildMenuMethod) {
        this.buildMenuMethod = buildMenuMethod;
    }

    public MenuDefinitionFactory getMenuDefinitionFactory() {
        return this.menuDefinitionFactory;
    }

    public void setMenuDefinitionFactory(MenuDefinitionFactory menuDefinitionFactory) {
        this.menuDefinitionFactory = menuDefinitionFactory;
    }

    public AbstractFilterSecurityInterceptorPostProcessor getFilterSecurityInterceptorPostProcessor() {
        return this.abstractFilterSecurityInterceptorPostProcessor;
    }

    public void setFilterSecurityInterceptorPostProcessor(AbstractFilterSecurityInterceptorPostProcessor abstractFilterSecurityInterceptorPostProcessor) {
        this.abstractFilterSecurityInterceptorPostProcessor = abstractFilterSecurityInterceptorPostProcessor;
    }

    public FilterSecurityInterceptor getFilterSecurityInterceptor() {
        return this.getFilterSecurityInterceptorPostProcessor().getFilterSecurityInterceptor();
    }

    @Override
    public MenuDefinition getMenu(String menuName) {
        return this.getMenuDefinitionFactory().getMenu(menuName);
    }

    @Override
    public MenuDefinition getFilteredMenu(String menuName) {
        MenuDefinition menuDefinition = this.getMenuDefinitionFactory().getMenu(menuName);
        try {
            return this.getFilterMenuDefinition(menuDefinition);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private MenuDefinition getFilterMenuDefinition(MenuDefinition menuDefinition) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        MenuDefinition filteredMenuDefinition = new MenuDefinition();
        PropertyUtils.copyProperties((Object)filteredMenuDefinition, (Object)menuDefinition);
        filteredMenuDefinition.setMenuItems(new MenuItemDefinition[0]);
        ArrayList<MenuItemDefinition> filteredMenuItems = new ArrayList<MenuItemDefinition>();
        MenuItemDefinition[] menuItemDefinitions = menuDefinition.getMenuItems();
        for (int i = 0; i < menuItemDefinitions.length; ++i) {
            if (menuItemDefinitions[i].getMenuToShow() == null) {
                if (this.disableMenuItem(menuItemDefinitions[i])) {
                    if (this.getBuildMenuMethod(menuItemDefinitions[i]).equals("hide")) continue;
                    MenuItemDefinition newMenuItemDefinition = this.duplicateMenuItem(menuItemDefinitions[i]);
                    if (this.getBuildMenuMethod(menuItemDefinitions[i]).equals("disable") || this.getBuildMenuMethod(menuItemDefinitions[i]).equals("disableAndRestrict")) {
                        newMenuItemDefinition.setFlagDisabled(true);
                    }
                    if (this.getBuildMenuMethod(menuItemDefinitions[i]).equals("restrict") || this.getBuildMenuMethod(menuItemDefinitions[i]).equals("disableAndRestrict")) {
                        newMenuItemDefinition.setFlagRestricted(true);
                    }
                    filteredMenuItems.add(newMenuItemDefinition);
                    continue;
                }
                filteredMenuItems.add(menuItemDefinitions[i]);
                continue;
            }
            MenuDefinition subMenuDefinition = this.getFilterMenuDefinition(menuItemDefinitions[i].getMenuToShow());
            if (subMenuDefinition.getMenuItems().length <= 0) continue;
            MenuItemDefinition newMenuItemDefinition = this.duplicateMenuItem(menuItemDefinitions[i]);
            newMenuItemDefinition.setMenuToShow(subMenuDefinition);
            filteredMenuItems.add(newMenuItemDefinition);
        }
        if (filteredMenuItems.size() > 0) {
            filteredMenuDefinition.setMenuItems(filteredMenuItems.toArray(new MenuItemDefinition[0]));
        }
        return filteredMenuDefinition;
    }

    public boolean disableMenuItem(MenuItemDefinition mid) {
        String prefix = "";
        if (mid.getAppId() != null && !mid.getAppId().equals(this.applicationHolder.getApplicationId())) {
            prefix = mid.getAppId() + ":";
        }
        return this.disableMenuItem(prefix, mid.getLink());
    }

    @Override
    public boolean disableMenuItem(String link) {
        return this.disableMenuItem("", link);
    }

    public boolean disableMenuItem(String prefix, String link) {
        return this.disableMenuItem((SecurityBean)new RenderSecurityBean(prefix + link, this.buildSessionSecurityBean()));
    }

    private Map<String, Object> buildSessionSecurityBean() {
        ServletRequestAttributes attr = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpSession session = attr.getRequest().getSession();
        Enumeration en = session.getAttributeNames();
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            Object value = session.getAttribute(key);
            ctx.put(key, value);
        }
        return ctx;
    }

    @Override
    public boolean disableMenuItem(SecurityBean bean) {
        DefaultFilterInvocationSecurityMetadataSource metadataSource = (DefaultFilterInvocationSecurityMetadataSource)this.getFilterSecurityInterceptor().obtainSecurityMetadataSource();
        Collection attr = metadataSource.getAttributes((Object)new FilterInvocation(bean.getLink(), null));
        if (attr != null) {
            Authentication authenticated;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Secure object: " + bean.getLink() + "; ConfigAttributes: " + attr.toString()));
            }
            if (SecurityContextHolder.getContext().getAuthentication() == null) {
                logger.error((Object)"An Authentication object was not found in the SecurityContext. Menu item disabled.");
                return true;
            }
            if (!SecurityContextHolder.getContext().getAuthentication().isAuthenticated()) {
                authenticated = this.getFilterSecurityInterceptor().getAuthenticationManager().authenticate(SecurityContextHolder.getContext().getAuthentication());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Successfully Authenticated: " + authenticated.toString()));
                }
                SecurityContextHolder.getContext().setAuthentication(authenticated);
            } else {
                authenticated = SecurityContextHolder.getContext().getAuthentication();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Previously Authenticated: " + authenticated.toString()));
                }
            }
            try {
                this.getFilterSecurityInterceptor().getAccessDecisionManager().decide(authenticated, (Object)bean, attr);
            }
            catch (AccessDeniedException accessDeniedException) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Operation name: " + bean.getLink() + " not allowed for current user: " + authenticated.toString() + ". Menu item disabled."));
                }
                return true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authorization successful for operation name: " + bean.getLink() + ". Menu item enabled."));
            }
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Operation name: " + bean.getLink() + " refer to a public object - authentication not attempted. Menu item enabled."));
        }
        return false;
    }

    public String getBuildMenuMethod(MenuItemDefinition menuItemDefinition) {
        if (menuItemDefinition.getBuildMenuMethod() != null) {
            return menuItemDefinition.getBuildMenuMethod();
        }
        return this.buildMenuMethod;
    }

    private MenuItemDefinition duplicateMenuItem(MenuItemDefinition menuItemDefinition) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        MenuItemDefinition filteredMenuItemDefinition = new MenuItemDefinition();
        PropertyUtils.copyProperties((Object)filteredMenuItemDefinition, (Object)menuItemDefinition);
        return filteredMenuItemDefinition;
    }
}

