/*
 * Decompiled with CFR 0.152.
 */
package it.mice.voila.runtime.web.filter;

import it.mice.voila.runtime.web.filter.MockRequest;
import it.mice.voila.runtime.web.filter.RequestUtils;
import it.mice.voila.runtime.web.filter.RuntimeMultipartResolver;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class SubmitButtonFilter
implements Filter {
    public static final String BUTTON_SUBMIT_PREFIX = "button.submit.";
    private Log log;
    private static String submitButtonPrefixName;

    public void init(FilterConfig filterConfig) {
        this.log = LogFactory.getLog(SubmitButtonFilter.class);
        SubmitButtonFilter.setSubmitButtonPrefixName(filterConfig.getInitParameter("submitButtonPrefixName"));
        if (SubmitButtonFilter.getSubmitButtonPrefixName() == null) {
            SubmitButtonFilter.setSubmitButtonPrefixName(BUTTON_SUBMIT_PREFIX);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"submitButtonPrefixName filter config parameter not specified. Assumed default:button.submit.");
            }
        }
        this.log.info((Object)("Filter initialized. SubmitButtonPrefixName=" + SubmitButtonFilter.getSubmitButtonPrefixName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        RuntimeMultipartResolver resolver = null;
        Object alreadyFilteredFlag = servletRequest.getAttribute("jfAlreadyFilteredFlag");
        Object servletRequestForNextFilter = servletRequest;
        if (alreadyFilteredFlag == null) {
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)((HttpServletRequest)servletRequest))) {
                resolver = new RuntimeMultipartResolver();
                servletRequestForNextFilter = resolver.resolveMultipart((HttpServletRequest)servletRequest, SubmitButtonFilter.getSubmitButtonPrefixName());
            } else {
                String submitButtonParameterName = RequestUtils.findSubmitButtonParameterName((HttpServletRequest)servletRequest, SubmitButtonFilter.getSubmitButtonPrefixName());
                if (submitButtonParameterName != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Button submit:" + submitButtonParameterName + " found."));
                    }
                    servletRequestForNextFilter = this.prepareMockRequest((HttpServletRequest)servletRequest, submitButtonParameterName);
                }
            }
            servletRequest.setAttribute("jfAlreadyFilteredFlag", (Object)Boolean.TRUE);
        }
        try {
            filterChain.doFilter(servletRequestForNextFilter, servletResponse);
        }
        finally {
            if (servletRequestForNextFilter instanceof MultipartHttpServletRequest && resolver != null) {
                resolver.cleanupMultipart((MultipartHttpServletRequest)servletRequestForNextFilter);
            }
        }
    }

    private MockRequest prepareMockRequest(HttpServletRequest servletRequest, String submitButtonParameterName) {
        String methodName;
        int endIndex = submitButtonParameterName.indexOf("?");
        String queryString = null;
        if (endIndex == -1) {
            methodName = submitButtonParameterName.substring(SubmitButtonFilter.getSubmitButtonPrefixName().length());
        } else {
            methodName = submitButtonParameterName.substring(SubmitButtonFilter.getSubmitButtonPrefixName().length(), endIndex);
            queryString = submitButtonParameterName.substring(endIndex + 1);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Button submit parsed. methodName=" + methodName + "; queryString=" + queryString));
        }
        MockRequest mockRequest = new MockRequest(servletRequest, queryString, methodName);
        if (queryString != null) {
            mockRequest.getParameterMap().putAll(RequestUtils.convertToParameterMap(queryString));
        }
        return mockRequest;
    }

    public static String getSubmitButtonPrefixName() {
        return submitButtonPrefixName;
    }

    public static void setSubmitButtonPrefixName(String submitButtonPrefixName) {
        SubmitButtonFilter.submitButtonPrefixName = submitButtonPrefixName;
    }

    public void destroy() {
    }
}

