/*
 * Decompiled with CFR 0.152.
 */
package it.mice.voila.runtime.security;

import it.mice.voila.runtime.security.UserProfileGrantedAuthorityImpl;
import it.mice.voila.runtime.util.StringUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;

public class UserDetailImpl
implements UserDetails {
    private String password;
    private String username;
    private String firstName;
    private String middleName;
    private String lastName;
    private Collection<GrantedAuthority> authorities;
    private boolean accountNonExpired;
    private boolean accountNonLocked;
    private boolean credentialsNonExpired;
    private boolean enabled;
    private String userProperties;
    private Properties userChainProperties = null;
    private String rolePrefix = null;
    private Object securityUser = null;
    private String applicationId = null;
    private static final long serialVersionUID = -7940129298244451321L;

    public UserDetailImpl(String username, String password, boolean enabled, boolean accountNonExpired, boolean credentialsNonExpired, boolean accountNonLocked, Collection<GrantedAuthority> authorities, String userProp) throws IllegalArgumentException {
        if (username == null || "".equals(username) || password == null) {
            throw new IllegalArgumentException("Cannot pass null or empty values to constructor");
        }
        this.username = username;
        this.password = password;
        this.enabled = enabled;
        this.accountNonExpired = accountNonExpired;
        this.credentialsNonExpired = credentialsNonExpired;
        this.accountNonLocked = accountNonLocked;
        this.userProperties = StringUtils.convertToProperties((String)userProp);
        this.setAuthorities(authorities);
    }

    public UserDetailImpl() {
    }

    public boolean equals(Object rhs) {
        if (!(rhs instanceof UserDetailImpl) || rhs == null) {
            return false;
        }
        UserDetailImpl user = (UserDetailImpl)rhs;
        if (user.getAuthorities().size() != this.getAuthorities().size()) {
            return false;
        }
        Iterator<GrantedAuthority> thisIter = this.getAuthorities().iterator();
        Iterator<GrantedAuthority> iterator = user.getAuthorities().iterator();
        while (iterator.hasNext()) {
            GrantedAuthority thisGrantedAuthority = thisIter.next();
            GrantedAuthority grantedAuthority = iterator.next();
            if (grantedAuthority.equals(thisGrantedAuthority)) continue;
            return false;
        }
        return this.getPassword().equals(user.getPassword()) && this.getUsername().equals(user.getUsername()) && this.isAccountNonExpired() == user.isAccountNonExpired() && this.isAccountNonLocked() == user.isAccountNonLocked() && this.isCredentialsNonExpired() == user.isCredentialsNonExpired() && this.isEnabled() == user.isEnabled();
    }

    public Collection<GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setAccountNonExpired(boolean accountNonExpired) {
        this.accountNonExpired = accountNonExpired;
    }

    public void setAccountNonLocked(boolean accountNonLocked) {
        this.accountNonLocked = accountNonLocked;
    }

    public void setCredentialsNonExpired(boolean credentialsNonExpired) {
        this.credentialsNonExpired = credentialsNonExpired;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Object getSecurityUser() {
        return this.securityUser;
    }

    public void setSecurityUser(Object securityUser) {
        this.securityUser = securityUser;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public int hashCode() {
        int code = 9792;
        if (this.getAuthorities() != null) {
            for (GrantedAuthority grantedAuthority : this.getAuthorities()) {
                code *= grantedAuthority.hashCode() % 7;
            }
        }
        if (this.getPassword() != null) {
            code *= this.getPassword().hashCode() % 7;
        }
        if (this.getUsername() != null) {
            code *= this.getUsername().hashCode() % 7;
        }
        if (this.isAccountNonExpired()) {
            code *= -2;
        }
        if (this.isAccountNonLocked()) {
            code *= -3;
        }
        if (this.isCredentialsNonExpired()) {
            code *= -5;
        }
        if (this.isEnabled()) {
            code *= -7;
        }
        return code;
    }

    public boolean isAccountNonExpired() {
        return this.accountNonExpired;
    }

    public boolean isAccountNonLocked() {
        return this.accountNonLocked;
    }

    public boolean isCredentialsNonExpired() {
        return this.credentialsNonExpired;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getUserDescription() {
        StringBuffer sb = new StringBuffer();
        if (this.getFirstName() != null) {
            sb.append(this.getFirstName()).append(" ");
        }
        if (this.getMiddleName() != null) {
            sb.append(this.getMiddleName()).append(" ");
        }
        if (this.getLastName() != null) {
            sb.append(this.getLastName());
        }
        return sb.toString();
    }

    public void setAuthorities(Collection<GrantedAuthority> authorities) {
        Assert.notNull(authorities, (String)"Cannot pass a null GrantedAuthority array");
        for (GrantedAuthority grantedAuthority : authorities) {
            Assert.notNull((Object)grantedAuthority, (String)"Granted authority element is null - GrantedAuthority[] cannot contain any null elements");
        }
        this.authorities = authorities;
    }

    public String getUserProperties() {
        return this.userProperties;
    }

    public void setUserProperties(String userProperties) {
        this.userProperties = StringUtils.convertToProperties((String)userProperties);
    }

    public String getRolePrefix() {
        return this.rolePrefix;
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString()).append(": ");
        sb.append("Username: ").append(this.username).append("; ");
        sb.append("Password: [PROTECTED]; ");
        sb.append("Enabled: ").append(this.enabled).append("; ");
        sb.append("AccountNonExpired: ").append(this.accountNonExpired).append("; ");
        sb.append("credentialsNonExpired: ").append(this.credentialsNonExpired).append("; ");
        sb.append("AccountNonLocked: ").append(this.accountNonLocked).append("; ");
        if (this.getAuthorities() != null) {
            sb.append("Granted Authorities: ");
            sb.append(this.getAuthorities());
        } else {
            sb.append("Not granted any authorities");
        }
        return sb.toString();
    }

    public Properties getUserChainProperties() {
        if (this.userChainProperties == null) {
            this.userChainProperties = new Properties();
            this.addUserProperties(this.userChainProperties, this.getUserProperties());
            for (GrantedAuthority grantedAuthority : this.getAuthorities()) {
                this.addUserProperties(this.userChainProperties, ((UserProfileGrantedAuthorityImpl)grantedAuthority).getProfileProps());
                this.addUserProperties(this.userChainProperties, ((UserProfileGrantedAuthorityImpl)grantedAuthority).getProfilePerUserProps());
            }
        }
        return this.userChainProperties;
    }

    private void addUserProperties(Properties userChainProperties, String PropertyPart) {
        StringTokenizer st = new StringTokenizer(PropertyPart, ";\n\r");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int startPos = token.indexOf("$");
            int endPos = token.indexOf("=");
            String propName = token.substring(startPos + 1, endPos);
            int endPos2 = token.indexOf(")");
            String propValue = token.substring(endPos + 1, endPos2);
            userChainProperties.put(propName.trim(), propValue.trim());
        }
    }

    public boolean hasProfile(String profileName) {
        String roleName = this.getRolePrefix() != null ? this.getRolePrefix() + profileName : profileName;
        for (GrantedAuthority grantedAuthority : this.getAuthorities()) {
            if (!grantedAuthority.getAuthority().equalsIgnoreCase(roleName)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getAclQueryText(String queryId) {
        HashSet<String> result = new HashSet<String>();
        for (GrantedAuthority authority : this.getAuthorities()) {
            String aclQuery;
            UserProfileGrantedAuthorityImpl grantedAuthority;
            if (!(authority instanceof UserProfileGrantedAuthorityImpl) || !(grantedAuthority = (UserProfileGrantedAuthorityImpl)authority).getApplicationId().equalsIgnoreCase(this.getApplicationId()) || (aclQuery = grantedAuthority.getAclQueryText(queryId)) == null) continue;
            result.add(aclQuery);
        }
        return result;
    }
}

