/*
 * Decompiled with CFR 0.152.
 */
package it.mice.voila.runtime.security;

import it.mice.voila.runtime.security.AbstractFilterSecurityInterceptorPostProcessor;
import it.mice.voila.runtime.security.OperationConfigAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.web.util.AntPathRequestMatcher;
import org.springframework.security.web.util.RequestMatcher;

public class InMemoryFilterSecurityInterceptorPostProcessor
extends AbstractFilterSecurityInterceptorPostProcessor {
    private static final Log LOGGER = LogFactory.getLog(InMemoryFilterSecurityInterceptorPostProcessor.class);
    private Collection<OperationConfigAttribute> elementaryOperationList = new ArrayList<OperationConfigAttribute>();

    public Collection<OperationConfigAttribute> getElementaryOperationList() {
        return this.elementaryOperationList;
    }

    public void setElementaryOperationList(Collection<OperationConfigAttribute> elementaryOperationList) {
        this.elementaryOperationList = elementaryOperationList;
    }

    @Override
    protected void populateRequestMapFromSiteMap(Map<RequestMatcher, Collection<ConfigAttribute>> requestMap) {
        if (this.elementaryOperationList.size() == 0) {
            LOGGER.warn((Object)"Current application  has no elementary operation or its ID is wrong. Check applicationContext-Security.xml file.");
        }
        Iterator<OperationConfigAttribute> iOper = this.elementaryOperationList.iterator();
        int c = 1;
        while (iOper.hasNext()) {
            OperationConfigAttribute theElementaryOperation = iOper.next();
            if (theElementaryOperation.getOperationId() == 0) {
                theElementaryOperation.setOperationId(c++);
            }
            String methodName = theElementaryOperation.getOperationName();
            List<ConfigAttribute> cad = this.buildConfigAttributeDefinition(theElementaryOperation);
            try {
                requestMap.put((RequestMatcher)new AntPathRequestMatcher(methodName + "*"), cad);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error((Object)("Problem during method definition map building from table SecurityElementaryOperation. Check data table for " + methodName + ". Cause:" + e.getMessage()));
            }
        }
    }

    private List<ConfigAttribute> buildConfigAttributeDefinition(OperationConfigAttribute theElementaryOperation) {
        ArrayList<ConfigAttribute> cad = new ArrayList<ConfigAttribute>();
        cad.add(theElementaryOperation);
        return cad;
    }
}

