/*
 * Decompiled with CFR 0.152.
 */
package it.mice.voila.runtime.security;

import it.mice.voila.runtime.util.StringUtils;
import java.io.Serializable;
import java.util.Map;
import org.springframework.security.core.GrantedAuthority;

public class UserProfileGrantedAuthorityImpl
implements GrantedAuthority,
Serializable {
    private String applicationId;
    private String profileName;
    private String profileProps;
    private Map<String, String> aclQueries;
    private String profileAssociationRule;
    private String profilePerUserProps;
    private String profilePerUserAssociationRule;
    private static final long serialVersionUID = 1307853517026126630L;

    public UserProfileGrantedAuthorityImpl(String applicationId, String profileName, String profileProps, String profileAssociationRule, String profilePerUserProps, String profilePerUserAssociationRule, String aclQueries) {
        this.applicationId = applicationId;
        this.profileName = profileName;
        this.profileProps = StringUtils.convertToProperties((String)profileProps);
        this.profileAssociationRule = profileAssociationRule;
        this.profilePerUserProps = StringUtils.convertToProperties((String)profilePerUserProps);
        this.profilePerUserAssociationRule = profilePerUserAssociationRule;
        this.aclQueries = StringUtils.convertToMap((String)aclQueries);
    }

    public String getAclQueryText(String queryId) {
        return this.aclQueries.get(queryId);
    }

    public UserProfileGrantedAuthorityImpl() {
    }

    public String getAuthority() {
        return this.profileName;
    }

    public void setAuthority(String profileName) {
        this.profileName = profileName;
    }

    public UserProfileGrantedAuthorityImpl getJfAuthority() {
        return this;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getProfileProps() {
        return this.profileProps;
    }

    public void setProfileProps(String profileProps) {
        this.profileProps = profileProps;
    }

    public String getProfileAssociationRule() {
        return this.profileAssociationRule;
    }

    public void setProfileAssociationRule(String profileAssociationRule) {
        this.profileAssociationRule = profileAssociationRule;
    }

    public String getProfilePerUserProps() {
        return this.profilePerUserProps;
    }

    public void setProfilePerUserProps(String profilePerUserProps) {
        this.profilePerUserProps = profilePerUserProps;
    }

    public String getProfilePerUserAssociationRule() {
        return this.profilePerUserAssociationRule;
    }

    public void setProfilePerUserAssociationRule(String profilePerUserAssociationRule) {
        this.profilePerUserAssociationRule = profilePerUserAssociationRule;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString()).append(": ");
        sb.append("appId: ").append(this.applicationId).append("; ");
        sb.append("profileName: ").append(this.profileName).append("; ");
        sb.append("profileProps: ").append(this.profileProps).append("; ");
        sb.append("profileAssociationRule: ").append(this.profileAssociationRule).append("; ");
        sb.append("profilePerUserProps: ").append(this.profilePerUserProps).append("; ");
        sb.append("profilePerUserAssociationRule: ").append(this.profilePerUserAssociationRule).append("; ");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserProfileGrantedAuthorityImpl that = (UserProfileGrantedAuthorityImpl)o;
        return !(this.profileName != null ? !this.profileName.equals(that.profileName) : that.profileName != null);
    }

    public int hashCode() {
        return this.profileName != null ? this.profileName.hashCode() : 0;
    }
}

