package it.mice.voila.runtime.security;

import it.mice.voila.runtime.util.StringUtils;

import java.io.Serializable;
import java.util.Map;

import org.springframework.security.core.GrantedAuthority;

/**
 * Created by IntelliJ IDEA.
 * User: zzy9v4
 * Date: 7-giu-2006
 * Time: 17.03.05
 * To change this template use File | Settings | File Templates.
 */
public class UserProfileGrantedAuthorityImpl implements GrantedAuthority, Serializable {
    //~ Instance fields ================================================================================================
    private String applicationId;
    private String profileName;
    private String profileProps;
    private Map<String, String> aclQueries;
    private String profileAssociationRule;
    private String profilePerUserProps;
    private String profilePerUserAssociationRule;

    private static final long serialVersionUID = 1307853517026126630L;

//    public UserProfileGrantedAuthorityImpl(String applicationId, String profileName, String profileProps, String profileAssociationRule, String profilePerUserProps, String profilePerUserAssociationRule) {
//    	this(applicationId, profileName, profileProps, profileAssociationRule, profilePerUserProps, profilePerUserAssociationRule, null);
//    }

    public UserProfileGrantedAuthorityImpl(String applicationId, String profileName, String profileProps, String profileAssociationRule, String profilePerUserProps, String profilePerUserAssociationRule, String aclQueries) {
        this.applicationId = applicationId;
        this.profileName = profileName;
        this.profileProps = StringUtils.convertToProperties(profileProps);
        this.profileAssociationRule = profileAssociationRule;
        this.profilePerUserProps = StringUtils.convertToProperties(profilePerUserProps);
        this.profilePerUserAssociationRule = profilePerUserAssociationRule;
        this.aclQueries = StringUtils.convertToMap(aclQueries);
    }

    public String getAclQueryText(String queryId) {
    	return aclQueries.get(queryId);
    }
    
    public UserProfileGrantedAuthorityImpl() {
    }

    public String getAuthority() {
        return profileName;
    }

    public void setAuthority(String profileName) {
        this.profileName = profileName;
    }

    public UserProfileGrantedAuthorityImpl getJfAuthority() {
        return this;
    }

    public String getProfileName() {
        return profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getProfileProps() {
        return profileProps;
    }

    public void setProfileProps(String profileProps) {
        this.profileProps = profileProps;
    }

    public String getProfileAssociationRule() {
        return profileAssociationRule;
    }

    public void setProfileAssociationRule(String profileAssociationRule) {
        this.profileAssociationRule = profileAssociationRule;
    }

    public String getProfilePerUserProps() {
        return profilePerUserProps;
    }

    public void setProfilePerUserProps(String profilePerUserProps) {
        this.profilePerUserProps = profilePerUserProps;
    }

    public String getProfilePerUserAssociationRule() {
        return profilePerUserAssociationRule;
    }

    public void setProfilePerUserAssociationRule(String profilePerUserAssociationRule) {
        this.profilePerUserAssociationRule = profilePerUserAssociationRule;
    }

    public String getApplicationId() {
		return applicationId;
	}

	public void setApplicationId(String applicationId) {
		this.applicationId = applicationId;
	}

	public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString()).append(": ");
        sb.append("appId: ").append(this.applicationId).append("; ");
        sb.append("profileName: ").append(this.profileName).append("; ");
        sb.append("profileProps: ").append(this.profileProps).append("; ");
        sb.append("profileAssociationRule: ").append(this.profileAssociationRule).append("; ");
        sb.append("profilePerUserProps: ").append(this.profilePerUserProps).append("; ");
        sb.append("profilePerUserAssociationRule: ").append(this.profilePerUserAssociationRule).append("; ");

        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        final UserProfileGrantedAuthorityImpl that = (UserProfileGrantedAuthorityImpl) o;

        if (profileName != null ? !profileName.equals(that.profileName) : that.profileName != null) return false;

        return true;
    }

    public int hashCode() {
        return (profileName != null ? profileName.hashCode() : 0);
    }
}
