package it.mice.voila.runtime.security;

import java.util.Collection;
import java.util.Iterator;

import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

/**
 * Created by IntelliJ IDEA.
 * User: zzy9v4
 * Date: 1-giu-2006
 * Time: 15.27.14
 * To change this template use File | Settings | File Templates.
 */
public class UserManager {
    public static String getUserName() {
    	if (SecurityContextHolder.getContext().getAuthentication() != null) {
            Object user = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            if (user instanceof UserDetails) {
                return ((UserDetails) user).getUsername();
            } else {
                return user.toString();
            }
    	} else {
    		return null;
    	}
    }

    public static String getAuthoritiesForInfoBar() {
        Collection<? extends GrantedAuthority> grantedAuthorities = SecurityContextHolder.getContext().getAuthentication().getAuthorities();
        String out = "";
        String prefix = "";
        for (Iterator<? extends GrantedAuthority> iterator = grantedAuthorities.iterator(); iterator.hasNext();) {
			GrantedAuthority grantedAuthority = iterator.next();
            out += prefix + grantedAuthority.getAuthority();
            prefix = ">";
		}
        return out;
    }
}
