package it.mice.voila.runtime.security;


import it.mice.voila.runtime.util.StringUtils;

import java.io.Serializable;


/**
 * Created by IntelliJ IDEA.
 * User: zzy9v4
 * Date: 7-giu-2006
 * Time: 17.29.40
 * To change this template use File | Settings | File Templates.
 */
public class OperationPerProfileConfigAttribute implements Serializable {
    public static final String ROLE_PREFIX = "ROLE_"; 
    private String applicationId;
    private String profileName;
    private String operationProps;
    private String authorizationRule;
    private String authorizationRuleRender;
    private String msgKey;
    private String msgText;

    public OperationPerProfileConfigAttribute(String profileName, String operationProps, String authorizationRule, String msgKey, String msgText) {
        this.profileName = profileName;
        this.operationProps = StringUtils.convertToProperties(operationProps);
        this.authorizationRule = authorizationRule;
        this.msgKey = msgKey;
        this.msgText = msgText;
    }

    public String getApplicationId() {
		return applicationId;
	}

	public void setApplicationId(String applicationId) {
		this.applicationId = applicationId;
	}

	public String getProfileName() {
        return profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getOperationProps() {
        return operationProps;
    }

    public void setOperationProps(String operationProps) {
        this.operationProps = operationProps;
    }

    public String getAuthorizationRule() {
        return authorizationRule;
    }

    public void setAuthorizationRule(String authorizationRule) {
        this.authorizationRule = authorizationRule;
    }

    /**
	 * @return the authorizationRuleRender
	 */
	public String getAuthorizationRuleRender() {
		return authorizationRuleRender;
	}

	/**
	 * @param authorizationRuleRender the authorizationRuleRender to set
	 */
	public void setAuthorizationRuleRender(String authorizationRuleRender) {
		this.authorizationRuleRender = authorizationRuleRender;
	}

	public String getMsgKey() {
        return msgKey;
    }

    public void setMsgKey(String msgKey) {
        this.msgKey = msgKey;
    }

    public String getMsgText() {
        return msgText;
    }

    public void setMsgText(String msgText) {
        this.msgText = msgText;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString()).append(": ");
        sb.append("appId: ").append(this.applicationId).append("; ");
        sb.append("profileName: ").append(this.profileName).append("; ");
        sb.append("operationProps: ").append(this.operationProps).append("; ");
        sb.append("authorizationRule: ").append(this.authorizationRule).append("; ");
        sb.append("msgKey: ").append(this.msgKey).append("; ");
        sb.append("msgText: ").append(this.msgText).append("; ");

        return sb.toString();
    }

	public boolean isSameProfile(UserProfileGrantedAuthorityImpl jfAuthority) {
		return getApplicationId().equals(jfAuthority.getApplicationId()) && getProfileName().equals(jfAuthority.getProfileName());
	}
}
