/* Copyright 2004, 2005, 2006 Acegi Technology Pty Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package it.mice.voila.runtime.security;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class ApplicationHolder implements InitializingBean {
    protected static Log logger = LogFactory.getLog(ApplicationHolder.class);

    //~ Instance fields ================================================================================================
    private String applicationId = "";
    private String applicationProps;
    private String profileAssociationRule;
    private String authorizationRule;
    private String authorizationRuleRender;

    //~ Constructors ===================================================================================================
    public ApplicationHolder() {
    }

    //~ Methods ========================================================================================================
    public String getApplicationId() {
        return applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationProps() {
        return applicationProps;
    }

    public void setApplicationProps(String applicationProps) {
        this.applicationProps = applicationProps;
    }

    public String getProfileAssociationRule() {
        return profileAssociationRule;
    }

    public void setProfileAssociationRule(String profileAssociationRule) {
        this.profileAssociationRule = profileAssociationRule;
    }

    public String getAuthorizationRule() {
        return authorizationRule;
    }

    public void setAuthorizationRule(String authorizationRule) {
        this.authorizationRule = authorizationRule;
    }

	/**
	 * @return the authorizationRuleRender
	 */
	public String getAuthorizationRuleRender() {
		return authorizationRuleRender;
	}

	/**
	 * @param authorizationRuleRender the authorizationRuleRender to set
	 */
	public void setAuthorizationRuleRender(String authorizationRuleRender) {
		this.authorizationRuleRender = authorizationRuleRender;
	}

	public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.DEFAULT_STYLE);
    }
    /**
     * Invoked by a BeanFactory after it has set all bean properties supplied
     * (and satisfied BeanFactoryAware and ApplicationContextAware).
     * <p>This method allows the bean instance to perform initialization only
     * possible when all bean properties have been set and to throw an
     * exception in the event of misconfiguration.
     *
     * @throws RuntimeException in the event of misconfiguration (such
     *                   as failure to set an essential property) or if initialization fails.
     */
    public abstract void afterPropertiesSet();
}

