/*
 * Decompiled with CFR 0.152.
 */
package it.mice.voila.runtime.security;

import it.mice.voila.runtime.security.UserDetailImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public class SecurityUtils {
    public static String defaultUserId = "ANONYMOUS";
    private static UserDetails defaultUserDetails = null;
    public static final Collection<GrantedAuthority> EMPTY_AUTHORITY_LIST = new ArrayList<GrantedAuthority>();
    public static final Set<String> EMPTY_ACL = new HashSet<String>();

    public void setDefaultUserId(String defaultUserId) {
        SecurityUtils.defaultUserId = defaultUserId;
    }

    public static String getCurrentUserId() {
        if (SecurityContextHolder.getContext().getAuthentication() != null) {
            try {
                return ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername();
            }
            catch (Exception e) {
                return defaultUserId;
            }
        }
        return defaultUserId;
    }

    public static boolean isAuthenticatedUser() {
        return !SecurityUtils.getCurrentUserId().equals(defaultUserId);
    }

    public static boolean isUserInRoles(String ... profiles) {
        for (GrantedAuthority grantedAuthority : SecurityUtils.getCurrentUserDetail().getAuthorities()) {
            String auth = grantedAuthority.getAuthority();
            for (int j = 0; j < profiles.length; ++j) {
                if (!auth.equalsIgnoreCase(profiles[j])) continue;
                return true;
            }
        }
        return false;
    }

    public static UserDetails getCurrentUserDetail() {
        if (SecurityContextHolder.getContext().getAuthentication() != null && SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof UserDetails) {
            return (UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        }
        if (SecurityContextHolder.getContext().getAuthentication() != null && SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof String) {
            Collection auths = SecurityContextHolder.getContext().getAuthentication().getAuthorities();
            return new UserDetailImpl(SecurityContextHolder.getContext().getAuthentication().getPrincipal().toString(), "", true, true, true, true, auths, null);
        }
        if (defaultUserDetails == null) {
            defaultUserDetails = new UserDetailImpl(defaultUserId, "", true, true, true, true, EMPTY_AUTHORITY_LIST, null);
        }
        return defaultUserDetails;
    }

    public static String getNominativoCurrentUser() {
        UserDetailImpl userDetail = (UserDetailImpl)SecurityUtils.getCurrentUserDetail();
        StringBuffer result = new StringBuffer();
        if (userDetail.getFirstName() != null) {
            result.append(userDetail.getFirstName());
        }
        if (userDetail.getLastName() != null) {
            result.append(" ").append(userDetail.getLastName());
        }
        if (result.length() == 0) {
            result.append(userDetail.getUsername());
        }
        return result.toString();
    }

    public static Set<String> extractAclQueries(String entityId, String queryId) {
        UserDetails currentUser = SecurityUtils.getCurrentUserDetail();
        if (!(currentUser instanceof UserDetailImpl)) {
            return EMPTY_ACL;
        }
        UserDetailImpl userDetailImpl = (UserDetailImpl)currentUser;
        Set<String> queries = userDetailImpl.getAclQueryText(entityId + "." + queryId);
        queries.addAll(userDetailImpl.getAclQueryText(entityId));
        queries.addAll(userDetailImpl.getAclQueryText("*"));
        if (queries.contains("1=1") || queries.contains("true")) {
            return EMPTY_ACL;
        }
        return queries;
    }
}

