/*
 * Decompiled with CFR 0.152.
 */
package it.infuse.jenkins.usemango.util;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.ObjectParser;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import it.infuse.jenkins.usemango.exception.UseMangoException;
import it.infuse.jenkins.usemango.model.Project;
import it.infuse.jenkins.usemango.model.TestIndexParams;
import it.infuse.jenkins.usemango.model.TestIndexResponse;
import it.infuse.jenkins.usemango.model.UmUser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class APIUtils {
    static HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    static JsonFactory JSON_FACTORY = new JacksonFactory();
    static final String API_VERSION = "/v2.1";
    static final String ENDPOINT_AUTHENTICATE = "/v2.1/authenticate";
    static final String ENDPOINT_REFRESH_TOKEN = "/v2.1/authenticate/refresh";
    static final String ENDPOINT_PROJECTS = "/v2.1/projects";
    static final String ENDPOINT_TESTINDEX = "/v2.1/projects/%s/testindex";
    static final String ENDPOINT_USERS = "/v2.1/users";
    static final String ENDPOINT_PROJECT_TAGS = "/v2.1/projects/%s/testtags";

    public static String[] getAuthenticationTokens(String useMangoUrl, String email, String password) throws UseMangoException, IOException {
        HttpRequestFactory requestFactory = HTTP_TRANSPORT.createRequestFactory();
        GenericUrl url = new GenericUrl(useMangoUrl);
        url.setRawPath(ENDPOINT_AUTHENTICATE);
        GenericData data = new GenericData();
        data.put("UserName", (Object)email);
        data.put("Password", (Object)password);
        JsonHttpContent httpContent = new JsonHttpContent((JsonFactory)new JacksonFactory(), (Object)data);
        HttpRequest request = requestFactory.buildPostRequest(url, (HttpContent)httpContent);
        HttpResponse response = request.execute();
        if (response != null) {
            if (response.getStatusCode() == 200) {
                String responseJson = response.parseAsString();
                JsonObject tokenJson = new JsonParser().parse(responseJson).getAsJsonObject();
                String idToken = tokenJson.get("IdToken").getAsString();
                String refreshToken = tokenJson.get("RefreshToken").getAsString();
                if (idToken != null && refreshToken != null) {
                    String[] tokens = new String[]{idToken, refreshToken};
                    return tokens;
                }
                throw new UseMangoException("No Id token returned from " + useMangoUrl + ENDPOINT_AUTHENTICATE);
            }
            throw new UseMangoException("Invalid response from " + useMangoUrl + ENDPOINT_AUTHENTICATE + " - status code: " + response.getStatusCode());
        }
        throw new UseMangoException("Error retrieving tokens from " + useMangoUrl + ENDPOINT_AUTHENTICATE + " - response is null");
    }

    public static String refreshIdToken(String useMangoUrl, String refreshToken) throws IOException, UseMangoException {
        HttpResponse response;
        block5: {
            HttpRequestFactory requestFactory = HTTP_TRANSPORT.createRequestFactory();
            GenericUrl url = new GenericUrl(useMangoUrl);
            url.setRawPath(ENDPOINT_REFRESH_TOKEN);
            JsonHttpContent httpContent = new JsonHttpContent((JsonFactory)new JacksonFactory(), (Object)refreshToken);
            HttpRequest request = requestFactory.buildPostRequest(url, (HttpContent)httpContent);
            response = null;
            try {
                response = request.execute();
            }
            catch (HttpResponseException e) {
                if (e.getStatusCode() != 401 || e.getStatusMessage() != "Unauthorized") break block5;
                throw new UseMangoException("Expired refresh token");
            }
        }
        if (response != null) {
            if (response.getStatusCode() == 200) {
                String responseJson = response.parseAsString();
                JsonObject tokenJson = new JsonParser().parse(responseJson).getAsJsonObject();
                String idToken = tokenJson.get("IdToken").getAsString();
                if (idToken != null) {
                    return idToken;
                }
                throw new UseMangoException("No Id token returned from " + useMangoUrl + ENDPOINT_REFRESH_TOKEN);
            }
            throw new UseMangoException("Invalid response from " + useMangoUrl + ENDPOINT_REFRESH_TOKEN + " - status code: " + response.getStatusCode());
        }
        throw new UseMangoException("Error retrieving tokens from " + useMangoUrl + ENDPOINT_REFRESH_TOKEN + " - response is null");
    }

    public static TestIndexResponse getTestIndex(String useMangoUrl, TestIndexParams params, String idToken) throws IOException {
        HttpRequestFactory requestFactory = HTTP_TRANSPORT.createRequestFactory(request -> request.setParser((ObjectParser)new JsonObjectParser(JSON_FACTORY)));
        TestIndexResponse response = null;
        do {
            GenericUrl url = new GenericUrl(useMangoUrl);
            url.setRawPath(String.format(ENDPOINT_TESTINDEX, params.getProjectId()));
            url.set("tags", (Object)params.getTags());
            url.set("filter", (Object)params.getTestName());
            url.set("status", (Object)params.getTestStatus());
            url.set("assignee", (Object)params.getAssignedTo());
            if (APIUtils.isAnotherPage(response)) {
                url.set("cursor", (Object)response.getInfo().getNext());
            }
            HttpRequest request2 = requestFactory.buildGetRequest(url);
            request2.setHeaders(APIUtils.getHeadersForServer(idToken));
            if (APIUtils.isAnotherPage(response)) {
                TestIndexResponse tmpResponse = (TestIndexResponse)((Object)request2.execute().parseAs(TestIndexResponse.class));
                response.getItems().addAll(tmpResponse.getItems());
                response.getInfo().setHasNext(tmpResponse.getInfo().isHasNext());
                response.getInfo().setNext(tmpResponse.getInfo().getNext());
                continue;
            }
            response = (TestIndexResponse)((Object)request2.execute().parseAs(TestIndexResponse.class));
        } while (response.getInfo().isHasNext());
        return response;
    }

    public static List<Project> getProjects(String useMangoUrl, String idToken) throws IOException {
        HttpRequestFactory requestFactory = HTTP_TRANSPORT.createRequestFactory(request -> request.setParser((ObjectParser)new JsonObjectParser(JSON_FACTORY)));
        GenericUrl url = new GenericUrl(useMangoUrl);
        url.setRawPath(String.format(ENDPOINT_PROJECTS, new Object[0]));
        HttpRequest request2 = requestFactory.buildGetRequest(url);
        request2.setHeaders(APIUtils.getHeadersForServer(idToken));
        return (ArrayList)request2.execute().parseAs(new TypeToken<ArrayList<Project>>(){}.getType());
    }

    public static List<String> getProjectTags(String useMangoUrl, String idToken, String project) throws IOException {
        HttpRequestFactory requestFactory = HTTP_TRANSPORT.createRequestFactory(request -> request.setParser((ObjectParser)new JsonObjectParser(JSON_FACTORY)));
        GenericUrl url = new GenericUrl(useMangoUrl);
        url.setRawPath(String.format(ENDPOINT_PROJECT_TAGS, project));
        HttpRequest request2 = requestFactory.buildGetRequest(url);
        request2.setHeaders(APIUtils.getHeadersForServer(idToken));
        return (ArrayList)request2.execute().parseAs(new TypeToken<ArrayList<String>>(){}.getType());
    }

    public static List<UmUser> getUsers(String useMangoUrl, String idToken) throws IOException {
        HttpRequestFactory requestFactory = HTTP_TRANSPORT.createRequestFactory(request -> request.setParser((ObjectParser)new JsonObjectParser(JSON_FACTORY)));
        GenericUrl url = new GenericUrl(useMangoUrl);
        url.setRawPath(ENDPOINT_USERS);
        HttpRequest request2 = requestFactory.buildGetRequest(url);
        request2.setHeaders(APIUtils.getHeadersForServer(idToken));
        return (ArrayList)request2.execute().parseAs(new TypeToken<ArrayList<UmUser>>(){}.getType());
    }

    private static boolean isAnotherPage(TestIndexResponse response) {
        return response != null && response.getInfo() != null && response.getInfo().isHasNext();
    }

    private static HttpHeaders getHeadersForServer(String idToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAuthorization("Bearer " + idToken);
        return headers;
    }
}

