/*
 * Decompiled with CFR 0.152.
 */
package it.gilvegliach.android.transparenttexttextview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.TextView;

public class TransparentTextTextView
extends TextView {
    private Bitmap mMaskBitmap;
    private Canvas mMaskCanvas;
    private Paint mPaint;
    private Drawable mBackground;
    private Bitmap mBackgroundBitmap;
    private Canvas mBackgroundCanvas;
    private boolean mSetBoundsOnSizeAvailable;

    public TransparentTextTextView(Context context) {
        super(context);
        this.init();
    }

    public TransparentTextTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.mPaint = new Paint();
        this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
        super.setTextColor(-16777216);
        super.setBackgroundDrawable((Drawable)new ColorDrawable(0));
    }

    @Deprecated
    public void setBackgroundDrawable(Drawable bg) {
        this.mBackground = bg;
        int w = this.getWidth();
        int h = this.getHeight();
        if (w == 0 || h == 0) {
            this.mSetBoundsOnSizeAvailable = true;
            return;
        }
        this.mBackground.setBounds(0, 0, w, h);
        this.invalidate();
    }

    public void setBackgroundColor(int color) {
        this.setBackgroundDrawable((Drawable)new ColorDrawable(color));
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mBackgroundBitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mBackgroundCanvas = new Canvas(this.mBackgroundBitmap);
        this.mMaskBitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mMaskCanvas = new Canvas(this.mMaskBitmap);
        if (this.mSetBoundsOnSizeAvailable) {
            this.mBackground.setBounds(0, 0, w, h);
            this.mSetBoundsOnSizeAvailable = false;
        }
    }

    protected void onDraw(Canvas canvas) {
        this.drawMask();
        this.drawBackground();
        canvas.drawBitmap(this.mBackgroundBitmap, 0.0f, 0.0f, null);
    }

    private void drawBackground() {
        this.mBackground.draw(this.mBackgroundCanvas);
        this.mBackgroundCanvas.drawBitmap(this.mMaskBitmap, 0.0f, 0.0f, this.mPaint);
    }

    @SuppressLint(value={"WrongCall"})
    private void drawMask() {
        this.mMaskCanvas.drawColor(-16777216, PorterDuff.Mode.CLEAR);
        super.onDraw(this.mMaskCanvas);
    }
}

