/*
 * Decompiled with CFR 0.152.
 */
package it.federicoboschini.resourcefileprovider;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.net.Uri;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.app.ShareCompat;
import android.support.v4.content.FileProvider;
import android.util.Log;
import it.federicoboschini.androidresourcefileprovider.R;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.IllegalFormatException;

public class ResourceFileProvider {
    private static final String TAG = "ResourceFileProvider";
    private static final String ANDROID_RES_URI = "android.resource://%1$s/%2$s";
    public static final String FOLDER_RAW = "raw";
    public static final String FOLDER_DRAWABLE = "drawable";
    public static final String FOLDER_MIPMAP = "mipmap";
    public static final String FOLDER_ASSETS = "assets";
    public static final String TYPE_AUDIO = "audio/*";
    public static final String TYPE_IMAGE = "image/*";
    public static final String TYPE_VIDEO = "video/*";
    public static final String TYPE_PDF = "application/pdf";
    private final Activity activity;
    private final String directory;
    private final String fileName;
    private final String fileExtension;
    private final String fileType;

    private ResourceFileProvider(@NonNull Activity activity, @NonNull String directory, @NonNull String fileName, @NonNull String fileExtension, @NonNull String fileType) {
        this.activity = activity;
        this.directory = directory;
        this.fileName = fileName;
        this.fileExtension = fileExtension;
        this.fileType = fileType;
    }

    public void shareFile() throws FileNotFoundException {
        int resId = this.activity.getResources().getIdentifier(this.fileName, this.directory, this.activity.getPackageName());
        InputStream inputStream = null;
        if (this.isValidResId(resId)) {
            switch (this.directory) {
                case "raw": {
                    inputStream = this.activity.getResources().openRawResource(resId);
                    break;
                }
                case "mipmap": 
                case "drawable": {
                    Uri fileUri;
                    try {
                        fileUri = Uri.parse((String)String.format(ANDROID_RES_URI, this.activity.getPackageName(), resId));
                    }
                    catch (IllegalFormatException e) {
                        throw new FileNotFoundException();
                    }
                    if (fileUri == null) break;
                    inputStream = this.activity.getContentResolver().openInputStream(fileUri);
                    break;
                }
                default: {
                    inputStream = this.activity.getResources().openRawResource(resId);
                }
            }
            this.prepareAndShare(inputStream);
        } else if (this.directory.equals(FOLDER_ASSETS)) {
            AssetManager assetManager = this.activity.getAssets();
            try {
                inputStream = assetManager.open(this.fileName.concat(".").concat(this.fileExtension));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new FileNotFoundException();
            }
            this.prepareAndShare(inputStream);
        } else {
            throw new FileNotFoundException();
        }
    }

    private void prepareAndShare(InputStream inputStream) {
        try {
            byte[] buff = new byte[1024];
            FileOutputStream outputStream = this.activity.openFileOutput(this.fileName.concat(".").concat(this.fileExtension), 0);
            if (inputStream != null) {
                int len;
                while ((len = inputStream.read(buff)) > 0) {
                    outputStream.write(buff, 0, len);
                }
                inputStream.close();
            }
            outputStream.close();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)e.getLocalizedMessage());
        }
        Uri uri = FileProvider.getUriForFile((Context)this.activity, (String)this.activity.getResources().getString(R.string.rfp_provider_authority), (File)new File(this.activity.getFilesDir(), this.fileName.concat(".").concat(this.fileExtension)));
        Intent intent = ShareCompat.IntentBuilder.from((Activity)this.activity).getIntent();
        intent.setAction("android.intent.action.SEND");
        intent.setType(this.fileType);
        intent.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
        intent.setFlags(1);
        if (intent.resolveActivity(this.activity.getPackageManager()) != null) {
            this.activity.startActivity(intent);
        }
    }

    private boolean isValidResId(int resId) {
        return resId != 0;
    }

    public static class Builder {
        private final Activity activity;
        private String directory;
        private String fileName;
        private String fileExtension;
        private String fileType;

        private Builder(Activity activity) {
            this.activity = activity;
        }

        public static Builder from(@NonNull Activity activity) {
            return new Builder(activity);
        }

        public Builder setDirectory(@NonNull String directory) {
            this.directory = directory;
            return this;
        }

        public Builder setFileName(@NonNull String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder setFileExtension(@NonNull String fileExtension) {
            this.fileExtension = fileExtension;
            return this;
        }

        public Builder setFileType(@NonNull String fileType) {
            this.fileType = fileType;
            return this;
        }

        public ResourceFileProvider build() {
            return new ResourceFileProvider(this.activity, this.directory, this.fileName, this.fileExtension, this.fileType);
        }
    }
}

