/*
 * Decompiled with CFR 0.152.
 */
package it.fattureincloud.sdk.model;

import com.google.gson.annotations.SerializedName;
import it.fattureincloud.sdk.model.PaymentAccount;
import it.fattureincloud.sdk.model.PaymentMethodDetails;
import it.fattureincloud.sdk.model.PaymentMethodType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

public class PaymentMethod
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private Integer id;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private PaymentMethodType type = PaymentMethodType.STANDARD;
    public static final String SERIALIZED_NAME_IS_DEFAULT = "is_default";
    @SerializedName(value="is_default")
    private Boolean isDefault;
    public static final String SERIALIZED_NAME_DEFAULT_PAYMENT_ACCOUNT = "default_payment_account";
    @SerializedName(value="default_payment_account")
    private PaymentAccount defaultPaymentAccount;
    public static final String SERIALIZED_NAME_DETAILS = "details";
    @SerializedName(value="details")
    private List<PaymentMethodDetails> details;
    public static final String SERIALIZED_NAME_BANK_IBAN = "bank_iban";
    @SerializedName(value="bank_iban")
    private String bankIban;
    public static final String SERIALIZED_NAME_BANK_NAME = "bank_name";
    @SerializedName(value="bank_name")
    private String bankName;
    public static final String SERIALIZED_NAME_BANK_BENEFICIARY = "bank_beneficiary";
    @SerializedName(value="bank_beneficiary")
    private String bankBeneficiary;
    public static final String SERIALIZED_NAME_EI_PAYMENT_METHOD = "ei_payment_method";
    @SerializedName(value="ei_payment_method")
    private String eiPaymentMethod;

    public PaymentMethod id(Integer id) {
        this.id = id;
        return this;
    }

    @Nullable
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public PaymentMethod name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PaymentMethod type(PaymentMethodType type) {
        this.type = type;
        return this;
    }

    @Nullable
    public PaymentMethodType getType() {
        return this.type;
    }

    public void setType(PaymentMethodType type) {
        this.type = type;
    }

    public PaymentMethod isDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    @Nullable
    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public PaymentMethod defaultPaymentAccount(PaymentAccount defaultPaymentAccount) {
        this.defaultPaymentAccount = defaultPaymentAccount;
        return this;
    }

    @Nullable
    public PaymentAccount getDefaultPaymentAccount() {
        return this.defaultPaymentAccount;
    }

    public void setDefaultPaymentAccount(PaymentAccount defaultPaymentAccount) {
        this.defaultPaymentAccount = defaultPaymentAccount;
    }

    public PaymentMethod details(List<PaymentMethodDetails> details) {
        this.details = details;
        return this;
    }

    public PaymentMethod addDetailsItem(PaymentMethodDetails detailsItem) {
        if (this.details == null) {
            this.details = new ArrayList<PaymentMethodDetails>();
        }
        this.details.add(detailsItem);
        return this;
    }

    @Nullable
    public List<PaymentMethodDetails> getDetails() {
        return this.details;
    }

    public void setDetails(List<PaymentMethodDetails> details) {
        this.details = details;
    }

    public PaymentMethod bankIban(String bankIban) {
        this.bankIban = bankIban;
        return this;
    }

    @Nullable
    public String getBankIban() {
        return this.bankIban;
    }

    public void setBankIban(String bankIban) {
        this.bankIban = bankIban;
    }

    public PaymentMethod bankName(String bankName) {
        this.bankName = bankName;
        return this;
    }

    @Nullable
    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public PaymentMethod bankBeneficiary(String bankBeneficiary) {
        this.bankBeneficiary = bankBeneficiary;
        return this;
    }

    @Nullable
    public String getBankBeneficiary() {
        return this.bankBeneficiary;
    }

    public void setBankBeneficiary(String bankBeneficiary) {
        this.bankBeneficiary = bankBeneficiary;
    }

    public PaymentMethod eiPaymentMethod(String eiPaymentMethod) {
        this.eiPaymentMethod = eiPaymentMethod;
        return this;
    }

    @Nullable
    public String getEiPaymentMethod() {
        return this.eiPaymentMethod;
    }

    public void setEiPaymentMethod(String eiPaymentMethod) {
        this.eiPaymentMethod = eiPaymentMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentMethod paymentMethod = (PaymentMethod)o;
        return Objects.equals(this.id, paymentMethod.id) && Objects.equals(this.name, paymentMethod.name) && Objects.equals((Object)this.type, (Object)paymentMethod.type) && Objects.equals(this.isDefault, paymentMethod.isDefault) && Objects.equals(this.defaultPaymentAccount, paymentMethod.defaultPaymentAccount) && Objects.equals(this.details, paymentMethod.details) && Objects.equals(this.bankIban, paymentMethod.bankIban) && Objects.equals(this.bankName, paymentMethod.bankName) && Objects.equals(this.bankBeneficiary, paymentMethod.bankBeneficiary) && Objects.equals(this.eiPaymentMethod, paymentMethod.eiPaymentMethod);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.type, this.isDefault, this.defaultPaymentAccount, this.details, this.bankIban, this.bankName, this.bankBeneficiary, this.eiPaymentMethod});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentMethod {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    isDefault: ").append(this.toIndentedString(this.isDefault)).append("\n");
        sb.append("    defaultPaymentAccount: ").append(this.toIndentedString(this.defaultPaymentAccount)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("    bankIban: ").append(this.toIndentedString(this.bankIban)).append("\n");
        sb.append("    bankName: ").append(this.toIndentedString(this.bankName)).append("\n");
        sb.append("    bankBeneficiary: ").append(this.toIndentedString(this.bankBeneficiary)).append("\n");
        sb.append("    eiPaymentMethod: ").append(this.toIndentedString(this.eiPaymentMethod)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

