/*
 * Decompiled with CFR 0.152.
 */
package it.fattureincloud.sdk.filter;

import it.fattureincloud.sdk.filter.Expression;
import it.fattureincloud.sdk.filter.Operator;
import it.fattureincloud.sdk.filter.Value;
import java.util.Objects;
import java.util.Optional;

public class Condition<T>
implements Expression {
    private String field;
    private Operator op;
    private Value<T> value;

    public Condition(String field, Operator op, T value) {
        this.field = field;
        this.op = op;
        this.value = value == null ? null : new Value<T>(value);
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Operator getOp() {
        return this.op;
    }

    public void setOp(Operator op) {
        this.op = op;
    }

    public Optional<Value<T>> getValue() {
        if (this.value == null) {
            return Optional.empty();
        }
        return Optional.of(this.value);
    }

    public void setValue(Value<T> value) {
        this.value = value;
    }

    public void setValue(T value) {
        this.value = value == null ? null : new Value<T>(value);
    }

    @Override
    public String buildQuery() {
        return String.format("%s %s %s", this.field, this.op.getSymbol(), this.printValue());
    }

    private String printValue() {
        if (this.value == null) {
            return "null";
        }
        return this.value.printValue();
    }

    public String toString() {
        return this.buildQuery();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Condition condition = (Condition)o;
        return Objects.equals(this.field, condition.field) && this.op == condition.op && Objects.equals(this.value, condition.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.op, this.value});
    }
}

