/*
 * Decompiled with CFR 0.152.
 */
package it.fattureincloud.sdk.api;

import com.google.gson.reflect.TypeToken;
import it.fattureincloud.sdk.ApiCallback;
import it.fattureincloud.sdk.ApiClient;
import it.fattureincloud.sdk.ApiException;
import it.fattureincloud.sdk.ApiResponse;
import it.fattureincloud.sdk.Configuration;
import it.fattureincloud.sdk.Pair;
import it.fattureincloud.sdk.model.CreateF24Request;
import it.fattureincloud.sdk.model.CreateF24Response;
import it.fattureincloud.sdk.model.GetF24Response;
import it.fattureincloud.sdk.model.ListF24Response;
import it.fattureincloud.sdk.model.ModifyF24Request;
import it.fattureincloud.sdk.model.ModifyF24Response;
import it.fattureincloud.sdk.model.UploadF24AttachmentResponse;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class TaxesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public TaxesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TaxesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createF24Call(Integer companyId, CreateF24Request createF24Request, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateF24Request localVarPostBody = createF24Request;
        String localVarPath = "/c/{company_id}/taxes".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createF24ValidateBeforeCall(Integer companyId, CreateF24Request createF24Request, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling createF24(Async)");
        }
        return this.createF24Call(companyId, createF24Request, _callback);
    }

    public CreateF24Response createF24(Integer companyId, CreateF24Request createF24Request) throws ApiException {
        ApiResponse<CreateF24Response> localVarResp = this.createF24WithHttpInfo(companyId, createF24Request);
        return localVarResp.getData();
    }

    public ApiResponse<CreateF24Response> createF24WithHttpInfo(Integer companyId, CreateF24Request createF24Request) throws ApiException {
        Call localVarCall = this.createF24ValidateBeforeCall(companyId, createF24Request, null);
        Type localVarReturnType = new TypeToken<CreateF24Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createF24Async(Integer companyId, CreateF24Request createF24Request, ApiCallback<CreateF24Response> _callback) throws ApiException {
        Call localVarCall = this.createF24ValidateBeforeCall(companyId, createF24Request, _callback);
        Type localVarReturnType = new TypeToken<CreateF24Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteF24Call(Integer companyId, Integer documentId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/taxes/{document_id}".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{document_id}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteF24ValidateBeforeCall(Integer companyId, Integer documentId, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling deleteF24(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling deleteF24(Async)");
        }
        return this.deleteF24Call(companyId, documentId, _callback);
    }

    public void deleteF24(Integer companyId, Integer documentId) throws ApiException {
        this.deleteF24WithHttpInfo(companyId, documentId);
    }

    public ApiResponse<Void> deleteF24WithHttpInfo(Integer companyId, Integer documentId) throws ApiException {
        Call localVarCall = this.deleteF24ValidateBeforeCall(companyId, documentId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteF24Async(Integer companyId, Integer documentId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteF24ValidateBeforeCall(companyId, documentId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteF24AttachmentCall(Integer companyId, Integer documentId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/taxes/{document_id}/attachment".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{document_id}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteF24AttachmentValidateBeforeCall(Integer companyId, Integer documentId, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling deleteF24Attachment(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling deleteF24Attachment(Async)");
        }
        return this.deleteF24AttachmentCall(companyId, documentId, _callback);
    }

    public void deleteF24Attachment(Integer companyId, Integer documentId) throws ApiException {
        this.deleteF24AttachmentWithHttpInfo(companyId, documentId);
    }

    public ApiResponse<Void> deleteF24AttachmentWithHttpInfo(Integer companyId, Integer documentId) throws ApiException {
        Call localVarCall = this.deleteF24AttachmentValidateBeforeCall(companyId, documentId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteF24AttachmentAsync(Integer companyId, Integer documentId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteF24AttachmentValidateBeforeCall(companyId, documentId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getF24Call(Integer companyId, Integer documentId, String fields, String fieldset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/taxes/{document_id}".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{document_id}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields", fields));
        }
        if (fieldset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldset", fieldset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getF24ValidateBeforeCall(Integer companyId, Integer documentId, String fields, String fieldset, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling getF24(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getF24(Async)");
        }
        return this.getF24Call(companyId, documentId, fields, fieldset, _callback);
    }

    public GetF24Response getF24(Integer companyId, Integer documentId, String fields, String fieldset) throws ApiException {
        ApiResponse<GetF24Response> localVarResp = this.getF24WithHttpInfo(companyId, documentId, fields, fieldset);
        return localVarResp.getData();
    }

    public ApiResponse<GetF24Response> getF24WithHttpInfo(Integer companyId, Integer documentId, String fields, String fieldset) throws ApiException {
        Call localVarCall = this.getF24ValidateBeforeCall(companyId, documentId, fields, fieldset, null);
        Type localVarReturnType = new TypeToken<GetF24Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getF24Async(Integer companyId, Integer documentId, String fields, String fieldset, ApiCallback<GetF24Response> _callback) throws ApiException {
        Call localVarCall = this.getF24ValidateBeforeCall(companyId, documentId, fields, fieldset, _callback);
        Type localVarReturnType = new TypeToken<GetF24Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listF24Call(Integer companyId, String fields, String fieldset, String sort, Integer page, Integer perPage, String q, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/taxes".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields", fields));
        }
        if (fieldset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldset", fieldset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("per_page", perPage));
        }
        if (q != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("q", q));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listF24ValidateBeforeCall(Integer companyId, String fields, String fieldset, String sort, Integer page, Integer perPage, String q, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling listF24(Async)");
        }
        return this.listF24Call(companyId, fields, fieldset, sort, page, perPage, q, _callback);
    }

    public ListF24Response listF24(Integer companyId, String fields, String fieldset, String sort, Integer page, Integer perPage, String q) throws ApiException {
        ApiResponse<ListF24Response> localVarResp = this.listF24WithHttpInfo(companyId, fields, fieldset, sort, page, perPage, q);
        return localVarResp.getData();
    }

    public ApiResponse<ListF24Response> listF24WithHttpInfo(Integer companyId, String fields, String fieldset, String sort, Integer page, Integer perPage, String q) throws ApiException {
        Call localVarCall = this.listF24ValidateBeforeCall(companyId, fields, fieldset, sort, page, perPage, q, null);
        Type localVarReturnType = new TypeToken<ListF24Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listF24Async(Integer companyId, String fields, String fieldset, String sort, Integer page, Integer perPage, String q, ApiCallback<ListF24Response> _callback) throws ApiException {
        Call localVarCall = this.listF24ValidateBeforeCall(companyId, fields, fieldset, sort, page, perPage, q, _callback);
        Type localVarReturnType = new TypeToken<ListF24Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call modifyF24Call(Integer companyId, Integer documentId, ModifyF24Request modifyF24Request, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ModifyF24Request localVarPostBody = modifyF24Request;
        String localVarPath = "/c/{company_id}/taxes/{document_id}".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{document_id}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call modifyF24ValidateBeforeCall(Integer companyId, Integer documentId, ModifyF24Request modifyF24Request, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling modifyF24(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling modifyF24(Async)");
        }
        return this.modifyF24Call(companyId, documentId, modifyF24Request, _callback);
    }

    public ModifyF24Response modifyF24(Integer companyId, Integer documentId, ModifyF24Request modifyF24Request) throws ApiException {
        ApiResponse<ModifyF24Response> localVarResp = this.modifyF24WithHttpInfo(companyId, documentId, modifyF24Request);
        return localVarResp.getData();
    }

    public ApiResponse<ModifyF24Response> modifyF24WithHttpInfo(Integer companyId, Integer documentId, ModifyF24Request modifyF24Request) throws ApiException {
        Call localVarCall = this.modifyF24ValidateBeforeCall(companyId, documentId, modifyF24Request, null);
        Type localVarReturnType = new TypeToken<ModifyF24Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call modifyF24Async(Integer companyId, Integer documentId, ModifyF24Request modifyF24Request, ApiCallback<ModifyF24Response> _callback) throws ApiException {
        Call localVarCall = this.modifyF24ValidateBeforeCall(companyId, documentId, modifyF24Request, _callback);
        Type localVarReturnType = new TypeToken<ModifyF24Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call uploadF24AttachmentCall(Integer companyId, String filename, File attachment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/taxes/attachment".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filename != null) {
            localVarFormParams.put("filename", filename);
        }
        if (attachment != null) {
            localVarFormParams.put("attachment", attachment);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadF24AttachmentValidateBeforeCall(Integer companyId, String filename, File attachment, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling uploadF24Attachment(Async)");
        }
        return this.uploadF24AttachmentCall(companyId, filename, attachment, _callback);
    }

    public UploadF24AttachmentResponse uploadF24Attachment(Integer companyId, String filename, File attachment) throws ApiException {
        ApiResponse<UploadF24AttachmentResponse> localVarResp = this.uploadF24AttachmentWithHttpInfo(companyId, filename, attachment);
        return localVarResp.getData();
    }

    public ApiResponse<UploadF24AttachmentResponse> uploadF24AttachmentWithHttpInfo(Integer companyId, String filename, File attachment) throws ApiException {
        Call localVarCall = this.uploadF24AttachmentValidateBeforeCall(companyId, filename, attachment, null);
        Type localVarReturnType = new TypeToken<UploadF24AttachmentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call uploadF24AttachmentAsync(Integer companyId, String filename, File attachment, ApiCallback<UploadF24AttachmentResponse> _callback) throws ApiException {
        Call localVarCall = this.uploadF24AttachmentValidateBeforeCall(companyId, filename, attachment, _callback);
        Type localVarReturnType = new TypeToken<UploadF24AttachmentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

