/*
 * Decompiled with CFR 0.152.
 */
package it.fattureincloud.sdk.api;

import com.google.gson.reflect.TypeToken;
import it.fattureincloud.sdk.ApiCallback;
import it.fattureincloud.sdk.ApiClient;
import it.fattureincloud.sdk.ApiException;
import it.fattureincloud.sdk.ApiResponse;
import it.fattureincloud.sdk.Configuration;
import it.fattureincloud.sdk.Pair;
import it.fattureincloud.sdk.model.CreateCashbookEntryRequest;
import it.fattureincloud.sdk.model.CreateCashbookEntryResponse;
import it.fattureincloud.sdk.model.GetCashbookEntryResponse;
import it.fattureincloud.sdk.model.ListCashbookEntriesResponse;
import it.fattureincloud.sdk.model.ModifyCashbookEntryRequest;
import it.fattureincloud.sdk.model.ModifyCashbookEntryResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class CashbookApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CashbookApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CashbookApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createCashbookEntryCall(Integer companyId, CreateCashbookEntryRequest createCashbookEntryRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateCashbookEntryRequest localVarPostBody = createCashbookEntryRequest;
        String localVarPath = "/c/{company_id}/cashbook".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createCashbookEntryValidateBeforeCall(Integer companyId, CreateCashbookEntryRequest createCashbookEntryRequest, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling createCashbookEntry(Async)");
        }
        return this.createCashbookEntryCall(companyId, createCashbookEntryRequest, _callback);
    }

    public CreateCashbookEntryResponse createCashbookEntry(Integer companyId, CreateCashbookEntryRequest createCashbookEntryRequest) throws ApiException {
        ApiResponse<CreateCashbookEntryResponse> localVarResp = this.createCashbookEntryWithHttpInfo(companyId, createCashbookEntryRequest);
        return localVarResp.getData();
    }

    public ApiResponse<CreateCashbookEntryResponse> createCashbookEntryWithHttpInfo(Integer companyId, CreateCashbookEntryRequest createCashbookEntryRequest) throws ApiException {
        Call localVarCall = this.createCashbookEntryValidateBeforeCall(companyId, createCashbookEntryRequest, null);
        Type localVarReturnType = new TypeToken<CreateCashbookEntryResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createCashbookEntryAsync(Integer companyId, CreateCashbookEntryRequest createCashbookEntryRequest, ApiCallback<CreateCashbookEntryResponse> _callback) throws ApiException {
        Call localVarCall = this.createCashbookEntryValidateBeforeCall(companyId, createCashbookEntryRequest, _callback);
        Type localVarReturnType = new TypeToken<CreateCashbookEntryResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCashbookEntryCall(Integer companyId, String documentId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/cashbook/{document_id}".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{document_id}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCashbookEntryValidateBeforeCall(Integer companyId, String documentId, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling deleteCashbookEntry(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling deleteCashbookEntry(Async)");
        }
        return this.deleteCashbookEntryCall(companyId, documentId, _callback);
    }

    public void deleteCashbookEntry(Integer companyId, String documentId) throws ApiException {
        this.deleteCashbookEntryWithHttpInfo(companyId, documentId);
    }

    public ApiResponse<Void> deleteCashbookEntryWithHttpInfo(Integer companyId, String documentId) throws ApiException {
        Call localVarCall = this.deleteCashbookEntryValidateBeforeCall(companyId, documentId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteCashbookEntryAsync(Integer companyId, String documentId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteCashbookEntryValidateBeforeCall(companyId, documentId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getCashbookEntryCall(Integer companyId, String documentId, String fields, String fieldset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/cashbook/{document_id}".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{document_id}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields", fields));
        }
        if (fieldset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldset", fieldset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCashbookEntryValidateBeforeCall(Integer companyId, String documentId, String fields, String fieldset, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling getCashbookEntry(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getCashbookEntry(Async)");
        }
        return this.getCashbookEntryCall(companyId, documentId, fields, fieldset, _callback);
    }

    public GetCashbookEntryResponse getCashbookEntry(Integer companyId, String documentId, String fields, String fieldset) throws ApiException {
        ApiResponse<GetCashbookEntryResponse> localVarResp = this.getCashbookEntryWithHttpInfo(companyId, documentId, fields, fieldset);
        return localVarResp.getData();
    }

    public ApiResponse<GetCashbookEntryResponse> getCashbookEntryWithHttpInfo(Integer companyId, String documentId, String fields, String fieldset) throws ApiException {
        Call localVarCall = this.getCashbookEntryValidateBeforeCall(companyId, documentId, fields, fieldset, null);
        Type localVarReturnType = new TypeToken<GetCashbookEntryResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCashbookEntryAsync(Integer companyId, String documentId, String fields, String fieldset, ApiCallback<GetCashbookEntryResponse> _callback) throws ApiException {
        Call localVarCall = this.getCashbookEntryValidateBeforeCall(companyId, documentId, fields, fieldset, _callback);
        Type localVarReturnType = new TypeToken<GetCashbookEntryResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listCashbookEntriesCall(Integer companyId, String dateFrom, String dateTo, Integer year, String type, Integer paymentAccountId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/cashbook".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (dateFrom != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("date_from", dateFrom));
        }
        if (dateTo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("date_to", dateTo));
        }
        if (year != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("year", year));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (paymentAccountId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("payment_account_id", paymentAccountId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCashbookEntriesValidateBeforeCall(Integer companyId, String dateFrom, String dateTo, Integer year, String type, Integer paymentAccountId, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling listCashbookEntries(Async)");
        }
        if (dateFrom == null) {
            throw new ApiException("Missing the required parameter 'dateFrom' when calling listCashbookEntries(Async)");
        }
        if (dateTo == null) {
            throw new ApiException("Missing the required parameter 'dateTo' when calling listCashbookEntries(Async)");
        }
        return this.listCashbookEntriesCall(companyId, dateFrom, dateTo, year, type, paymentAccountId, _callback);
    }

    public ListCashbookEntriesResponse listCashbookEntries(Integer companyId, String dateFrom, String dateTo, Integer year, String type, Integer paymentAccountId) throws ApiException {
        ApiResponse<ListCashbookEntriesResponse> localVarResp = this.listCashbookEntriesWithHttpInfo(companyId, dateFrom, dateTo, year, type, paymentAccountId);
        return localVarResp.getData();
    }

    public ApiResponse<ListCashbookEntriesResponse> listCashbookEntriesWithHttpInfo(Integer companyId, String dateFrom, String dateTo, Integer year, String type, Integer paymentAccountId) throws ApiException {
        Call localVarCall = this.listCashbookEntriesValidateBeforeCall(companyId, dateFrom, dateTo, year, type, paymentAccountId, null);
        Type localVarReturnType = new TypeToken<ListCashbookEntriesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listCashbookEntriesAsync(Integer companyId, String dateFrom, String dateTo, Integer year, String type, Integer paymentAccountId, ApiCallback<ListCashbookEntriesResponse> _callback) throws ApiException {
        Call localVarCall = this.listCashbookEntriesValidateBeforeCall(companyId, dateFrom, dateTo, year, type, paymentAccountId, _callback);
        Type localVarReturnType = new TypeToken<ListCashbookEntriesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call modifyCashbookEntryCall(Integer companyId, String documentId, ModifyCashbookEntryRequest modifyCashbookEntryRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ModifyCashbookEntryRequest localVarPostBody = modifyCashbookEntryRequest;
        String localVarPath = "/c/{company_id}/cashbook/{document_id}".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{document_id}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call modifyCashbookEntryValidateBeforeCall(Integer companyId, String documentId, ModifyCashbookEntryRequest modifyCashbookEntryRequest, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling modifyCashbookEntry(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling modifyCashbookEntry(Async)");
        }
        return this.modifyCashbookEntryCall(companyId, documentId, modifyCashbookEntryRequest, _callback);
    }

    public ModifyCashbookEntryResponse modifyCashbookEntry(Integer companyId, String documentId, ModifyCashbookEntryRequest modifyCashbookEntryRequest) throws ApiException {
        ApiResponse<ModifyCashbookEntryResponse> localVarResp = this.modifyCashbookEntryWithHttpInfo(companyId, documentId, modifyCashbookEntryRequest);
        return localVarResp.getData();
    }

    public ApiResponse<ModifyCashbookEntryResponse> modifyCashbookEntryWithHttpInfo(Integer companyId, String documentId, ModifyCashbookEntryRequest modifyCashbookEntryRequest) throws ApiException {
        Call localVarCall = this.modifyCashbookEntryValidateBeforeCall(companyId, documentId, modifyCashbookEntryRequest, null);
        Type localVarReturnType = new TypeToken<ModifyCashbookEntryResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call modifyCashbookEntryAsync(Integer companyId, String documentId, ModifyCashbookEntryRequest modifyCashbookEntryRequest, ApiCallback<ModifyCashbookEntryResponse> _callback) throws ApiException {
        Call localVarCall = this.modifyCashbookEntryValidateBeforeCall(companyId, documentId, modifyCashbookEntryRequest, _callback);
        Type localVarReturnType = new TypeToken<ModifyCashbookEntryResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

