/*
 * Decompiled with CFR 0.152.
 */
package it.dex.movingimageviewlib;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import it.dex.movingimageviewlib.DexCrossFadeImageView;
import it.dex.movingimageviewlib.R;
import it.dex.movingimageviewlib.drawing.DRAWERS;
import it.dex.movingimageviewlib.drawing.Drawer;
import it.dex.movingimageviewlib.drawing.DrawerChooser;
import it.dex.movingimageviewlib.evaluating.EVALUATORS;
import it.dex.movingimageviewlib.evaluating.Evaluator;
import it.dex.movingimageviewlib.evaluating.EvaluatorChooser;
import it.dex.movingimageviewlib.evaluating.evaluators.TimeEvaluator;
import it.dex.movingimageviewlib.generating.VALUESGENERATORS;
import it.dex.movingimageviewlib.generating.ValuesGenerator;
import it.dex.movingimageviewlib.generating.ValuesGeneratorChooser;
import it.dex.movingimageviewlib.parameters.Parameters;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DexMovingImageView
extends DexCrossFadeImageView
implements Evaluator.OnEventOccurred {
    private Parameters parameters = new Parameters();
    private Map<String, Drawer> drawers = new HashMap<String, Drawer>();
    private ValuesGenerator valuesGenerator;
    private Evaluator evaluator;
    private OnValueChanged onValueChanged;
    private Evaluator.OnEventOccurred onEventOccurred;

    public DexMovingImageView(Context context) {
        this(context, null);
    }

    public DexMovingImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DexMovingImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    public DexMovingImageView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.getParameters().setDeviceHeight(this.getContext().getResources().getDisplayMetrics().heightPixels);
        this.getParameters().setDeviceWidth(this.getContext().getResources().getDisplayMetrics().widthPixels);
        if (attrs != null) {
            TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.DexMovingImageView, 0, 0);
            int N = a.getIndexCount();
            for (int i = 0; i < N; ++i) {
                Object obj;
                Class<?> cls;
                int attr = a.getIndex(i);
                if (attr == R.styleable.DexMovingImageView_zoom) {
                    this.setZoom(a.getFloat(attr, this.getZoom()));
                    continue;
                }
                if (attr == R.styleable.DexMovingImageView_minZoom) {
                    this.setMinZoom(a.getFloat(attr, this.getMinZoom()));
                    continue;
                }
                if (attr == R.styleable.DexMovingImageView_maxZoom) {
                    this.setMaxZoom(a.getFloat(attr, this.getMaxZoom()));
                    continue;
                }
                if (attr == R.styleable.DexMovingImageView_angle) {
                    this.setAngle(a.getFloat(attr, this.getAngle()));
                    continue;
                }
                if (attr == R.styleable.DexMovingImageView_minAngle) {
                    this.setMinAngle(a.getFloat(attr, this.getMinAngle()));
                    continue;
                }
                if (attr == R.styleable.DexMovingImageView_maxAngle) {
                    this.setMaxAngle(a.getFloat(attr, this.getMaxAngle()));
                    continue;
                }
                if (attr == R.styleable.DexMovingImageView_speed) {
                    this.setFrequency(1.0f / a.getFloat(attr, this.getFrequency()) * 1000.0f);
                    continue;
                }
                if (attr == R.styleable.DexMovingImageView_drawer) {
                    if ((a.getInt(attr, 1) & 0) == 0) {
                        this.addDrawerType(DRAWERS.SCALE.getDefaultName(), DRAWERS.SCALE);
                    }
                    if ((a.getInt(attr, 0) & 1) == 1) {
                        this.addDrawerType(DRAWERS.TRANSLATE.getDefaultName(), DRAWERS.TRANSLATE);
                    }
                    if ((a.getInt(attr, 0) & 2) != 2) continue;
                    this.addDrawerType(DRAWERS.ROTATE.getDefaultName(), DRAWERS.ROTATE);
                    continue;
                }
                if (attr == R.styleable.DexMovingImageView_generator) {
                    try {
                        this.setValuesGeneratorType(VALUESGENERATORS.map(a.getInteger(attr, VALUESGENERATORS.BASE.getType())));
                    }
                    catch (IllegalArgumentException | UnsupportedOperationException e) {
                        try {
                            cls = Class.forName(a.getString(attr));
                            obj = cls.newInstance();
                            this.setValuesGenerator((ValuesGenerator)obj);
                        }
                        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                            ex.printStackTrace();
                        }
                    }
                    continue;
                }
                if (attr != R.styleable.DexMovingImageView_evaluator) continue;
                try {
                    this.setEvaluatorType(EVALUATORS.map(a.getInteger(attr, EVALUATORS.SIMPLE.getType())));
                    continue;
                }
                catch (IllegalArgumentException | UnsupportedOperationException e) {
                    try {
                        cls = Class.forName(a.getString(attr));
                        obj = cls.newInstance();
                        this.setEvaluator((Evaluator)obj);
                        continue;
                    }
                    catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            a.recycle();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.getEvaluator() != null) {
            this.getEvaluator().start();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.getEvaluator() != null) {
            this.getEvaluator().stop();
        }
    }

    public void invalidate() {
        if (this.getEvaluator() != null) {
            this.parameters.setX(this.getValuesGenerator().getX(this.getEvaluator().evaluateX((View)this)));
            this.parameters.setY(this.getValuesGenerator().getY(this.getEvaluator().evaluateY((View)this)));
            this.parameters.setZoom(this.getValuesGenerator().getZoom(this.getEvaluator().evaluateZoom((View)this, this.getParameters().getZoom()), this.getParameters().getZoom()));
            this.parameters.setAngle(this.getValuesGenerator().getAngle(this.getEvaluator().evaluateAngle((View)this, this.getParameters().getAngle()), this.getParameters().getAngle()));
        }
        super.invalidate();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.getParameters().setWidth(this.getWidth());
        this.getParameters().setHeight(this.getHeight());
    }

    protected void onDraw(Canvas canvas) {
        Set<String> set = this.drawers.keySet();
        for (String drawer : set) {
            this.drawers.get(drawer).onDraw(canvas, this.parameters);
        }
        if (this.onValueChanged != null) {
            this.onValueChanged.onValueChanged((View)this, this.parameters.getX(), this.parameters.getY(), this.parameters.getZoom(), this.parameters.getAngle());
        }
        super.onDraw(canvas);
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public void addDrawerType(String drawerName, DRAWERS moverType) throws IllegalArgumentException {
        this.addDrawer(drawerName, DrawerChooser.get(moverType));
    }

    public void removeDrawerType(String drawerName) throws IllegalArgumentException {
        this.removeDrawer(drawerName);
    }

    public ValuesGenerator getValuesGenerator() {
        return this.valuesGenerator;
    }

    public void setValuesGenerator(ValuesGenerator valuesGenerator) {
        this.valuesGenerator = valuesGenerator;
    }

    public void setValuesGeneratorType(VALUESGENERATORS valuesGeneratorType) {
        this.setValuesGenerator(ValuesGeneratorChooser.get(valuesGeneratorType, this.parameters));
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(Evaluator evaluator) {
        if (this.evaluator != null) {
            this.evaluator.stop();
        }
        if (evaluator instanceof TimeEvaluator) {
            ((TimeEvaluator)evaluator).setFrequency(this.getParameters().getFrequency());
        }
        this.evaluator = evaluator;
        evaluator.start();
    }

    public void setEvaluatorType(EVALUATORS coordinatorType) {
        this.setEvaluator(EvaluatorChooser.get(coordinatorType, (View)this, this));
    }

    public void addDrawer(String drawerName, Drawer drawer) {
        this.drawers.put(drawerName, drawer);
    }

    public boolean isDrawerAdded(DRAWERS drawerType) {
        Set<String> set = this.drawers.keySet();
        return set.contains(drawerType.getDefaultName());
    }

    public void removeDrawer(String drawerName) {
        this.drawers.remove(drawerName);
    }

    public void setOnValueChanged(OnValueChanged onValueChanged) {
        this.onValueChanged = onValueChanged;
    }

    @Override
    public void onEventOccurred(View view, Evaluator evaluator, Evaluator.EVENT_STATUS eventStatus, int occurrenceCount) {
        if (this.getOnEventOccurred() != null) {
            this.getOnEventOccurred().onEventOccurred(view, evaluator, eventStatus, occurrenceCount);
        }
    }

    public Evaluator.OnEventOccurred getOnEventOccurred() {
        return this.onEventOccurred;
    }

    public void setOnEventOccurred(Evaluator.OnEventOccurred onEventOccurred) {
        this.onEventOccurred = onEventOccurred;
    }

    public float getZoom() {
        return this.getParameters().getZoom();
    }

    public void setZoom(float zoom) {
        this.getParameters().setZoom(zoom);
        this.invalidate();
    }

    public float getAngle() {
        return this.getParameters().getAngle();
    }

    public void setAngle(float angle) {
        this.getParameters().setAngle(angle);
        this.invalidate();
    }

    public float getFrequency() {
        return this.getParameters().getFrequency();
    }

    public void setFrequency(float frequency) {
        if (this.getEvaluator() instanceof TimeEvaluator) {
            TimeEvaluator timeEvaluator = (TimeEvaluator)this.getEvaluator();
            timeEvaluator.setFrequency(frequency);
        }
    }

    public void setSpeed(float speed) {
        this.setFrequency(1.0f / speed * 1000.0f);
    }

    public float getMinZoom() {
        return this.getParameters().getMinZoom();
    }

    public void setMinZoom(float minZoom) {
        this.getParameters().setMinZoom(minZoom);
    }

    public float getMaxZoom() {
        return this.getParameters().getMaxZoom();
    }

    public void setMaxZoom(float maxZoom) {
        this.getParameters().setMaxZoom(maxZoom);
    }

    public float getMinAngle() {
        return this.getParameters().getMinAngle();
    }

    public void setMinAngle(float minAngle) {
        this.getParameters().setMinAngle(minAngle);
    }

    public float getMaxAngle() {
        return this.getParameters().getMaxAngle();
    }

    public void setMaxAngle(float maxAngle) {
        this.getParameters().setMaxAngle(maxAngle);
    }

    public static interface OnValueChanged {
        public void onValueChanged(View var1, float var2, float var3, float var4, float var5);
    }
}

