/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.tools;

import net.tinyos.message.Message;
import net.tinyos.message.MessageListener;
import net.tinyos.message.MoteIF;
import net.tinyos.packet.BuildSource;
import net.tinyos.packet.PhoenixSource;
import net.tinyos.tools.PrintfMsg;
import net.tinyos.util.Messenger;
import net.tinyos.util.PrintStreamMessenger;

public class PrintfClient
implements MessageListener {
    private MoteIF moteIF;

    public PrintfClient(MoteIF moteIF) {
        this.moteIF = moteIF;
        this.moteIF.registerListener(new PrintfMsg(), this);
    }

    public void messageReceived(int n, Message message) {
        PrintfMsg printfMsg = (PrintfMsg)message;
        for (int i = 0; i < printfMsg.totalSize_buffer(); ++i) {
            char c = (char)printfMsg.getElement_buffer(i);
            if (c == '\u0000') continue;
            System.out.print(c);
        }
    }

    private static void usage() {
        System.err.println("usage: PrintfClient [-comm <source>]");
    }

    public static void main(String[] stringArray) throws Exception {
        String string = null;
        if (stringArray.length == 2) {
            if (!stringArray[0].equals("-comm")) {
                PrintfClient.usage();
                System.exit(1);
            }
            string = stringArray[1];
        }
        PhoenixSource phoenixSource = string == null ? BuildSource.makePhoenix(PrintStreamMessenger.err) : BuildSource.makePhoenix(string, (Messenger)PrintStreamMessenger.err);
        System.out.print(phoenixSource);
        MoteIF moteIF = new MoteIF(phoenixSource);
        PrintfClient printfClient = new PrintfClient(moteIF);
    }
}

