/*
 * Decompiled with CFR 0.152.
 */
package it.bz.opendatahub.alpinebits.examples.inventory.middleware;

import it.bz.opendatahub.alpinebits.common.exception.AlpineBitsException;
import it.bz.opendatahub.alpinebits.xml.JAXBXmlToObjectConverter;
import it.bz.opendatahub.alpinebits.xml.XmlToObjectConverter;
import it.bz.opendatahub.alpinebits.xml.XmlValidationSchemaProvider;
import it.bz.opendatahub.alpinebits.xml.schema.ota.OTAHotelDescriptiveInfoRQ;
import it.bz.opendatahub.alpinebits.xml.schema.ota.OTAHotelDescriptiveInfoRS;
import java.io.InputStream;
import javax.xml.validation.Schema;

public class InventoryPullService {
    private final XmlToObjectConverter<OTAHotelDescriptiveInfoRS> converter;

    public InventoryPullService() {
        Schema schema = XmlValidationSchemaProvider.buildRngSchemaForAlpineBitsVersion((String)"2017-10");
        this.converter = new JAXBXmlToObjectConverter.Builder(OTAHotelDescriptiveInfoRS.class).schema(schema).build();
    }

    public OTAHotelDescriptiveInfoRS readInventoryBasic(OTAHotelDescriptiveInfoRQ otaHotelDescriptiveInfoRQ) {
        return this.buildResult(otaHotelDescriptiveInfoRQ, "inventory-basic-pull-sample.xml");
    }

    public OTAHotelDescriptiveInfoRS readInventoryHotelInfo(OTAHotelDescriptiveInfoRQ otaHotelDescriptiveInfoRQ) {
        return this.buildResult(otaHotelDescriptiveInfoRQ, "inventory-hotelinfo-pull-sample.xml");
    }

    private OTAHotelDescriptiveInfoRS buildResult(OTAHotelDescriptiveInfoRQ otaHotelDescriptiveInfoRQ, String resource) {
        try {
            InputStream is = InventoryPullService.class.getClassLoader().getResourceAsStream(resource);
            OTAHotelDescriptiveInfoRS otaHotelDescriptiveInfoRS = (OTAHotelDescriptiveInfoRS)this.converter.toObject(is);
            OTAHotelDescriptiveInfoRQ.HotelDescriptiveInfos.HotelDescriptiveInfo hotelDescriptiveInfo = (OTAHotelDescriptiveInfoRQ.HotelDescriptiveInfos.HotelDescriptiveInfo)otaHotelDescriptiveInfoRQ.getHotelDescriptiveInfos().getHotelDescriptiveInfos().get(0);
            String hotelName = hotelDescriptiveInfo.getHotelName();
            String hotelCode = hotelDescriptiveInfo.getHotelCode();
            OTAHotelDescriptiveInfoRS.HotelDescriptiveContents.HotelDescriptiveContent hotelDescriptiveContent = (OTAHotelDescriptiveInfoRS.HotelDescriptiveContents.HotelDescriptiveContent)otaHotelDescriptiveInfoRS.getHotelDescriptiveContents().getHotelDescriptiveContents().get(0);
            hotelDescriptiveContent.setHotelName(hotelName);
            hotelDescriptiveContent.setHotelCode(hotelCode);
            return otaHotelDescriptiveInfoRS;
        }
        catch (Exception e) {
            throw new AlpineBitsException(e.getMessage(), 500);
        }
    }
}

