/*
 * Decompiled with CFR 0.152.
 */
package it.bz.opendatahub.alpinebits.examples.inventory.middleware;

import it.bz.opendatahub.alpinebits.common.context.RequestContextKey;
import it.bz.opendatahub.alpinebits.common.exception.AlpineBitsException;
import it.bz.opendatahub.alpinebits.examples.inventory.middleware.InventoryPushService;
import it.bz.opendatahub.alpinebits.middleware.Context;
import it.bz.opendatahub.alpinebits.middleware.Key;
import it.bz.opendatahub.alpinebits.middleware.Middleware;
import it.bz.opendatahub.alpinebits.middleware.MiddlewareChain;
import it.bz.opendatahub.alpinebits.xml.schema.ota.OTAHotelDescriptiveContentNotifRQ;
import it.bz.opendatahub.alpinebits.xml.schema.ota.OTAHotelDescriptiveContentNotifRS;

public class InventoryPushMiddleware
implements Middleware {
    public static final Key<OTAHotelDescriptiveContentNotifRQ> OTA_INVENTORY_PUSH_REQUEST = Key.key((String)"inventory push request", OTAHotelDescriptiveContentNotifRQ.class);
    public static final Key<OTAHotelDescriptiveContentNotifRS> OTA_INVENTORY_PUSH_RESPONSE = Key.key((String)"inventory push response", OTAHotelDescriptiveContentNotifRS.class);

    public void handleContext(Context ctx, MiddlewareChain chain) {
        OTAHotelDescriptiveContentNotifRS response = this.invokeService(ctx);
        ctx.put(OTA_INVENTORY_PUSH_RESPONSE, (Object)response);
    }

    private OTAHotelDescriptiveContentNotifRS invokeService(Context ctx) {
        String action = (String)ctx.getOrThrow(RequestContextKey.REQUEST_ACTION);
        OTAHotelDescriptiveContentNotifRQ otaHotelDescriptiveContentNotifRQ = (OTAHotelDescriptiveContentNotifRQ)ctx.getOrThrow(OTA_INVENTORY_PUSH_REQUEST);
        InventoryPushService service = new InventoryPushService();
        if ("OTA_HotelDescriptiveContentNotif:Inventory".equals(action)) {
            return service.logInventoryBasic(otaHotelDescriptiveContentNotifRQ);
        }
        if ("OTA_HotelDescriptiveContentNotif:Info".equals(action)) {
            return service.logInventoryHotelInfo(otaHotelDescriptiveContentNotifRQ);
        }
        throw new AlpineBitsException("No implementation for action found", 500);
    }
}

