/*
 * Decompiled with CFR 0.152.
 */
package it.bz.opendatahub.alpinebits.examples.inventory.middleware;

import it.bz.opendatahub.alpinebits.common.context.RequestContextKey;
import it.bz.opendatahub.alpinebits.common.exception.AlpineBitsException;
import it.bz.opendatahub.alpinebits.db.PersistenceContextKey;
import it.bz.opendatahub.alpinebits.examples.inventory.middleware.InventoryPullService;
import it.bz.opendatahub.alpinebits.mapping.entity.inventory.HotelDescriptiveInfoRequest;
import it.bz.opendatahub.alpinebits.mapping.entity.inventory.HotelDescriptiveInfoResponse;
import it.bz.opendatahub.alpinebits.middleware.Context;
import it.bz.opendatahub.alpinebits.middleware.Key;
import it.bz.opendatahub.alpinebits.middleware.Middleware;
import it.bz.opendatahub.alpinebits.middleware.MiddlewareChain;
import javax.persistence.EntityManager;

public class InventoryPullMiddleware
implements Middleware {
    private final Key<HotelDescriptiveInfoRequest> requestKey;
    private final Key<HotelDescriptiveInfoResponse> responseKey;

    public InventoryPullMiddleware(Key<HotelDescriptiveInfoRequest> requestKey, Key<HotelDescriptiveInfoResponse> responseKey) {
        this.requestKey = requestKey;
        this.responseKey = responseKey;
    }

    public void handleContext(Context ctx, MiddlewareChain chain) {
        HotelDescriptiveInfoResponse response = this.invokeService(ctx);
        ctx.put(this.responseKey, (Object)response);
    }

    private HotelDescriptiveInfoResponse invokeService(Context ctx) {
        String action = (String)ctx.getOrThrow(RequestContextKey.REQUEST_ACTION);
        HotelDescriptiveInfoRequest hotelDescriptiveInfoRequest = (HotelDescriptiveInfoRequest)ctx.getOrThrow(this.requestKey);
        EntityManager em = (EntityManager)ctx.getOrThrow(PersistenceContextKey.ENTITY_MANAGER);
        InventoryPullService service = new InventoryPullService(em);
        if ("OTA_HotelDescriptiveInfo:Inventory".equals(action)) {
            return service.readBasic(hotelDescriptiveInfoRequest);
        }
        if ("OTA_HotelDescriptiveInfo:Info".equals(action)) {
            return service.readHotelInfo(hotelDescriptiveInfoRequest);
        }
        throw new AlpineBitsException("No implementation for action found", 500);
    }
}

