/*
 * Decompiled with CFR 0.152.
 */
package it.bz.opendatahub.alpinebits.examples.inventory.middleware;

import it.bz.opendatahub.alpinebits.common.exception.AlpineBitsException;
import it.bz.opendatahub.alpinebits.examples.inventory.entity.HotelDescriptiveContentEntity;
import it.bz.opendatahub.alpinebits.examples.inventory.entity.RoomCategoryEntity;
import it.bz.opendatahub.alpinebits.examples.inventory.mapper.HotelDescriptiveContentEntityMapperInstances;
import it.bz.opendatahub.alpinebits.examples.inventory.mapper.ImageItemEntityMapper;
import it.bz.opendatahub.alpinebits.examples.inventory.mapper.ImageItemEntityMapperInstances;
import it.bz.opendatahub.alpinebits.mapping.entity.GenericResponse;
import it.bz.opendatahub.alpinebits.mapping.entity.Warning;
import it.bz.opendatahub.alpinebits.mapping.entity.inventory.GuestRoom;
import it.bz.opendatahub.alpinebits.mapping.entity.inventory.HotelDescriptiveContent;
import it.bz.opendatahub.alpinebits.mapping.entity.inventory.HotelDescriptiveContentNotifRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;

public class InventoryPushService {
    private final EntityManager em;

    public InventoryPushService(EntityManager em) {
        this.em = em;
    }

    public GenericResponse writeBasic(HotelDescriptiveContentNotifRequest hotelDescriptiveContentNotifRequest) {
        String hotelCode = hotelDescriptiveContentNotifRequest.getHotelDescriptiveContent().getHotelCode();
        String hotelName = hotelDescriptiveContentNotifRequest.getHotelDescriptiveContent().getHotelName();
        if (hotelDescriptiveContentNotifRequest.getHotelDescriptiveContent().getGuestRooms().isEmpty()) {
            this.deleteAllRoomCategories(hotelCode, hotelName);
            return GenericResponse.success();
        }
        HotelDescriptiveContentEntity receivedHotelDescriptiveContentEntity = HotelDescriptiveContentEntityMapperInstances.HOTEL_DESCRIPTIVE_CONTENT_MAPPER.toHotelDescriptiveContentEntity(hotelDescriptiveContentNotifRequest.getHotelDescriptiveContent());
        Optional persistedHotelDescriptiveContentEntity = this.findHotelDescriptiveContentEntities(hotelCode, hotelName);
        if (persistedHotelDescriptiveContentEntity.isPresent()) {
            this.updateHotelDescriptiveContentEntity((HotelDescriptiveContentEntity)persistedHotelDescriptiveContentEntity.get(), receivedHotelDescriptiveContentEntity);
            return GenericResponse.success();
        }
        this.persistAll(receivedHotelDescriptiveContentEntity);
        return GenericResponse.success();
    }

    public GenericResponse writeHotelInfo(HotelDescriptiveContentNotifRequest hotelDescriptiveContentNotifRequest) {
        String hotelName;
        String hotelCode = hotelDescriptiveContentNotifRequest.getHotelDescriptiveContent().getHotelCode();
        Optional persistedHotelDescriptiveContentEntity = this.findHotelDescriptiveContentEntities(hotelCode, hotelName = hotelDescriptiveContentNotifRequest.getHotelDescriptiveContent().getHotelName());
        if (!persistedHotelDescriptiveContentEntity.isPresent()) {
            return GenericResponse.warning((Warning[])new Warning[]{Warning.withoutRecordId((Integer)1, (String)("No entry found for HotelCode " + hotelCode + " and HotelName " + hotelName))});
        }
        List warnings = this.updateHotelInfo((HotelDescriptiveContentEntity)persistedHotelDescriptiveContentEntity.get(), hotelDescriptiveContentNotifRequest.getHotelDescriptiveContent());
        return GenericResponse.warning((List)warnings);
    }

    private void deleteAllRoomCategories(String hotelCode, String hotelName) {
        this.findHotelDescriptiveContentEntities(hotelCode, hotelName).ifPresent(hotelDescriptiveContentEntity -> {
            EntityTransaction tx = this.em.getTransaction();
            tx.begin();
            hotelDescriptiveContentEntity.getRoomCategories().clear();
            tx.commit();
        });
    }

    private Optional<HotelDescriptiveContentEntity> findHotelDescriptiveContentEntities(String hotelCode, String hotelName) {
        List entities = this.em.createQuery("select h from HotelDescriptiveContentEntity h where h.hotelCode like :hotelCode and h.hotelName like :hotelName", HotelDescriptiveContentEntity.class).setParameter("hotelCode", (Object)hotelCode).setParameter("hotelName", (Object)hotelName).getResultList();
        if (entities.size() > 1) {
            throw new AlpineBitsException("More than one entries found for hotelCode " + hotelCode + " and hotelName " + hotelName, 500);
        }
        return entities.isEmpty() ? Optional.empty() : Optional.of(entities.get(0));
    }

    private void persistAll(HotelDescriptiveContentEntity hotelDescriptiveContentEntity) {
        EntityTransaction tx = this.em.getTransaction();
        tx.begin();
        this.em.persist((Object)hotelDescriptiveContentEntity);
        tx.commit();
    }

    private void updateHotelDescriptiveContentEntity(HotelDescriptiveContentEntity persistedEntity, HotelDescriptiveContentEntity receivedEntity) {
        EntityTransaction tx = this.em.getTransaction();
        tx.begin();
        Map persistedRoomCategoryCodes = persistedEntity.getRoomCategories().stream().collect(Collectors.toMap(RoomCategoryEntity::getCode, Function.identity()));
        for (RoomCategoryEntity roomCategory : receivedEntity.getRoomCategories()) {
            RoomCategoryEntity persistedRoomCategory = (RoomCategoryEntity)persistedRoomCategoryCodes.get(roomCategory.getCode());
            if (persistedRoomCategory != null) {
                this.updateRoomCategory(persistedRoomCategory, roomCategory);
                continue;
            }
            if (roomCategory.getGuestRoomId() != null) {
                persistedRoomCategory = (RoomCategoryEntity)persistedRoomCategoryCodes.get(roomCategory.getGuestRoomId());
                if (persistedRoomCategory == null) continue;
                persistedRoomCategory.setCode(roomCategory.getCode());
                this.updateRoomCategory(persistedRoomCategory, roomCategory);
                continue;
            }
            persistedEntity.getRoomCategories().add(roomCategory);
        }
        tx.commit();
    }

    private void updateRoomCategory(RoomCategoryEntity roomCategory, RoomCategoryEntity updates) {
        roomCategory.setMinOccupancy(updates.getMinOccupancy());
        roomCategory.setMaxOccupancy(updates.getMaxOccupancy());
        roomCategory.setMaxChildOccupancy(updates.getMaxChildOccupancy());
        roomCategory.setTypeRoom(updates.getTypeRoom());
        roomCategory.getRooms().clear();
        roomCategory.getRooms().addAll(updates.getRooms());
        roomCategory.getRoomAmenityCodes().clear();
        roomCategory.getRoomAmenityCodes().addAll(updates.getRoomAmenityCodes());
        roomCategory.getLongNames().clear();
        roomCategory.getLongNames().addAll(updates.getLongNames());
        roomCategory.getDescriptions().clear();
        roomCategory.getDescriptions().addAll(updates.getDescriptions());
        roomCategory.getPictures().clear();
        roomCategory.getPictures().addAll(updates.getPictures());
        roomCategory.getHotelInfoPictures().clear();
        roomCategory.getHotelInfoPictures().addAll(updates.getHotelInfoPictures());
    }

    private List<Warning> updateHotelInfo(HotelDescriptiveContentEntity persistedEntity, HotelDescriptiveContent receivedContent) {
        ArrayList<Warning> warnings = new ArrayList<Warning>();
        EntityTransaction tx = this.em.getTransaction();
        tx.begin();
        Map persistedRoomCategoryCodes = persistedEntity.getRoomCategories().stream().collect(Collectors.toMap(RoomCategoryEntity::getCode, Function.identity()));
        for (GuestRoom guestRoom : receivedContent.getGuestRooms()) {
            RoomCategoryEntity persistedRoomCategory = (RoomCategoryEntity)persistedRoomCategoryCodes.get(guestRoom.getCode());
            if (persistedRoomCategory == null) {
                warnings.add(Warning.withoutRecordId((Integer)1, (String)("No GuestRoom with code " + guestRoom.getCode() + " found")));
                continue;
            }
            List imageItemEntity = guestRoom.getHotelInfoPictures().stream().map(arg_0 -> ((ImageItemEntityMapper)ImageItemEntityMapperInstances.IMAGE_ITEM_ENTITY_MAPPER).toImageItemEntity(arg_0)).collect(Collectors.toList());
            persistedRoomCategory.getHotelInfoPictures().clear();
            persistedRoomCategory.getHotelInfoPictures().addAll(imageItemEntity);
        }
        tx.commit();
        return warnings;
    }
}

