/*
 * Decompiled with CFR 0.152.
 */
package it.bz.opendatahub.alpinebits.examples.inventory.mapper;

import it.bz.opendatahub.alpinebits.examples.inventory.entity.ImageItemEntity;
import it.bz.opendatahub.alpinebits.examples.inventory.entity.RoomCategoryEntity;
import it.bz.opendatahub.alpinebits.examples.inventory.entity.TextItemDescriptionEntity;
import it.bz.opendatahub.alpinebits.examples.inventory.entity.TypeRoomEntity;
import it.bz.opendatahub.alpinebits.examples.inventory.mapper.AfterRoomCategoryEntityMapping;
import it.bz.opendatahub.alpinebits.examples.inventory.mapper.ImageItemEntityMapper;
import it.bz.opendatahub.alpinebits.examples.inventory.mapper.RoomCategoryEntityMapper;
import it.bz.opendatahub.alpinebits.examples.inventory.mapper.TextItemDescriptionEntityMapper;
import it.bz.opendatahub.alpinebits.mapping.entity.inventory.GuestRoom;
import it.bz.opendatahub.alpinebits.mapping.entity.inventory.ImageItem;
import it.bz.opendatahub.alpinebits.mapping.entity.inventory.TextItemDescription;
import it.bz.opendatahub.alpinebits.mapping.entity.inventory.TypeRoom;
import java.util.ArrayList;
import java.util.List;
import org.mapstruct.factory.Mappers;

public class RoomCategoryEntityMapperImpl
implements RoomCategoryEntityMapper {
    private final AfterRoomCategoryEntityMapping afterRoomCategoryEntityMapping = (AfterRoomCategoryEntityMapping)Mappers.getMapper(AfterRoomCategoryEntityMapping.class);
    private final ImageItemEntityMapper imageItemEntityMapper = (ImageItemEntityMapper)Mappers.getMapper(ImageItemEntityMapper.class);
    private final TextItemDescriptionEntityMapper textItemDescriptionEntityMapper = (TextItemDescriptionEntityMapper)Mappers.getMapper(TextItemDescriptionEntityMapper.class);

    public RoomCategoryEntity toRoomCategoryEntity(GuestRoom guestRoom) {
        if (guestRoom == null) {
            return null;
        }
        RoomCategoryEntity roomCategoryEntity = new RoomCategoryEntity();
        roomCategoryEntity.setGuestRoomId(guestRoom.getId());
        roomCategoryEntity.setCode(guestRoom.getCode());
        roomCategoryEntity.setMinOccupancy(guestRoom.getMinOccupancy());
        roomCategoryEntity.setMaxOccupancy(guestRoom.getMaxOccupancy());
        roomCategoryEntity.setMaxChildOccupancy(guestRoom.getMaxChildOccupancy());
        roomCategoryEntity.setTypeRoom(this.typeRoomToTypeRoomEntity(guestRoom.getTypeRoom()));
        roomCategoryEntity.setLongNames(this.textItemDescriptionListToTextItemDescriptionEntityList(guestRoom.getLongNames()));
        roomCategoryEntity.setDescriptions(this.textItemDescriptionListToTextItemDescriptionEntityList(guestRoom.getDescriptions()));
        roomCategoryEntity.setPictures(this.imageItemListToImageItemEntityList(guestRoom.getPictures()));
        roomCategoryEntity.setHotelInfoPictures(this.imageItemListToImageItemEntityList(guestRoom.getHotelInfoPictures()));
        this.afterRoomCategoryEntityMapping.updateRoomCategories(roomCategoryEntity, guestRoom);
        return roomCategoryEntity;
    }

    public GuestRoom toGuestRoom(RoomCategoryEntity roomCategoryEntity) {
        if (roomCategoryEntity == null) {
            return null;
        }
        GuestRoom guestRoom = new GuestRoom();
        guestRoom.setId(roomCategoryEntity.getGuestRoomId());
        guestRoom.setCode(roomCategoryEntity.getCode());
        guestRoom.setMinOccupancy(roomCategoryEntity.getMinOccupancy());
        guestRoom.setMaxOccupancy(roomCategoryEntity.getMaxOccupancy());
        guestRoom.setMaxChildOccupancy(roomCategoryEntity.getMaxChildOccupancy());
        guestRoom.setTypeRoom(this.typeRoomEntityToTypeRoom(roomCategoryEntity.getTypeRoom()));
        guestRoom.setLongNames(this.textItemDescriptionEntityListToTextItemDescriptionList(roomCategoryEntity.getLongNames()));
        guestRoom.setDescriptions(this.textItemDescriptionEntityListToTextItemDescriptionList(roomCategoryEntity.getDescriptions()));
        guestRoom.setPictures(this.imageItemEntityListToImageItemList(roomCategoryEntity.getPictures()));
        guestRoom.setHotelInfoPictures(this.imageItemEntityListToImageItemList(roomCategoryEntity.getHotelInfoPictures()));
        return guestRoom;
    }

    protected TypeRoomEntity typeRoomToTypeRoomEntity(TypeRoom typeRoom) {
        if (typeRoom == null) {
            return null;
        }
        TypeRoomEntity typeRoomEntity = new TypeRoomEntity();
        typeRoomEntity.setStandardOccupancy(typeRoom.getStandardOccupancy());
        typeRoomEntity.setRoomClassificationCode(typeRoom.getRoomClassificationCode());
        typeRoomEntity.setSize(typeRoom.getSize());
        typeRoomEntity.setRoomId(typeRoom.getRoomId());
        return typeRoomEntity;
    }

    protected List<TextItemDescriptionEntity> textItemDescriptionListToTextItemDescriptionEntityList(List<TextItemDescription> list) {
        if (list == null) {
            return null;
        }
        ArrayList<TextItemDescriptionEntity> list1 = new ArrayList<TextItemDescriptionEntity>(list.size());
        for (TextItemDescription textItemDescription : list) {
            list1.add(this.textItemDescriptionEntityMapper.toTextItemDescriptionEntity(textItemDescription));
        }
        return list1;
    }

    protected List<ImageItemEntity> imageItemListToImageItemEntityList(List<ImageItem> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ImageItemEntity> list1 = new ArrayList<ImageItemEntity>(list.size());
        for (ImageItem imageItem : list) {
            list1.add(this.imageItemEntityMapper.toImageItemEntity(imageItem));
        }
        return list1;
    }

    protected TypeRoom typeRoomEntityToTypeRoom(TypeRoomEntity typeRoomEntity) {
        if (typeRoomEntity == null) {
            return null;
        }
        TypeRoom typeRoom = new TypeRoom();
        typeRoom.setStandardOccupancy(typeRoomEntity.getStandardOccupancy());
        typeRoom.setRoomClassificationCode(typeRoomEntity.getRoomClassificationCode());
        typeRoom.setSize(typeRoomEntity.getSize());
        typeRoom.setRoomId(typeRoomEntity.getRoomId());
        return typeRoom;
    }

    protected List<TextItemDescription> textItemDescriptionEntityListToTextItemDescriptionList(List<TextItemDescriptionEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<TextItemDescription> list1 = new ArrayList<TextItemDescription>(list.size());
        for (TextItemDescriptionEntity textItemDescriptionEntity : list) {
            list1.add(this.textItemDescriptionEntityMapper.toTextItemDescription(textItemDescriptionEntity));
        }
        return list1;
    }

    protected List<ImageItem> imageItemEntityListToImageItemList(List<ImageItemEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ImageItem> list1 = new ArrayList<ImageItem>(list.size());
        for (ImageItemEntity imageItemEntity : list) {
            list1.add(this.imageItemEntityMapper.toImageItem(imageItemEntity));
        }
        return list1;
    }
}

