package it.bz.opendatahub.alpinebits.examples.inventory.mapper;

import it.bz.opendatahub.alpinebits.examples.inventory.entity.ImageItemEntity;
import it.bz.opendatahub.alpinebits.examples.inventory.entity.RoomCategoryEntity;
import it.bz.opendatahub.alpinebits.examples.inventory.entity.TextItemDescriptionEntity;
import it.bz.opendatahub.alpinebits.examples.inventory.entity.TypeRoomEntity;
import it.bz.opendatahub.alpinebits.mapping.entity.inventory.GuestRoom;
import it.bz.opendatahub.alpinebits.mapping.entity.inventory.ImageItem;
import it.bz.opendatahub.alpinebits.mapping.entity.inventory.TextItemDescription;
import it.bz.opendatahub.alpinebits.mapping.entity.inventory.TypeRoom;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.mapstruct.factory.Mappers;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-03-10T09:00:47+0000",
    comments = "version: 1.2.0.Final, compiler: javac, environment: Java 1.8.0_212 (IcedTea)"
)
public class RoomCategoryEntityMapperImpl implements RoomCategoryEntityMapper {

    private final AfterRoomCategoryEntityMapping afterRoomCategoryEntityMapping = Mappers.getMapper( AfterRoomCategoryEntityMapping.class );
    private final ImageItemEntityMapper imageItemEntityMapper = Mappers.getMapper( ImageItemEntityMapper.class );
    private final TextItemDescriptionEntityMapper textItemDescriptionEntityMapper = Mappers.getMapper( TextItemDescriptionEntityMapper.class );

    @Override
    public RoomCategoryEntity toRoomCategoryEntity(GuestRoom guestRoom) {
        if ( guestRoom == null ) {
            return null;
        }

        RoomCategoryEntity roomCategoryEntity = new RoomCategoryEntity();

        roomCategoryEntity.setGuestRoomId( guestRoom.getId() );
        roomCategoryEntity.setCode( guestRoom.getCode() );
        roomCategoryEntity.setMinOccupancy( guestRoom.getMinOccupancy() );
        roomCategoryEntity.setMaxOccupancy( guestRoom.getMaxOccupancy() );
        roomCategoryEntity.setMaxChildOccupancy( guestRoom.getMaxChildOccupancy() );
        roomCategoryEntity.setTypeRoom( typeRoomToTypeRoomEntity( guestRoom.getTypeRoom() ) );
        roomCategoryEntity.setLongNames( textItemDescriptionListToTextItemDescriptionEntityList( guestRoom.getLongNames() ) );
        roomCategoryEntity.setDescriptions( textItemDescriptionListToTextItemDescriptionEntityList( guestRoom.getDescriptions() ) );
        roomCategoryEntity.setPictures( imageItemListToImageItemEntityList( guestRoom.getPictures() ) );
        roomCategoryEntity.setHotelInfoPictures( imageItemListToImageItemEntityList( guestRoom.getHotelInfoPictures() ) );

        afterRoomCategoryEntityMapping.updateRoomCategories( roomCategoryEntity, guestRoom );

        return roomCategoryEntity;
    }

    @Override
    public GuestRoom toGuestRoom(RoomCategoryEntity roomCategoryEntity) {
        if ( roomCategoryEntity == null ) {
            return null;
        }

        GuestRoom guestRoom = new GuestRoom();

        guestRoom.setId( roomCategoryEntity.getGuestRoomId() );
        guestRoom.setCode( roomCategoryEntity.getCode() );
        guestRoom.setMinOccupancy( roomCategoryEntity.getMinOccupancy() );
        guestRoom.setMaxOccupancy( roomCategoryEntity.getMaxOccupancy() );
        guestRoom.setMaxChildOccupancy( roomCategoryEntity.getMaxChildOccupancy() );
        guestRoom.setTypeRoom( typeRoomEntityToTypeRoom( roomCategoryEntity.getTypeRoom() ) );
        guestRoom.setLongNames( textItemDescriptionEntityListToTextItemDescriptionList( roomCategoryEntity.getLongNames() ) );
        guestRoom.setDescriptions( textItemDescriptionEntityListToTextItemDescriptionList( roomCategoryEntity.getDescriptions() ) );
        guestRoom.setPictures( imageItemEntityListToImageItemList( roomCategoryEntity.getPictures() ) );
        guestRoom.setHotelInfoPictures( imageItemEntityListToImageItemList( roomCategoryEntity.getHotelInfoPictures() ) );

        return guestRoom;
    }

    protected TypeRoomEntity typeRoomToTypeRoomEntity(TypeRoom typeRoom) {
        if ( typeRoom == null ) {
            return null;
        }

        TypeRoomEntity typeRoomEntity = new TypeRoomEntity();

        typeRoomEntity.setStandardOccupancy( typeRoom.getStandardOccupancy() );
        typeRoomEntity.setRoomClassificationCode( typeRoom.getRoomClassificationCode() );
        typeRoomEntity.setSize( typeRoom.getSize() );
        typeRoomEntity.setRoomId( typeRoom.getRoomId() );

        return typeRoomEntity;
    }

    protected List<TextItemDescriptionEntity> textItemDescriptionListToTextItemDescriptionEntityList(List<TextItemDescription> list) {
        if ( list == null ) {
            return null;
        }

        List<TextItemDescriptionEntity> list1 = new ArrayList<TextItemDescriptionEntity>( list.size() );
        for ( TextItemDescription textItemDescription : list ) {
            list1.add( textItemDescriptionEntityMapper.toTextItemDescriptionEntity( textItemDescription ) );
        }

        return list1;
    }

    protected List<ImageItemEntity> imageItemListToImageItemEntityList(List<ImageItem> list) {
        if ( list == null ) {
            return null;
        }

        List<ImageItemEntity> list1 = new ArrayList<ImageItemEntity>( list.size() );
        for ( ImageItem imageItem : list ) {
            list1.add( imageItemEntityMapper.toImageItemEntity( imageItem ) );
        }

        return list1;
    }

    protected TypeRoom typeRoomEntityToTypeRoom(TypeRoomEntity typeRoomEntity) {
        if ( typeRoomEntity == null ) {
            return null;
        }

        TypeRoom typeRoom = new TypeRoom();

        typeRoom.setStandardOccupancy( typeRoomEntity.getStandardOccupancy() );
        typeRoom.setRoomClassificationCode( typeRoomEntity.getRoomClassificationCode() );
        typeRoom.setSize( typeRoomEntity.getSize() );
        typeRoom.setRoomId( typeRoomEntity.getRoomId() );

        return typeRoom;
    }

    protected List<TextItemDescription> textItemDescriptionEntityListToTextItemDescriptionList(List<TextItemDescriptionEntity> list) {
        if ( list == null ) {
            return null;
        }

        List<TextItemDescription> list1 = new ArrayList<TextItemDescription>( list.size() );
        for ( TextItemDescriptionEntity textItemDescriptionEntity : list ) {
            list1.add( textItemDescriptionEntityMapper.toTextItemDescription( textItemDescriptionEntity ) );
        }

        return list1;
    }

    protected List<ImageItem> imageItemEntityListToImageItemList(List<ImageItemEntity> list) {
        if ( list == null ) {
            return null;
        }

        List<ImageItem> list1 = new ArrayList<ImageItem>( list.size() );
        for ( ImageItemEntity imageItemEntity : list ) {
            list1.add( imageItemEntityMapper.toImageItem( imageItemEntity ) );
        }

        return list1;
    }
}
